/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.font;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.AllMissingGlyphProvider;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.providers.GlyphProviderDefinition;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.DependencySorter;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class FontManager
implements PreparableReloadListener,
AutoCloseable {
    static final Logger f_94997_ = LogUtils.getLogger();
    private static final String f_169089_ = "fonts.json";
    public static final ResourceLocation f_94996_ = new ResourceLocation("minecraft", "missing");
    private static final FileToIdConverter f_244245_ = FileToIdConverter.m_246568_("font");
    private static final Gson f_283881_ = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final FontSet f_94998_;
    private final List<GlyphProvider> f_283839_ = new ArrayList<GlyphProvider>();
    private final Map<ResourceLocation, FontSet> f_94999_ = new HashMap<ResourceLocation, FontSet>();
    private final TextureManager f_95000_;
    private Map<ResourceLocation, ResourceLocation> f_95001_ = ImmutableMap.of();

    public FontManager(TextureManager p_95005_) {
        this.f_95000_ = p_95005_;
        this.f_94998_ = Util.m_137469_(new FontSet(p_95005_, f_94996_), p_95010_ -> p_95010_.m_95071_(Lists.newArrayList((Object[])new GlyphProvider[]{new AllMissingGlyphProvider()})));
    }

    @Override
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_285160_, ResourceManager p_285231_, ProfilerFiller p_285232_, ProfilerFiller p_285262_, Executor p_284975_, Executor p_285218_) {
        p_285232_.m_7242_();
        p_285232_.m_7241_();
        return ((CompletableFuture)this.m_284410_(p_285231_, p_284975_).thenCompose(p_285160_::m_6769_)).thenAcceptAsync(p_284609_ -> this.m_284460_((Preparation)p_284609_, p_285262_), p_285218_);
    }

    private CompletableFuture<Preparation> m_284410_(ResourceManager p_285252_, Executor p_284969_) {
        ArrayList<CompletableFuture<UnresolvedBuilderBundle>> $$2 = new ArrayList<CompletableFuture<UnresolvedBuilderBundle>>();
        for (Map.Entry<ResourceLocation, List<Resource>> $$3 : f_244245_.m_246760_(p_285252_).entrySet()) {
            ResourceLocation $$4 = f_244245_.m_245273_($$3.getKey());
            $$2.add(CompletableFuture.supplyAsync(() -> {
                List<Pair<BuilderId, GlyphProviderDefinition>> $$4 = FontManager.m_284270_((List)$$3.getValue(), $$4);
                UnresolvedBuilderBundle $$5 = new UnresolvedBuilderBundle($$4);
                for (Pair<BuilderId, GlyphProviderDefinition> $$6 : $$4) {
                    BuilderId $$7 = (BuilderId)$$6.getFirst();
                    ((GlyphProviderDefinition)$$6.getSecond()).m_285782_().ifLeft(p_286126_ -> {
                        CompletableFuture<Optional<GlyphProvider>> $$5 = this.m_284357_($$7, (GlyphProviderDefinition.Loader)p_286126_, p_285252_, p_284969_);
                        $$5.m_284288_($$7, $$5);
                    }).ifRight(p_286129_ -> $$5.m_286066_($$7, (GlyphProviderDefinition.Reference)p_286129_));
                }
                return $$5;
            }, p_284969_));
        }
        return Util.m_137567_($$2).thenCompose(p_284592_ -> {
            List $$2 = p_284592_.stream().flatMap(UnresolvedBuilderBundle::m_284148_).collect(Collectors.toCollection(ArrayList::new));
            AllMissingGlyphProvider $$3 = new AllMissingGlyphProvider();
            $$2.add(CompletableFuture.completedFuture(Optional.of($$3)));
            return Util.m_137567_($$2).thenCompose(p_284618_ -> {
                Map<ResourceLocation, List<GlyphProvider>> $$4 = this.m_284517_((List<UnresolvedBuilderBundle>)p_284592_);
                CompletableFuture[] $$5 = (CompletableFuture[])$$4.values().stream().map(p_284585_ -> CompletableFuture.runAsync(() -> this.m_284489_((List<GlyphProvider>)p_284585_, $$3), p_284969_)).toArray(CompletableFuture[]::new);
                return CompletableFuture.allOf($$5).thenApply(p_284595_ -> {
                    List<GlyphProvider> $$3 = p_284618_.stream().flatMap(Optional::stream).toList();
                    return new Preparation($$4, $$3);
                });
            });
        });
    }

    private CompletableFuture<Optional<GlyphProvider>> m_284357_(BuilderId p_285113_, GlyphProviderDefinition.Loader p_286561_, ResourceManager p_285424_, Executor p_285371_) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return Optional.of(p_286561_.m_285964_(p_285424_));
            }
            catch (Exception $$3) {
                f_94997_.warn("Failed to load builder {}, rejecting", (Object)p_285113_, (Object)$$3);
                return Optional.empty();
            }
        }, p_285371_);
    }

    private Map<ResourceLocation, List<GlyphProvider>> m_284517_(List<UnresolvedBuilderBundle> p_285282_) {
        HashMap<ResourceLocation, List<GlyphProvider>> $$1 = new HashMap<ResourceLocation, List<GlyphProvider>>();
        DependencySorter<ResourceLocation, UnresolvedBuilderBundle> $$2 = new DependencySorter<ResourceLocation, UnresolvedBuilderBundle>();
        p_285282_.forEach(p_284626_ -> $$2.m_284176_(p_284626_.f_283760_, (UnresolvedBuilderBundle)p_284626_));
        $$2.m_284430_((p_284620_, p_284621_) -> p_284621_.m_284241_($$1::get).ifPresent(p_284590_ -> $$1.put((ResourceLocation)p_284620_, (List<GlyphProvider>)p_284590_)));
        return $$1;
    }

    private void m_284489_(List<GlyphProvider> p_285520_, GlyphProvider p_285397_) {
        p_285520_.add(0, p_285397_);
        IntOpenHashSet $$2 = new IntOpenHashSet();
        for (GlyphProvider $$3 : p_285520_) {
            $$2.addAll((IntCollection)$$3.m_6990_());
        }
        $$2.forEach(p_284614_ -> {
            GlyphProvider $$2;
            if (p_284614_ == 32) {
                return;
            }
            Iterator iterator = Lists.reverse((List)p_285520_).iterator();
            while (iterator.hasNext() && ($$2 = (GlyphProvider)iterator.next()).m_214022_(p_284614_) == null) {
            }
        });
    }

    private void m_284460_(Preparation p_284939_, ProfilerFiller p_285407_) {
        p_285407_.m_7242_();
        p_285407_.m_6180_("closing");
        this.f_94999_.values().forEach(FontSet::close);
        this.f_94999_.clear();
        this.f_283839_.forEach(GlyphProvider::close);
        this.f_283839_.clear();
        p_285407_.m_6182_("reloading");
        p_284939_.f_283921_().forEach((p_284627_, p_284628_) -> {
            FontSet $$2 = new FontSet(this.f_95000_, (ResourceLocation)p_284627_);
            $$2.m_95071_(Lists.reverse((List)p_284628_));
            this.f_94999_.put((ResourceLocation)p_284627_, $$2);
        });
        this.f_283839_.addAll(p_284939_.f_283866_);
        p_285407_.m_7238_();
        p_285407_.m_7241_();
        if (!this.f_94999_.containsKey(this.m_284164_(Minecraft.f_91055_))) {
            throw new IllegalStateException("Default font failed to load");
        }
    }

    private static List<Pair<BuilderId, GlyphProviderDefinition>> m_284270_(List<Resource> p_284976_, ResourceLocation p_285272_) {
        ArrayList<Pair<BuilderId, GlyphProviderDefinition>> $$2 = new ArrayList<Pair<BuilderId, GlyphProviderDefinition>>();
        for (Resource $$3 : p_284976_) {
            try {
                BufferedReader $$4 = $$3.m_215508_();
                try {
                    JsonElement $$5 = (JsonElement)f_283881_.fromJson((Reader)$$4, JsonElement.class);
                    FontDefinitionFile $$6 = (FontDefinitionFile)Util.m_260975_(FontDefinitionFile.f_285562_.parse((DynamicOps)JsonOps.INSTANCE, (Object)$$5), JsonParseException::new);
                    List<GlyphProviderDefinition> $$7 = $$6.f_285612_;
                    for (int $$8 = $$7.size() - 1; $$8 >= 0; --$$8) {
                        BuilderId $$9 = new BuilderId(p_285272_, $$3.m_215506_(), $$8);
                        $$2.add((Pair<BuilderId, GlyphProviderDefinition>)Pair.of((Object)$$9, (Object)$$7.get($$8)));
                    }
                }
                finally {
                    if ($$4 == null) continue;
                    ((Reader)$$4).close();
                }
            }
            catch (Exception $$10) {
                f_94997_.warn("Unable to load font '{}' in {} in resourcepack: '{}'", new Object[]{p_285272_, f_169089_, $$3.m_215506_(), $$10});
            }
        }
        return $$2;
    }

    public void m_95011_(Map<ResourceLocation, ResourceLocation> p_95012_) {
        this.f_95001_ = p_95012_;
    }

    private ResourceLocation m_284164_(ResourceLocation p_285141_) {
        return this.f_95001_.getOrDefault(p_285141_, p_285141_);
    }

    public Font m_95006_() {
        return new Font(p_284586_ -> this.f_94999_.getOrDefault(this.m_284164_((ResourceLocation)p_284586_), this.f_94998_), false);
    }

    public Font m_243082_() {
        return new Font(p_284596_ -> this.f_94999_.getOrDefault(this.m_284164_((ResourceLocation)p_284596_), this.f_94998_), true);
    }

    @Override
    public void close() {
        this.f_94999_.values().forEach(FontSet::close);
        this.f_283839_.forEach(GlyphProvider::close);
        this.f_94998_.close();
    }

    record BuilderId(ResourceLocation f_283782_, String f_283885_, int f_283900_) {
        @Override
        public String toString() {
            return "(" + this.f_283782_ + ": builder #" + this.f_283900_ + " from pack " + this.f_283885_ + ")";
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BuilderId.class, "fontId;pack;index", "f_283782_", "f_283885_", "f_283900_"}, this);
        }

        @Override
        public final boolean equals(Object p_285107_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BuilderId.class, "fontId;pack;index", "f_283782_", "f_283885_", "f_283900_"}, this, p_285107_);
        }
    }

    record Preparation(Map<ResourceLocation, List<GlyphProvider>> f_283921_, List<GlyphProvider> f_283866_) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Preparation.class, "providers;allProviders", "f_283921_", "f_283866_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Preparation.class, "providers;allProviders", "f_283921_", "f_283866_"}, this);
        }

        @Override
        public final boolean equals(Object p_285059_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Preparation.class, "providers;allProviders", "f_283921_", "f_283866_"}, this, p_285059_);
        }
    }

    record FontDefinitionFile(List<GlyphProviderDefinition> f_285612_) {
        public static final Codec<FontDefinitionFile> f_285562_ = RecordCodecBuilder.create(p_286425_ -> p_286425_.group((App)GlyphProviderDefinition.f_285650_.listOf().fieldOf("providers").forGetter(FontDefinitionFile::f_285612_)).apply((Applicative)p_286425_, FontDefinitionFile::new));

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{FontDefinitionFile.class, "providers", "f_285612_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{FontDefinitionFile.class, "providers", "f_285612_"}, this);
        }

        @Override
        public final boolean equals(Object p_286874_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{FontDefinitionFile.class, "providers", "f_285612_"}, this, p_286874_);
        }
    }

    record UnresolvedBuilderBundle(ResourceLocation f_283760_, List<BuilderResult> f_283826_, Set<ResourceLocation> f_283897_) implements DependencySorter.Entry<ResourceLocation>
    {
        public UnresolvedBuilderBundle(ResourceLocation p_284984_) {
            this(p_284984_, new ArrayList<BuilderResult>(), new HashSet<ResourceLocation>());
        }

        public void m_286066_(BuilderId p_286837_, GlyphProviderDefinition.Reference p_286500_) {
            this.f_283826_.add(new BuilderResult(p_286837_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.right((Object)p_286500_.f_285563_())));
            this.f_283897_.add(p_286500_.f_285563_());
        }

        public void m_284288_(BuilderId p_284935_, CompletableFuture<Optional<GlyphProvider>> p_284966_) {
            this.f_283826_.add(new BuilderResult(p_284935_, (Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation>)Either.left(p_284966_)));
        }

        private Stream<CompletableFuture<Optional<GlyphProvider>>> m_284148_() {
            return this.f_283826_.stream().flatMap(p_285041_ -> p_285041_.f_283894_.left().stream());
        }

        public Optional<List<GlyphProvider>> m_284241_(Function<ResourceLocation, List<GlyphProvider>> p_285118_) {
            ArrayList $$1 = new ArrayList();
            for (BuilderResult $$2 : this.f_283826_) {
                Optional<List<GlyphProvider>> $$3 = $$2.m_284215_(p_285118_);
                if ($$3.isPresent()) {
                    $$1.addAll($$3.get());
                    continue;
                }
                return Optional.empty();
            }
            return Optional.of($$1);
        }

        @Override
        public void m_284213_(Consumer<ResourceLocation> p_285391_) {
            this.f_283897_.forEach(p_285391_);
        }

        @Override
        public void m_284346_(Consumer<ResourceLocation> p_285405_) {
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{UnresolvedBuilderBundle.class, "fontId;builders;dependencies", "f_283760_", "f_283826_", "f_283897_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UnresolvedBuilderBundle.class, "fontId;builders;dependencies", "f_283760_", "f_283826_", "f_283897_"}, this);
        }

        @Override
        public final boolean equals(Object p_285342_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UnresolvedBuilderBundle.class, "fontId;builders;dependencies", "f_283760_", "f_283826_", "f_283897_"}, this, p_285342_);
        }
    }

    record BuilderResult(BuilderId f_283838_, Either<CompletableFuture<Optional<GlyphProvider>>, ResourceLocation> f_283894_) {
        public Optional<List<GlyphProvider>> m_284215_(Function<ResourceLocation, List<GlyphProvider>> p_284942_) {
            return (Optional)this.f_283894_.map(p_285332_ -> ((Optional)p_285332_.join()).map(List::of), p_285367_ -> {
                List $$2 = (List)p_284942_.apply((ResourceLocation)p_285367_);
                if ($$2 == null) {
                    f_94997_.warn("Can't find font {} referenced by builder {}, either because it's missing, failed to load or is part of loading cycle", p_285367_, (Object)this.f_283838_);
                    return Optional.empty();
                }
                return Optional.of($$2);
            });
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{BuilderResult.class, "id;result", "f_283838_", "f_283894_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BuilderResult.class, "id;result", "f_283838_", "f_283894_"}, this);
        }

        @Override
        public final boolean equals(Object p_285102_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BuilderResult.class, "id;result", "f_283838_", "f_283894_"}, this, p_285102_);
        }
    }
}

