/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.MoreObjects;
import com.mojang.blaze3d.Blaze3D;
import com.mojang.blaze3d.platform.ClipboardManager;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.TextureUtil;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.InputType;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.NarratorStatus;
import net.minecraft.client.Screenshot;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.debug.GameModeSwitcherScreen;
import net.minecraft.client.gui.screens.options.controls.KeyBindsScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class KeyboardHandler {
    public static final int DEBUG_CRASH_TIME = 10000;
    private final Minecraft minecraft;
    private final ClipboardManager clipboardManager = new ClipboardManager();
    private long debugCrashKeyTime = -1L;
    private long debugCrashKeyReportedTime = -1L;
    private long debugCrashKeyReportedCount = -1L;
    private boolean handledDebugKey;

    public KeyboardHandler(Minecraft p_90875_) {
        this.minecraft = p_90875_;
    }

    private boolean handleChunkDebugKeys(int p_167814_) {
        switch (p_167814_) {
            case 69: {
                this.minecraft.sectionPath = !this.minecraft.sectionPath;
                this.debugFeedback("SectionPath: {0}", this.minecraft.sectionPath ? "shown" : "hidden");
                return true;
            }
            case 76: {
                this.minecraft.smartCull = !this.minecraft.smartCull;
                this.debugFeedback("SmartCull: {0}", this.minecraft.smartCull ? "enabled" : "disabled");
                return true;
            }
            case 85: {
                if (Screen.hasShiftDown()) {
                    this.minecraft.levelRenderer.killFrustum();
                    this.debugFeedback("Killed frustum", new Object[0]);
                } else {
                    this.minecraft.levelRenderer.captureFrustum();
                    this.debugFeedback("Captured frustum", new Object[0]);
                }
                return true;
            }
            case 86: {
                this.minecraft.sectionVisibility = !this.minecraft.sectionVisibility;
                this.debugFeedback("SectionVisibility: {0}", this.minecraft.sectionVisibility ? "enabled" : "disabled");
                return true;
            }
            case 87: {
                this.minecraft.wireframe = !this.minecraft.wireframe;
                this.debugFeedback("WireFrame: {0}", this.minecraft.wireframe ? "enabled" : "disabled");
                return true;
            }
        }
        return false;
    }

    private void debugComponent(ChatFormatting p_167825_, Component p_167826_) {
        this.minecraft.gui.getChat().addMessage(Component.empty().append(Component.translatable("debug.prefix").withStyle(p_167825_, ChatFormatting.BOLD)).append(CommonComponents.SPACE).append(p_167826_));
    }

    private void debugFeedbackComponent(Component p_167823_) {
        this.debugComponent(ChatFormatting.YELLOW, p_167823_);
    }

    private void debugFeedbackTranslated(String p_90914_, Object ... p_90915_) {
        this.debugFeedbackComponent(Component.translatableEscape(p_90914_, p_90915_));
    }

    private void debugWarningTranslated(String p_90949_, Object ... p_90950_) {
        this.debugComponent(ChatFormatting.RED, Component.translatableEscape(p_90949_, p_90950_));
    }

    private void debugFeedback(String p_167838_, Object ... p_167839_) {
        this.debugFeedbackComponent(Component.literal(MessageFormat.format(p_167838_, p_167839_)));
    }

    private boolean handleDebugKeys(int p_90933_) {
        if (this.debugCrashKeyTime > 0L && this.debugCrashKeyTime < Util.getMillis() - 100L) {
            return true;
        }
        switch (p_90933_) {
            case 65: {
                this.minecraft.levelRenderer.allChanged();
                this.debugFeedbackTranslated("debug.reload_chunks.message", new Object[0]);
                return true;
            }
            case 66: {
                boolean $$1 = !this.minecraft.getEntityRenderDispatcher().shouldRenderHitBoxes();
                this.minecraft.getEntityRenderDispatcher().setRenderHitBoxes($$1);
                this.debugFeedbackTranslated($$1 ? "debug.show_hitboxes.on" : "debug.show_hitboxes.off", new Object[0]);
                return true;
            }
            case 68: {
                if (this.minecraft.gui != null) {
                    this.minecraft.gui.getChat().clearMessages(false);
                }
                return true;
            }
            case 71: {
                boolean $$2 = this.minecraft.debugRenderer.switchRenderChunkborder();
                this.debugFeedbackTranslated($$2 ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
                return true;
            }
            case 72: {
                this.minecraft.options.advancedItemTooltips = !this.minecraft.options.advancedItemTooltips;
                this.debugFeedbackTranslated(this.minecraft.options.advancedItemTooltips ? "debug.advanced_tooltips.on" : "debug.advanced_tooltips.off", new Object[0]);
                this.minecraft.options.save();
                return true;
            }
            case 73: {
                if (!this.minecraft.player.isReducedDebugInfo()) {
                    this.copyRecreateCommand(this.minecraft.player.hasPermissions(2), !Screen.hasShiftDown());
                }
                return true;
            }
            case 78: {
                if (!this.minecraft.player.hasPermissions(2)) {
                    this.debugFeedbackTranslated("debug.creative_spectator.error", new Object[0]);
                } else if (!this.minecraft.player.isSpectator()) {
                    this.minecraft.player.connection.sendUnsignedCommand("gamemode spectator");
                } else {
                    this.minecraft.player.connection.sendUnsignedCommand("gamemode " + ((GameType)MoreObjects.firstNonNull((Object)this.minecraft.gameMode.getPreviousPlayerMode(), (Object)GameType.CREATIVE)).getName());
                }
                return true;
            }
            case 293: {
                if (!this.minecraft.player.hasPermissions(2)) {
                    this.debugFeedbackTranslated("debug.gamemodes.error", new Object[0]);
                } else {
                    this.minecraft.setScreen(new GameModeSwitcherScreen());
                }
                return true;
            }
            case 80: {
                this.minecraft.options.pauseOnLostFocus = !this.minecraft.options.pauseOnLostFocus;
                this.minecraft.options.save();
                this.debugFeedbackTranslated(this.minecraft.options.pauseOnLostFocus ? "debug.pause_focus.on" : "debug.pause_focus.off", new Object[0]);
                return true;
            }
            case 81: {
                this.debugFeedbackTranslated("debug.help.message", new Object[0]);
                ChatComponent $$3 = this.minecraft.gui.getChat();
                $$3.addMessage(Component.translatable("debug.reload_chunks.help"));
                $$3.addMessage(Component.translatable("debug.show_hitboxes.help"));
                $$3.addMessage(Component.translatable("debug.copy_location.help"));
                $$3.addMessage(Component.translatable("debug.clear_chat.help"));
                $$3.addMessage(Component.translatable("debug.chunk_boundaries.help"));
                $$3.addMessage(Component.translatable("debug.advanced_tooltips.help"));
                $$3.addMessage(Component.translatable("debug.inspect.help"));
                $$3.addMessage(Component.translatable("debug.profiling.help"));
                $$3.addMessage(Component.translatable("debug.creative_spectator.help"));
                $$3.addMessage(Component.translatable("debug.pause_focus.help"));
                $$3.addMessage(Component.translatable("debug.help.help"));
                $$3.addMessage(Component.translatable("debug.dump_dynamic_textures.help"));
                $$3.addMessage(Component.translatable("debug.reload_resourcepacks.help"));
                $$3.addMessage(Component.translatable("debug.pause.help"));
                $$3.addMessage(Component.translatable("debug.gamemodes.help"));
                return true;
            }
            case 83: {
                Path $$4 = this.minecraft.gameDirectory.toPath().toAbsolutePath();
                Path $$5 = TextureUtil.getDebugTexturePath($$4);
                this.minecraft.getTextureManager().dumpAllSheets($$5);
                MutableComponent $$6 = Component.literal($$4.relativize($$5).toString()).withStyle(ChatFormatting.UNDERLINE).withStyle(p_276097_ -> p_276097_.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, $$5.toFile().toString())));
                this.debugFeedbackTranslated("debug.dump_dynamic_textures", $$6);
                return true;
            }
            case 84: {
                this.debugFeedbackTranslated("debug.reload_resourcepacks.message", new Object[0]);
                this.minecraft.reloadResourcePacks();
                return true;
            }
            case 76: {
                if (this.minecraft.debugClientMetricsStart(this::debugFeedbackComponent)) {
                    this.debugFeedbackTranslated("debug.profiling.start", 10);
                }
                return true;
            }
            case 67: {
                if (this.minecraft.player.isReducedDebugInfo()) {
                    return false;
                }
                ClientPacketListener $$7 = this.minecraft.player.connection;
                if ($$7 == null) {
                    return false;
                }
                this.debugFeedbackTranslated("debug.copy_location.message", new Object[0]);
                this.setClipboard(String.format(Locale.ROOT, "/execute in %s run tp @s %.2f %.2f %.2f %.2f %.2f", this.minecraft.player.level().dimension().location(), this.minecraft.player.getX(), this.minecraft.player.getY(), this.minecraft.player.getZ(), Float.valueOf(this.minecraft.player.getYRot()), Float.valueOf(this.minecraft.player.getXRot())));
                return true;
            }
            case 49: {
                this.minecraft.getDebugOverlay().toggleProfilerChart();
                return true;
            }
            case 50: {
                this.minecraft.getDebugOverlay().toggleFpsCharts();
                return true;
            }
            case 51: {
                this.minecraft.getDebugOverlay().toggleNetworkCharts();
                return true;
            }
        }
        return false;
    }

    private void copyRecreateCommand(boolean p_90929_, boolean p_90930_) {
        HitResult $$2 = this.minecraft.hitResult;
        if ($$2 == null) {
            return;
        }
        switch ($$2.getType()) {
            case BLOCK: {
                BlockPos $$3 = ((BlockHitResult)$$2).getBlockPos();
                Level $$4 = this.minecraft.player.level();
                BlockState $$5 = $$4.getBlockState($$3);
                if (p_90929_) {
                    if (p_90930_) {
                        this.minecraft.player.connection.getDebugQueryHandler().queryBlockEntityTag($$3, p_90947_ -> {
                            this.copyCreateBlockCommand($$5, $$3, (CompoundTag)p_90947_);
                            this.debugFeedbackTranslated("debug.inspect.server.block", new Object[0]);
                        });
                        break;
                    }
                    BlockEntity $$6 = $$4.getBlockEntity($$3);
                    CompoundTag $$7 = $$6 != null ? $$6.saveWithoutMetadata($$4.registryAccess()) : null;
                    this.copyCreateBlockCommand($$5, $$3, $$7);
                    this.debugFeedbackTranslated("debug.inspect.client.block", new Object[0]);
                    break;
                }
                this.copyCreateBlockCommand($$5, $$3, null);
                this.debugFeedbackTranslated("debug.inspect.client.block", new Object[0]);
                break;
            }
            case ENTITY: {
                Entity $$8 = ((EntityHitResult)$$2).getEntity();
                ResourceLocation $$9 = BuiltInRegistries.ENTITY_TYPE.getKey($$8.getType());
                if (p_90929_) {
                    if (p_90930_) {
                        this.minecraft.player.connection.getDebugQueryHandler().queryEntityTag($$8.getId(), p_90921_ -> {
                            this.copyCreateEntityCommand($$9, $$8.position(), (CompoundTag)p_90921_);
                            this.debugFeedbackTranslated("debug.inspect.server.entity", new Object[0]);
                        });
                        break;
                    }
                    CompoundTag $$10 = $$8.saveWithoutId(new CompoundTag());
                    this.copyCreateEntityCommand($$9, $$8.position(), $$10);
                    this.debugFeedbackTranslated("debug.inspect.client.entity", new Object[0]);
                    break;
                }
                this.copyCreateEntityCommand($$9, $$8.position(), null);
                this.debugFeedbackTranslated("debug.inspect.client.entity", new Object[0]);
                break;
            }
        }
    }

    private void copyCreateBlockCommand(BlockState p_90900_, BlockPos p_90901_, @Nullable CompoundTag p_90902_) {
        StringBuilder $$3 = new StringBuilder(BlockStateParser.serialize(p_90900_));
        if (p_90902_ != null) {
            $$3.append(p_90902_);
        }
        String $$4 = String.format(Locale.ROOT, "/setblock %d %d %d %s", p_90901_.getX(), p_90901_.getY(), p_90901_.getZ(), $$3);
        this.setClipboard($$4);
    }

    private void copyCreateEntityCommand(ResourceLocation p_90923_, Vec3 p_90924_, @Nullable CompoundTag p_90925_) {
        String $$5;
        if (p_90925_ != null) {
            p_90925_.remove("UUID");
            p_90925_.remove("Pos");
            p_90925_.remove("Dimension");
            String $$3 = NbtUtils.toPrettyComponent(p_90925_).getString();
            String $$4 = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f %s", p_90923_, p_90924_.x, p_90924_.y, p_90924_.z, $$3);
        } else {
            $$5 = String.format(Locale.ROOT, "/summon %s %.2f %.2f %.2f", p_90923_, p_90924_.x, p_90924_.y, p_90924_.z);
        }
        this.setClipboard($$5);
    }

    public void keyPress(long p_90894_, int p_90895_, int p_90896_, int p_90897_, int p_90898_) {
        PauseScreen $$12;
        Screen screen;
        boolean $$13;
        Screen $$6;
        if (p_90894_ != this.minecraft.getWindow().getWindow()) {
            return;
        }
        boolean $$5 = InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 292);
        if (this.debugCrashKeyTime > 0L) {
            if (!InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 67) || !$$5) {
                this.debugCrashKeyTime = -1L;
            }
        } else if (InputConstants.isKeyDown(Minecraft.getInstance().getWindow().getWindow(), 67) && $$5) {
            this.handledDebugKey = true;
            this.debugCrashKeyTime = Util.getMillis();
            this.debugCrashKeyReportedTime = Util.getMillis();
            this.debugCrashKeyReportedCount = 0L;
        }
        if (($$6 = this.minecraft.screen) != null) {
            switch (p_90895_) {
                case 262: 
                case 263: 
                case 264: 
                case 265: {
                    this.minecraft.setLastInputType(InputType.KEYBOARD_ARROW);
                    break;
                }
                case 258: {
                    this.minecraft.setLastInputType(InputType.KEYBOARD_TAB);
                }
            }
        }
        if (!(p_90897_ != 1 || this.minecraft.screen instanceof KeyBindsScreen && ((KeyBindsScreen)$$6).lastKeySelection > Util.getMillis() - 20L)) {
            if (this.minecraft.options.keyFullscreen.matches(p_90895_, p_90896_)) {
                this.minecraft.getWindow().toggleFullScreen();
                this.minecraft.options.fullscreen().set(this.minecraft.getWindow().isFullscreen());
                return;
            }
            if (this.minecraft.options.keyScreenshot.matches(p_90895_, p_90896_)) {
                if (Screen.hasControlDown()) {
                    // empty if block
                }
                Screenshot.grab(this.minecraft.gameDirectory, this.minecraft.getMainRenderTarget(), p_90917_ -> this.minecraft.execute(() -> this.minecraft.gui.getChat().addMessage((Component)p_90917_)));
                return;
            }
        }
        if (p_90897_ != 0) {
            boolean $$7;
            boolean bl = $$7 = $$6 == null || !($$6.getFocused() instanceof EditBox) || !((EditBox)$$6.getFocused()).canConsumeInput();
            if ($$7) {
                if (Screen.hasControlDown() && p_90895_ == 66 && this.minecraft.getNarrator().isActive() && this.minecraft.options.narratorHotkey().get().booleanValue()) {
                    boolean $$8 = this.minecraft.options.narrator().get() == NarratorStatus.OFF;
                    this.minecraft.options.narrator().set(NarratorStatus.byId(this.minecraft.options.narrator().get().getId() + 1));
                    this.minecraft.options.save();
                    if ($$6 != null) {
                        $$6.updateNarratorStatus($$8);
                    }
                }
                LocalPlayer $$8 = this.minecraft.player;
            }
        }
        if ($$6 != null) {
            boolean[] $$9 = new boolean[]{false};
            Screen.wrapScreenError(() -> {
                if (p_90897_ == 1 || p_90897_ == 2) {
                    $$6.afterKeyboardAction();
                    p_329689_[0] = $$6.keyPressed(p_90895_, p_90896_, p_90898_);
                } else if (p_90897_ == 0) {
                    p_329689_[0] = $$6.keyReleased(p_90895_, p_90896_, p_90898_);
                }
            }, "keyPressed event handler", $$6.getClass().getCanonicalName());
            if ($$9[0]) {
                return;
            }
        }
        InputConstants.Key $$10 = InputConstants.getKey(p_90895_, p_90896_);
        boolean $$11 = this.minecraft.screen == null;
        boolean bl = $$13 = $$11 || (screen = this.minecraft.screen) instanceof PauseScreen && !($$12 = (PauseScreen)screen).showsPauseMenu();
        if (p_90897_ == 0) {
            KeyMapping.set($$10, false);
            if ($$13 && p_90895_ == 292) {
                if (this.handledDebugKey) {
                    this.handledDebugKey = false;
                } else {
                    this.minecraft.getDebugOverlay().toggleOverlay();
                }
            }
            return;
        }
        boolean $$14 = false;
        if ($$13) {
            if (p_90895_ == 293 && this.minecraft.gameRenderer != null) {
                this.minecraft.gameRenderer.togglePostEffect();
            }
            if (p_90895_ == 256) {
                this.minecraft.pauseGame($$5);
                $$14 |= $$5;
            }
            this.handledDebugKey |= ($$14 |= $$5 && this.handleDebugKeys(p_90895_));
            if (p_90895_ == 290) {
                boolean bl2 = this.minecraft.options.hideGui = !this.minecraft.options.hideGui;
            }
            if (this.minecraft.getDebugOverlay().showProfilerChart() && !$$5 && p_90895_ >= 48 && p_90895_ <= 57) {
                this.minecraft.debugFpsMeterKeyPress(p_90895_ - 48);
            }
        }
        if ($$11) {
            if ($$14) {
                KeyMapping.set($$10, false);
            } else {
                KeyMapping.set($$10, true);
                KeyMapping.click($$10);
            }
        }
    }

    private void charTyped(long p_90890_, int p_90891_, int p_90892_) {
        if (p_90890_ != this.minecraft.getWindow().getWindow()) {
            return;
        }
        Screen $$3 = this.minecraft.screen;
        if ($$3 == null || this.minecraft.getOverlay() != null) {
            return;
        }
        if (Character.charCount(p_90891_) == 1) {
            Screen.wrapScreenError(() -> $$3.charTyped((char)p_90891_, p_90892_), "charTyped event handler", $$3.getClass().getCanonicalName());
        } else {
            for (char $$4 : Character.toChars(p_90891_)) {
                Screen.wrapScreenError(() -> $$3.charTyped($$4, p_90892_), "charTyped event handler", $$3.getClass().getCanonicalName());
            }
        }
    }

    public void setup(long p_90888_) {
        InputConstants.setupKeyboardCallbacks(p_90888_, (p_90939_, p_90940_, p_90941_, p_90942_, p_90943_) -> this.minecraft.execute(() -> this.keyPress(p_90939_, p_90940_, p_90941_, p_90942_, p_90943_)), (p_90935_, p_90936_, p_90937_) -> this.minecraft.execute(() -> this.charTyped(p_90935_, p_90936_, p_90937_)));
    }

    public String getClipboard() {
        return this.clipboardManager.getClipboard(this.minecraft.getWindow().getWindow(), (p_90878_, p_90879_) -> {
            if (p_90878_ != 65545) {
                this.minecraft.getWindow().defaultErrorCallback(p_90878_, p_90879_);
            }
        });
    }

    public void setClipboard(String p_90912_) {
        if (!p_90912_.isEmpty()) {
            this.clipboardManager.setClipboard(this.minecraft.getWindow().getWindow(), p_90912_);
        }
    }

    public void tick() {
        if (this.debugCrashKeyTime > 0L) {
            long $$0 = Util.getMillis();
            long $$1 = 10000L - ($$0 - this.debugCrashKeyTime);
            long $$2 = $$0 - this.debugCrashKeyReportedTime;
            if ($$1 < 0L) {
                if (Screen.hasControlDown()) {
                    Blaze3D.youJustLostTheGame();
                }
                String $$3 = "Manually triggered debug crash";
                CrashReport $$4 = new CrashReport("Manually triggered debug crash", new Throwable("Manually triggered debug crash"));
                CrashReportCategory $$5 = $$4.addCategory("Manual crash details");
                NativeModuleLister.addCrashSection($$5);
                throw new ReportedException($$4);
            }
            if ($$2 >= 1000L) {
                if (this.debugCrashKeyReportedCount == 0L) {
                    this.debugFeedbackTranslated("debug.crash.message", new Object[0]);
                } else {
                    this.debugWarningTranslated("debug.crash.warning", Mth.ceil((float)$$1 / 1000.0f));
                }
                this.debugCrashKeyReportedTime = $$0;
                ++this.debugCrashKeyReportedCount;
            }
        }
    }
}

