/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.color.item;

import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.IdMapper;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ItemColors {
    private static final int DEFAULT = -1;
    private final IdMapper<ItemColor> itemColors = new IdMapper(32);

    public static ItemColors createDefault(BlockColors p_92684_) {
        ItemColors $$1 = new ItemColors();
        $$1.register((p_329705_, p_329706_) -> p_329706_ > 0 ? -1 : DyedItemColor.getOrDefault(p_329705_, -6265536), Items.LEATHER_HELMET, Items.LEATHER_CHESTPLATE, Items.LEATHER_LEGGINGS, Items.LEATHER_BOOTS, Items.LEATHER_HORSE_ARMOR);
        $$1.register((p_329699_, p_329700_) -> p_329700_ != 1 ? -1 : DyedItemColor.getOrDefault(p_329699_, 0), Items.WOLF_ARMOR);
        $$1.register((p_92705_, p_92706_) -> GrassColor.get(0.5, 1.0), Blocks.TALL_GRASS, Blocks.LARGE_FERN);
        $$1.register((p_329701_, p_329702_) -> {
            if (p_329702_ != 1) {
                return -1;
            }
            FireworkExplosion $$2 = p_329701_.get(DataComponents.FIREWORK_EXPLOSION);
            IntList $$3 = $$2 != null ? $$2.colors() : IntList.of();
            int $$4 = $$3.size();
            if ($$4 == 0) {
                return -7697782;
            }
            if ($$4 == 1) {
                return FastColor.ARGB32.opaque($$3.getInt(0));
            }
            int $$5 = 0;
            int $$6 = 0;
            int $$7 = 0;
            for (int $$8 = 0; $$8 < $$4; ++$$8) {
                int $$9 = $$3.getInt($$8);
                $$5 += FastColor.ARGB32.red($$9);
                $$6 += FastColor.ARGB32.green($$9);
                $$7 += FastColor.ARGB32.blue($$9);
            }
            return FastColor.ARGB32.color($$5 / $$4, $$6 / $$4, $$7 / $$4);
        }, Items.FIREWORK_STAR);
        $$1.register((p_329703_, p_329704_) -> {
            if (p_329704_ > 0) {
                return -1;
            }
            return FastColor.ARGB32.opaque(p_329703_.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY).getColor());
        }, Items.POTION, Items.SPLASH_POTION, Items.LINGERING_POTION, Items.TIPPED_ARROW);
        for (SpawnEggItem $$2 : SpawnEggItem.eggs()) {
            $$1.register((p_329708_, p_329709_) -> FastColor.ARGB32.opaque($$2.getColor(p_329709_)), $$2);
        }
        $$1.register((p_92687_, p_92688_) -> {
            BlockState $$3 = ((BlockItem)p_92687_.getItem()).getBlock().defaultBlockState();
            return p_92684_.getColor($$3, null, null, p_92688_);
        }, Blocks.GRASS_BLOCK, Blocks.SHORT_GRASS, Blocks.FERN, Blocks.VINE, Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES, Blocks.BIRCH_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.LILY_PAD);
        $$1.register((p_92696_, p_92697_) -> FoliageColor.getMangroveColor(), Blocks.MANGROVE_LEAVES);
        $$1.register((p_329710_, p_329711_) -> p_329711_ == 0 ? -1 : FastColor.ARGB32.opaque(p_329710_.getOrDefault(DataComponents.MAP_COLOR, MapItemColor.DEFAULT).rgb()), Items.FILLED_MAP);
        return $$1;
    }

    public int getColor(ItemStack p_92677_, int p_92678_) {
        ItemColor $$2 = this.itemColors.byId(BuiltInRegistries.ITEM.getId(p_92677_.getItem()));
        return $$2 == null ? -1 : $$2.getColor(p_92677_, p_92678_);
    }

    public void register(ItemColor p_92690_, ItemLike ... p_92691_) {
        for (ItemLike $$2 : p_92691_) {
            this.itemColors.addMapping(p_92690_, Item.getId($$2.asItem()));
        }
    }
}

