/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;

public interface ComponentPath {
    public static ComponentPath leaf(GuiEventListener p_265344_) {
        return new Leaf(p_265344_);
    }

    @Nullable
    public static ComponentPath path(ContainerEventHandler p_265254_, @Nullable ComponentPath p_265405_) {
        if (p_265405_ == null) {
            return null;
        }
        return new Path(p_265254_, p_265405_);
    }

    public static ComponentPath path(GuiEventListener p_265555_, ContainerEventHandler ... p_265487_) {
        ComponentPath $$2 = ComponentPath.leaf(p_265555_);
        for (ContainerEventHandler $$3 : p_265487_) {
            $$2 = ComponentPath.path($$3, $$2);
        }
        return $$2;
    }

    public GuiEventListener component();

    public void applyFocus(boolean var1);

    public record Leaf(GuiEventListener component) implements ComponentPath
    {
        @Override
        public void applyFocus(boolean p_265248_) {
            this.component.setFocused(p_265248_);
        }
    }

    public static final class Path
    extends Record
    implements ComponentPath {
        private final ContainerEventHandler component;
        private final ComponentPath childPath;

        public Path(ContainerEventHandler component, ComponentPath childPath) {
            this.component = component;
            this.childPath = childPath;
        }

        @Override
        public void applyFocus(boolean p_265230_) {
            if (!p_265230_) {
                this.component.setFocused(null);
            } else {
                this.component.setFocused(this.childPath.component());
            }
            this.childPath.applyFocus(p_265230_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Path.class, "component;childPath", "component", "childPath"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Path.class, "component;childPath", "component", "childPath"}, this);
        }

        @Override
        public final boolean equals(Object p_265602_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Path.class, "component;childPath", "component", "childPath"}, this, p_265602_);
        }

        @Override
        public ContainerEventHandler component() {
            return this.component;
        }

        public ComponentPath childPath() {
            return this.childPath;
        }

        @Override
        public /* synthetic */ GuiEventListener component() {
            return this.component();
        }
    }
}

