/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportType;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.gui.screens.DisconnectedScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.CommonListenerCookie;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.multiplayer.TransferState;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.client.resources.server.DownloadedPackSource;
import net.minecraft.client.telemetry.WorldSessionTelemetryManager;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.common.ClientCommonPacketListener;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ClientboundCustomReportDetailsPacket;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.common.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ClientboundPingPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPopPacket;
import net.minecraft.network.protocol.common.ClientboundResourcePackPushPacket;
import net.minecraft.network.protocol.common.ClientboundServerLinksPacket;
import net.minecraft.network.protocol.common.ClientboundStoreCookiePacket;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.common.custom.BrandPayload;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.common.custom.DiscardedPayload;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.realms.DisconnectedRealmsScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import org.slf4j.Logger;

public abstract class ClientCommonPacketListenerImpl
implements ClientCommonPacketListener {
    private static final Component GENERIC_DISCONNECT_MESSAGE = Component.translatable("disconnect.lost");
    private static final Logger LOGGER = LogUtils.getLogger();
    protected final Minecraft minecraft;
    protected final Connection connection;
    @Nullable
    protected final ServerData serverData;
    @Nullable
    protected String serverBrand;
    protected final WorldSessionTelemetryManager telemetryManager;
    @Nullable
    protected final Screen postDisconnectScreen;
    protected boolean isTransferring;
    @Deprecated(forRemoval=true)
    protected final boolean strictErrorHandling;
    private final List<DeferredPacket> deferredPackets = new ArrayList<DeferredPacket>();
    protected final Map<ResourceLocation, byte[]> serverCookies;
    protected Map<String, String> customReportDetails;
    protected ServerLinks serverLinks;

    protected ClientCommonPacketListenerImpl(Minecraft p_295454_, Connection p_294773_, CommonListenerCookie p_294647_) {
        this.minecraft = p_295454_;
        this.connection = p_294773_;
        this.serverData = p_294647_.serverData();
        this.serverBrand = p_294647_.serverBrand();
        this.telemetryManager = p_294647_.telemetryManager();
        this.postDisconnectScreen = p_294647_.postDisconnectScreen();
        this.serverCookies = p_294647_.serverCookies();
        this.strictErrorHandling = p_294647_.strictErrorHandling();
        this.customReportDetails = p_294647_.customReportDetails();
        this.serverLinks = p_294647_.serverLinks();
    }

    @Override
    public void onPacketError(Packet p_341624_, Exception p_341639_) {
        LOGGER.error("Failed to handle packet {}", (Object)p_341624_, (Object)p_341639_);
        Optional<Path> $$2 = this.storeDisconnectionReport(p_341624_, p_341639_);
        Optional<URI> $$3 = this.serverLinks.findKnownType(ServerLinks.KnownLinkType.BUG_REPORT).map(ServerLinks.Entry::link);
        if (this.strictErrorHandling) {
            this.connection.disconnect(new DisconnectionDetails(Component.translatable("disconnect.packetError"), $$2, $$3));
        }
    }

    @Override
    public DisconnectionDetails createDisconnectionInfo(Component p_350683_, Throwable p_350813_) {
        Optional<Path> $$2 = this.storeDisconnectionReport(null, p_350813_);
        Optional<URI> $$3 = this.serverLinks.findKnownType(ServerLinks.KnownLinkType.BUG_REPORT).map(ServerLinks.Entry::link);
        return new DisconnectionDetails(p_350683_, $$2, $$3);
    }

    private Optional<Path> storeDisconnectionReport(@Nullable Packet p_350430_, Throwable p_350533_) {
        CrashReport $$2 = CrashReport.forThrowable(p_350533_, "Packet handling error");
        PacketUtils.fillCrashReport($$2, this, p_350430_);
        Path $$3 = this.minecraft.gameDirectory.toPath().resolve("debug");
        Path $$4 = $$3.resolve("disconnect-" + Util.getFilenameFormattedDateTime() + "-client.txt");
        Optional<ServerLinks.Entry> $$5 = this.serverLinks.findKnownType(ServerLinks.KnownLinkType.BUG_REPORT);
        List<String> $$6 = $$5.map(p_351668_ -> List.of("Server bug reporting link: " + String.valueOf(p_351668_.link()))).orElse(List.of());
        if ($$2.saveToFile($$4, ReportType.NETWORK_PROTOCOL_ERROR, $$6)) {
            return Optional.of($$4);
        }
        return Optional.empty();
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> p_341905_) {
        if (ClientCommonPacketListener.super.shouldHandleMessage(p_341905_)) {
            return true;
        }
        return this.isTransferring && (p_341905_ instanceof ClientboundStoreCookiePacket || p_341905_ instanceof ClientboundTransferPacket);
    }

    @Override
    public void handleKeepAlive(ClientboundKeepAlivePacket p_295361_) {
        this.sendWhen(new ServerboundKeepAlivePacket(p_295361_.getId()), () -> !RenderSystem.isFrozenAtPollEvents(), Duration.ofMinutes(1L));
    }

    @Override
    public void handlePing(ClientboundPingPacket p_295594_) {
        PacketUtils.ensureRunningOnSameThread(p_295594_, this, this.minecraft);
        this.send(new ServerboundPongPacket(p_295594_.getId()));
    }

    @Override
    public void handleCustomPayload(ClientboundCustomPayloadPacket p_295727_) {
        CustomPacketPayload $$1 = p_295727_.payload();
        if ($$1 instanceof DiscardedPayload) {
            return;
        }
        PacketUtils.ensureRunningOnSameThread(p_295727_, this, this.minecraft);
        if ($$1 instanceof BrandPayload) {
            BrandPayload $$2 = (BrandPayload)$$1;
            this.serverBrand = $$2.brand();
            this.telemetryManager.onServerBrandReceived($$2.brand());
        } else {
            this.handleCustomPayload($$1);
        }
    }

    protected abstract void handleCustomPayload(CustomPacketPayload var1);

    @Override
    public void handleResourcePackPush(ClientboundResourcePackPushPacket p_314606_) {
        ServerData.ServerPackStatus $$5;
        PacketUtils.ensureRunningOnSameThread(p_314606_, this, this.minecraft);
        UUID $$1 = p_314606_.id();
        URL $$2 = ClientCommonPacketListenerImpl.parseResourcePackUrl(p_314606_.url());
        if ($$2 == null) {
            this.connection.send(new ServerboundResourcePackPacket($$1, ServerboundResourcePackPacket.Action.INVALID_URL));
            return;
        }
        String $$3 = p_314606_.hash();
        boolean $$4 = p_314606_.required();
        ServerData.ServerPackStatus serverPackStatus = $$5 = this.serverData != null ? this.serverData.getResourcePackStatus() : ServerData.ServerPackStatus.PROMPT;
        if ($$5 == ServerData.ServerPackStatus.PROMPT || $$4 && $$5 == ServerData.ServerPackStatus.DISABLED) {
            this.minecraft.setScreen(this.addOrUpdatePackPrompt($$1, $$2, $$3, $$4, p_314606_.prompt().orElse(null)));
        } else {
            this.minecraft.getDownloadedPackSource().pushPack($$1, $$2, $$3);
        }
    }

    @Override
    public void handleResourcePackPop(ClientboundResourcePackPopPacket p_314537_) {
        PacketUtils.ensureRunningOnSameThread(p_314537_, this, this.minecraft);
        p_314537_.id().ifPresentOrElse(p_314401_ -> this.minecraft.getDownloadedPackSource().popPack((UUID)p_314401_), () -> this.minecraft.getDownloadedPackSource().popAll());
    }

    static Component preparePackPrompt(Component p_296200_, @Nullable Component p_295584_) {
        if (p_295584_ == null) {
            return p_296200_;
        }
        return Component.translatable("multiplayer.texturePrompt.serverPrompt", p_296200_, p_295584_);
    }

    @Nullable
    private static URL parseResourcePackUrl(String p_295495_) {
        try {
            URL $$1 = new URL(p_295495_);
            String $$2 = $$1.getProtocol();
            if ("http".equals($$2) || "https".equals($$2)) {
                return $$1;
            }
        }
        catch (MalformedURLException $$3) {
            return null;
        }
        return null;
    }

    @Override
    public void handleRequestCookie(ClientboundCookieRequestPacket p_320212_) {
        PacketUtils.ensureRunningOnSameThread(p_320212_, this, this.minecraft);
        this.connection.send(new ServerboundCookieResponsePacket(p_320212_.key(), this.serverCookies.get(p_320212_.key())));
    }

    @Override
    public void handleStoreCookie(ClientboundStoreCookiePacket p_320008_) {
        PacketUtils.ensureRunningOnSameThread(p_320008_, this, this.minecraft);
        this.serverCookies.put(p_320008_.key(), p_320008_.payload());
    }

    @Override
    public void handleCustomReportDetails(ClientboundCustomReportDetailsPacket p_350638_) {
        PacketUtils.ensureRunningOnSameThread(p_350638_, this, this.minecraft);
        this.customReportDetails = p_350638_.details();
    }

    @Override
    public void handleServerLinks(ClientboundServerLinksPacket p_350990_) {
        PacketUtils.ensureRunningOnSameThread(p_350990_, this, this.minecraft);
        List<ServerLinks.UntrustedEntry> $$1 = p_350990_.links();
        ImmutableList.Builder $$2 = ImmutableList.builderWithExpectedSize((int)$$1.size());
        for (ServerLinks.UntrustedEntry $$3 : $$1) {
            try {
                URI $$4 = Util.parseAndValidateUntrustedUri($$3.link());
                $$2.add((Object)new ServerLinks.Entry($$3.type(), $$4));
            }
            catch (Exception $$5) {
                LOGGER.warn("Received invalid link for type {}:{}", new Object[]{$$3.type(), $$3.link(), $$5});
            }
        }
        this.serverLinks = new ServerLinks((List<ServerLinks.Entry>)$$2.build());
    }

    @Override
    public void handleTransfer(ClientboundTransferPacket p_320739_) {
        this.isTransferring = true;
        PacketUtils.ensureRunningOnSameThread(p_320739_, this, this.minecraft);
        if (this.serverData == null) {
            throw new IllegalStateException("Cannot transfer to server from singleplayer");
        }
        this.connection.disconnect(Component.translatable("disconnect.transfer"));
        this.connection.setReadOnly();
        this.connection.handleDisconnection();
        ServerAddress $$1 = new ServerAddress(p_320739_.host(), p_320739_.port());
        ConnectScreen.startConnecting(Objects.requireNonNullElseGet(this.postDisconnectScreen, TitleScreen::new), this.minecraft, $$1, this.serverData, false, new TransferState(this.serverCookies));
    }

    @Override
    public void handleDisconnect(ClientboundDisconnectPacket p_296159_) {
        this.connection.disconnect(p_296159_.reason());
    }

    protected void sendDeferredPackets() {
        Iterator<DeferredPacket> $$0 = this.deferredPackets.iterator();
        while ($$0.hasNext()) {
            DeferredPacket $$1 = $$0.next();
            if ($$1.sendCondition().getAsBoolean()) {
                this.send($$1.packet);
                $$0.remove();
                continue;
            }
            if ($$1.expirationTime() > Util.getMillis()) continue;
            $$0.remove();
        }
    }

    public void send(Packet<?> p_295097_) {
        this.connection.send(p_295097_);
    }

    @Override
    public void onDisconnect(DisconnectionDetails p_350760_) {
        this.telemetryManager.onDisconnect();
        this.minecraft.disconnect(this.createDisconnectScreen(p_350760_), this.isTransferring);
        LOGGER.warn("Client disconnected with reason: {}", (Object)p_350760_.reason().getString());
    }

    @Override
    public void fillListenerSpecificCrashDetails(CrashReport p_350364_, CrashReportCategory p_315011_) {
        p_315011_.setDetail("Server type", () -> this.serverData != null ? this.serverData.type().toString() : "<none>");
        p_315011_.setDetail("Server brand", () -> this.serverBrand);
        if (!this.customReportDetails.isEmpty()) {
            CrashReportCategory $$2 = p_350364_.addCategory("Custom Server Details");
            this.customReportDetails.forEach($$2::setDetail);
        }
    }

    protected Screen createDisconnectScreen(DisconnectionDetails p_350769_) {
        Screen $$1 = Objects.requireNonNullElseGet(this.postDisconnectScreen, () -> new JoinMultiplayerScreen(new TitleScreen()));
        if (this.serverData != null && this.serverData.isRealm()) {
            return new DisconnectedRealmsScreen($$1, GENERIC_DISCONNECT_MESSAGE, p_350769_.reason());
        }
        return new DisconnectedScreen($$1, GENERIC_DISCONNECT_MESSAGE, p_350769_);
    }

    @Nullable
    public String serverBrand() {
        return this.serverBrand;
    }

    private void sendWhen(Packet<? extends ServerboundPacketListener> p_296259_, BooleanSupplier p_296086_, Duration p_294812_) {
        if (p_296086_.getAsBoolean()) {
            this.send(p_296259_);
        } else {
            this.deferredPackets.add(new DeferredPacket(p_296259_, p_296086_, Util.getMillis() + p_294812_.toMillis()));
        }
    }

    private Screen addOrUpdatePackPrompt(UUID p_314948_, URL p_315012_, String p_314981_, boolean p_315013_, @Nullable Component p_314960_) {
        Screen $$5 = this.minecraft.screen;
        if ($$5 instanceof PackConfirmScreen) {
            PackConfirmScreen $$6 = (PackConfirmScreen)$$5;
            return $$6.update(this.minecraft, p_314948_, p_315012_, p_314981_, p_315013_, p_314960_);
        }
        return new PackConfirmScreen(this.minecraft, $$5, List.of(new PackConfirmScreen.PendingRequest(p_314948_, p_315012_, p_314981_)), p_315013_, p_314960_);
    }

    record DeferredPacket(Packet<? extends ServerboundPacketListener> packet, BooleanSupplier sendCondition, long expirationTime) {
    }

    class PackConfirmScreen
    extends ConfirmScreen {
        private final List<PendingRequest> requests;
        @Nullable
        private final Screen parentScreen;

        PackConfirmScreen(@Nullable Minecraft p_314973_, Screen p_315016_, List<PendingRequest> p_314994_, @Nullable boolean p_314923_, Component p_314940_) {
            super(p_315005_ -> {
                p_314973_.setScreen(p_315016_);
                DownloadedPackSource $$6 = p_314973_.getDownloadedPackSource();
                if (p_315005_) {
                    if (p_314997_.serverData != null) {
                        p_314997_.serverData.setResourcePackStatus(ServerData.ServerPackStatus.ENABLED);
                    }
                    $$6.allowServerPacks();
                } else {
                    $$6.rejectServerPacks();
                    if (p_314923_) {
                        p_314997_.connection.disconnect(Component.translatable("multiplayer.requiredTexturePrompt.disconnect"));
                    } else if (p_314997_.serverData != null) {
                        p_314997_.serverData.setResourcePackStatus(ServerData.ServerPackStatus.DISABLED);
                    }
                }
                for (PendingRequest $$7 : p_314994_) {
                    $$6.pushPack($$7.id, $$7.url, $$7.hash);
                }
                if (p_314997_.serverData != null) {
                    ServerList.saveSingleServer(p_314997_.serverData);
                }
            }, p_314923_ ? Component.translatable("multiplayer.requiredTexturePrompt.line1") : Component.translatable("multiplayer.texturePrompt.line1"), ClientCommonPacketListenerImpl.preparePackPrompt(p_314923_ ? Component.translatable("multiplayer.requiredTexturePrompt.line2").withStyle(ChatFormatting.YELLOW, ChatFormatting.BOLD) : Component.translatable("multiplayer.texturePrompt.line2"), p_314940_), p_314923_ ? CommonComponents.GUI_PROCEED : CommonComponents.GUI_YES, p_314923_ ? CommonComponents.GUI_DISCONNECT : CommonComponents.GUI_NO);
            this.requests = p_314994_;
            this.parentScreen = p_315016_;
        }

        public PackConfirmScreen update(Minecraft p_314946_, UUID p_314980_, URL p_314930_, String p_315003_, boolean p_314916_, @Nullable Component p_314991_) {
            ImmutableList $$6 = ImmutableList.builderWithExpectedSize((int)(this.requests.size() + 1)).addAll(this.requests).add((Object)new PendingRequest(p_314980_, p_314930_, p_315003_)).build();
            return new PackConfirmScreen(p_314946_, this.parentScreen, (List<PendingRequest>)$$6, p_314916_, p_314991_);
        }

        record PendingRequest(UUID id, URL url, String hash) {
        }
    }
}

