/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.ReceivingLevelScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.CommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.JigsawBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.MinecartCommandBlockEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.gui.screens.inventory.StructureBlockEditScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.resources.sounds.AmbientSoundHandler;
import net.minecraft.client.resources.sounds.BiomeAmbientSoundsHandler;
import net.minecraft.client.resources.sounds.BubbleColumnAmbientSoundHandler;
import net.minecraft.client.resources.sounds.ElytraOnPlayerSoundInstance;
import net.minecraft.client.resources.sounds.RidingMinecartSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundHandler;
import net.minecraft.client.resources.sounds.UnderwaterAmbientSoundInstances;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.StatsCounter;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Abilities;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.slf4j.Logger;

public class LocalPlayer
extends AbstractClientPlayer {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final int POSITION_REMINDER_INTERVAL = 20;
    private static final int WATER_VISION_MAX_TIME = 600;
    private static final int WATER_VISION_QUICK_TIME = 100;
    private static final float WATER_VISION_QUICK_PERCENT = 0.6f;
    private static final double SUFFOCATING_COLLISION_CHECK_SCALE = 0.35;
    private static final double MINOR_COLLISION_ANGLE_THRESHOLD_RADIAN = 0.13962633907794952;
    public final ClientPacketListener connection;
    private final StatsCounter stats;
    private final ClientRecipeBook recipeBook;
    private final List<AmbientSoundHandler> ambientSoundHandlers = Lists.newArrayList();
    private int permissionLevel = 0;
    private double xLast;
    private double yLast1;
    private double zLast;
    private float yRotLast;
    private float xRotLast;
    private boolean lastOnGround;
    private boolean crouching;
    private boolean wasShiftKeyDown;
    private boolean wasSprinting;
    private int positionReminder;
    private boolean flashOnSetHealth;
    public Input input;
    protected final Minecraft minecraft;
    protected int sprintTriggerTime;
    public float yBob;
    public float xBob;
    public float yBobO;
    public float xBobO;
    private int jumpRidingTicks;
    private float jumpRidingScale;
    public float spinningEffectIntensity;
    public float oSpinningEffectIntensity;
    private boolean startedUsingItem;
    @Nullable
    private InteractionHand usingItemHand;
    private boolean handsBusy;
    private boolean autoJumpEnabled = true;
    private int autoJumpTime;
    private boolean wasFallFlying;
    private int waterVisionTime;
    private boolean showDeathScreen = true;
    private boolean doLimitedCrafting = false;

    public LocalPlayer(Minecraft p_108621_, ClientLevel p_108622_, ClientPacketListener p_108623_, StatsCounter p_108624_, ClientRecipeBook p_108625_, boolean p_108626_, boolean p_108627_) {
        super(p_108622_, p_108623_.getLocalGameProfile());
        this.minecraft = p_108621_;
        this.connection = p_108623_;
        this.stats = p_108624_;
        this.recipeBook = p_108625_;
        this.wasShiftKeyDown = p_108626_;
        this.wasSprinting = p_108627_;
        this.ambientSoundHandlers.add(new UnderwaterAmbientSoundHandler(this, p_108621_.getSoundManager()));
        this.ambientSoundHandlers.add(new BubbleColumnAmbientSoundHandler(this));
        this.ambientSoundHandlers.add(new BiomeAmbientSoundsHandler(this, p_108621_.getSoundManager(), p_108622_.getBiomeManager()));
    }

    @Override
    public boolean hurt(DamageSource p_108662_, float p_108663_) {
        return false;
    }

    @Override
    public void heal(float p_108708_) {
    }

    @Override
    public boolean startRiding(Entity p_108667_, boolean p_108668_) {
        if (!super.startRiding(p_108667_, p_108668_)) {
            return false;
        }
        if (p_108667_ instanceof AbstractMinecart) {
            this.minecraft.getSoundManager().play(new RidingMinecartSoundInstance(this, (AbstractMinecart)p_108667_, true));
            this.minecraft.getSoundManager().play(new RidingMinecartSoundInstance(this, (AbstractMinecart)p_108667_, false));
        }
        return true;
    }

    @Override
    public void removeVehicle() {
        super.removeVehicle();
        this.handsBusy = false;
    }

    @Override
    public float getViewXRot(float p_108742_) {
        return this.getXRot();
    }

    @Override
    public float getViewYRot(float p_108753_) {
        if (this.isPassenger()) {
            return super.getViewYRot(p_108753_);
        }
        return this.getYRot();
    }

    @Override
    public void tick() {
        if (!this.level().hasChunkAt(this.getBlockX(), this.getBlockZ())) {
            return;
        }
        super.tick();
        if (this.isPassenger()) {
            this.connection.send(new ServerboundMovePlayerPacket.Rot(this.getYRot(), this.getXRot(), this.onGround()));
            this.connection.send(new ServerboundPlayerInputPacket(this.xxa, this.zza, this.input.jumping, this.input.shiftKeyDown));
            Entity $$0 = this.getRootVehicle();
            if ($$0 != this && $$0.isControlledByLocalInstance()) {
                this.connection.send(new ServerboundMoveVehiclePacket($$0));
                this.sendIsSprintingIfNeeded();
            }
        } else {
            this.sendPosition();
        }
        for (AmbientSoundHandler $$1 : this.ambientSoundHandlers) {
            $$1.tick();
        }
    }

    public float getCurrentMood() {
        for (AmbientSoundHandler $$0 : this.ambientSoundHandlers) {
            if (!($$0 instanceof BiomeAmbientSoundsHandler)) continue;
            return ((BiomeAmbientSoundsHandler)$$0).getMoodiness();
        }
        return 0.0f;
    }

    private void sendPosition() {
        this.sendIsSprintingIfNeeded();
        boolean $$0 = this.isShiftKeyDown();
        if ($$0 != this.wasShiftKeyDown) {
            ServerboundPlayerCommandPacket.Action $$1 = $$0 ? ServerboundPlayerCommandPacket.Action.PRESS_SHIFT_KEY : ServerboundPlayerCommandPacket.Action.RELEASE_SHIFT_KEY;
            this.connection.send(new ServerboundPlayerCommandPacket(this, $$1));
            this.wasShiftKeyDown = $$0;
        }
        if (this.isControlledCamera()) {
            boolean $$8;
            double $$2 = this.getX() - this.xLast;
            double $$3 = this.getY() - this.yLast1;
            double $$4 = this.getZ() - this.zLast;
            double $$5 = this.getYRot() - this.yRotLast;
            double $$6 = this.getXRot() - this.xRotLast;
            ++this.positionReminder;
            boolean $$7 = Mth.lengthSquared($$2, $$3, $$4) > Mth.square(2.0E-4) || this.positionReminder >= 20;
            boolean bl = $$8 = $$5 != 0.0 || $$6 != 0.0;
            if (this.isPassenger()) {
                Vec3 $$9 = this.getDeltaMovement();
                this.connection.send(new ServerboundMovePlayerPacket.PosRot($$9.x, -999.0, $$9.z, this.getYRot(), this.getXRot(), this.onGround()));
                $$7 = false;
            } else if ($$7 && $$8) {
                this.connection.send(new ServerboundMovePlayerPacket.PosRot(this.getX(), this.getY(), this.getZ(), this.getYRot(), this.getXRot(), this.onGround()));
            } else if ($$7) {
                this.connection.send(new ServerboundMovePlayerPacket.Pos(this.getX(), this.getY(), this.getZ(), this.onGround()));
            } else if ($$8) {
                this.connection.send(new ServerboundMovePlayerPacket.Rot(this.getYRot(), this.getXRot(), this.onGround()));
            } else if (this.lastOnGround != this.onGround()) {
                this.connection.send(new ServerboundMovePlayerPacket.StatusOnly(this.onGround()));
            }
            if ($$7) {
                this.xLast = this.getX();
                this.yLast1 = this.getY();
                this.zLast = this.getZ();
                this.positionReminder = 0;
            }
            if ($$8) {
                this.yRotLast = this.getYRot();
                this.xRotLast = this.getXRot();
            }
            this.lastOnGround = this.onGround();
            this.autoJumpEnabled = this.minecraft.options.autoJump().get();
        }
    }

    private void sendIsSprintingIfNeeded() {
        boolean $$0 = this.isSprinting();
        if ($$0 != this.wasSprinting) {
            ServerboundPlayerCommandPacket.Action $$1 = $$0 ? ServerboundPlayerCommandPacket.Action.START_SPRINTING : ServerboundPlayerCommandPacket.Action.STOP_SPRINTING;
            this.connection.send(new ServerboundPlayerCommandPacket(this, $$1));
            this.wasSprinting = $$0;
        }
    }

    public boolean drop(boolean p_108701_) {
        ServerboundPlayerActionPacket.Action $$1 = p_108701_ ? ServerboundPlayerActionPacket.Action.DROP_ALL_ITEMS : ServerboundPlayerActionPacket.Action.DROP_ITEM;
        ItemStack $$2 = this.getInventory().removeFromSelected(p_108701_);
        this.connection.send(new ServerboundPlayerActionPacket($$1, BlockPos.ZERO, Direction.DOWN));
        return !$$2.isEmpty();
    }

    @Override
    public void swing(InteractionHand p_108660_) {
        super.swing(p_108660_);
        this.connection.send(new ServerboundSwingPacket(p_108660_));
    }

    @Override
    public void respawn() {
        this.connection.send(new ServerboundClientCommandPacket(ServerboundClientCommandPacket.Action.PERFORM_RESPAWN));
        KeyMapping.resetToggleKeys();
    }

    @Override
    protected void actuallyHurt(DamageSource p_108729_, float p_108730_) {
        if (this.isInvulnerableTo(p_108729_)) {
            return;
        }
        this.setHealth(this.getHealth() - p_108730_);
    }

    @Override
    public void closeContainer() {
        this.connection.send(new ServerboundContainerClosePacket(this.containerMenu.containerId));
        this.clientSideCloseContainer();
    }

    public void clientSideCloseContainer() {
        super.closeContainer();
        this.minecraft.setScreen(null);
    }

    public void hurtTo(float p_108761_) {
        if (this.flashOnSetHealth) {
            float $$1 = this.getHealth() - p_108761_;
            if ($$1 <= 0.0f) {
                this.setHealth(p_108761_);
                if ($$1 < 0.0f) {
                    this.invulnerableTime = 10;
                }
            } else {
                this.lastHurt = $$1;
                this.invulnerableTime = 20;
                this.setHealth(p_108761_);
                this.hurtTime = this.hurtDuration = 10;
            }
        } else {
            this.setHealth(p_108761_);
            this.flashOnSetHealth = true;
        }
    }

    @Override
    public void onUpdateAbilities() {
        this.connection.send(new ServerboundPlayerAbilitiesPacket(this.getAbilities()));
    }

    @Override
    public boolean isLocalPlayer() {
        return true;
    }

    @Override
    public boolean isSuppressingSlidingDownLadder() {
        return !this.getAbilities().flying && super.isSuppressingSlidingDownLadder();
    }

    @Override
    public boolean canSpawnSprintParticle() {
        return !this.getAbilities().flying && super.canSpawnSprintParticle();
    }

    protected void sendRidingJump() {
        this.connection.send(new ServerboundPlayerCommandPacket(this, ServerboundPlayerCommandPacket.Action.START_RIDING_JUMP, Mth.floor(this.getJumpRidingScale() * 100.0f)));
    }

    public void sendOpenInventory() {
        this.connection.send(new ServerboundPlayerCommandPacket(this, ServerboundPlayerCommandPacket.Action.OPEN_INVENTORY));
    }

    public StatsCounter getStats() {
        return this.stats;
    }

    public ClientRecipeBook getRecipeBook() {
        return this.recipeBook;
    }

    public void removeRecipeHighlight(RecipeHolder<?> p_300983_) {
        if (this.recipeBook.willHighlight(p_300983_)) {
            this.recipeBook.removeHighlight(p_300983_);
            this.connection.send(new ServerboundRecipeBookSeenRecipePacket(p_300983_));
        }
    }

    @Override
    protected int getPermissionLevel() {
        return this.permissionLevel;
    }

    public void setPermissionLevel(int p_108649_) {
        this.permissionLevel = p_108649_;
    }

    @Override
    public void displayClientMessage(Component p_108696_, boolean p_108697_) {
        this.minecraft.getChatListener().handleSystemMessage(p_108696_, p_108697_);
    }

    private void moveTowardsClosestSpace(double p_108705_, double p_108706_) {
        Direction[] $$7;
        BlockPos $$2 = BlockPos.containing(p_108705_, this.getY(), p_108706_);
        if (!this.suffocatesAt($$2)) {
            return;
        }
        double $$3 = p_108705_ - (double)$$2.getX();
        double $$4 = p_108706_ - (double)$$2.getZ();
        Direction $$5 = null;
        double $$6 = Double.MAX_VALUE;
        for (Direction $$8 : $$7 = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}) {
            double $$10;
            double $$9 = $$8.getAxis().choose($$3, 0.0, $$4);
            double d = $$10 = $$8.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1.0 - $$9 : $$9;
            if (!($$10 < $$6) || this.suffocatesAt($$2.relative($$8))) continue;
            $$6 = $$10;
            $$5 = $$8;
        }
        if ($$5 != null) {
            Vec3 $$11 = this.getDeltaMovement();
            if ($$5.getAxis() == Direction.Axis.X) {
                this.setDeltaMovement(0.1 * (double)$$5.getStepX(), $$11.y, $$11.z);
            } else {
                this.setDeltaMovement($$11.x, $$11.y, 0.1 * (double)$$5.getStepZ());
            }
        }
    }

    private boolean suffocatesAt(BlockPos p_108747_) {
        AABB $$1 = this.getBoundingBox();
        AABB $$2 = new AABB(p_108747_.getX(), $$1.minY, p_108747_.getZ(), (double)p_108747_.getX() + 1.0, $$1.maxY, (double)p_108747_.getZ() + 1.0).deflate(1.0E-7);
        return this.level().collidesWithSuffocatingBlock(this, $$2);
    }

    public void setExperienceValues(float p_108645_, int p_108646_, int p_108647_) {
        this.experienceProgress = p_108645_;
        this.totalExperience = p_108646_;
        this.experienceLevel = p_108647_;
    }

    @Override
    public void sendSystemMessage(Component p_234129_) {
        this.minecraft.gui.getChat().addMessage(p_234129_);
    }

    @Override
    public void handleEntityEvent(byte p_108643_) {
        if (p_108643_ >= 24 && p_108643_ <= 28) {
            this.setPermissionLevel(p_108643_ - 24);
        } else {
            super.handleEntityEvent(p_108643_);
        }
    }

    public void setShowDeathScreen(boolean p_108712_) {
        this.showDeathScreen = p_108712_;
    }

    public boolean shouldShowDeathScreen() {
        return this.showDeathScreen;
    }

    public void setDoLimitedCrafting(boolean p_302021_) {
        this.doLimitedCrafting = p_302021_;
    }

    public boolean getDoLimitedCrafting() {
        return this.doLimitedCrafting;
    }

    @Override
    public void playSound(SoundEvent p_108651_, float p_108652_, float p_108653_) {
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), p_108651_, this.getSoundSource(), p_108652_, p_108653_, false);
    }

    @Override
    public void playNotifySound(SoundEvent p_108655_, SoundSource p_108656_, float p_108657_, float p_108658_) {
        this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), p_108655_, p_108656_, p_108657_, p_108658_, false);
    }

    @Override
    public boolean isEffectiveAi() {
        return true;
    }

    @Override
    public void startUsingItem(InteractionHand p_108718_) {
        ItemStack $$1 = this.getItemInHand(p_108718_);
        if ($$1.isEmpty() || this.isUsingItem()) {
            return;
        }
        super.startUsingItem(p_108718_);
        this.startedUsingItem = true;
        this.usingItemHand = p_108718_;
    }

    @Override
    public boolean isUsingItem() {
        return this.startedUsingItem;
    }

    @Override
    public void stopUsingItem() {
        super.stopUsingItem();
        this.startedUsingItem = false;
    }

    @Override
    public InteractionHand getUsedItemHand() {
        return Objects.requireNonNullElse(this.usingItemHand, InteractionHand.MAIN_HAND);
    }

    @Override
    public void onSyncedDataUpdated(EntityDataAccessor<?> p_108699_) {
        super.onSyncedDataUpdated(p_108699_);
        if (DATA_LIVING_ENTITY_FLAGS.equals(p_108699_)) {
            InteractionHand $$2;
            boolean $$1 = ((Byte)this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 1) > 0;
            InteractionHand interactionHand = $$2 = ((Byte)this.entityData.get(DATA_LIVING_ENTITY_FLAGS) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            if ($$1 && !this.startedUsingItem) {
                this.startUsingItem($$2);
            } else if (!$$1 && this.startedUsingItem) {
                this.stopUsingItem();
            }
        }
        if (DATA_SHARED_FLAGS_ID.equals(p_108699_) && this.isFallFlying() && !this.wasFallFlying) {
            this.minecraft.getSoundManager().play(new ElytraOnPlayerSoundInstance(this));
        }
    }

    @Nullable
    public PlayerRideableJumping jumpableVehicle() {
        PlayerRideableJumping $$0;
        Entity entity = this.getControlledVehicle();
        return entity instanceof PlayerRideableJumping && ($$0 = (PlayerRideableJumping)((Object)entity)).canJump() ? $$0 : null;
    }

    public float getJumpRidingScale() {
        return this.jumpRidingScale;
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.minecraft.isTextFilteringEnabled();
    }

    @Override
    public void openTextEdit(SignBlockEntity p_277970_, boolean p_277980_) {
        if (p_277970_ instanceof HangingSignBlockEntity) {
            HangingSignBlockEntity $$2 = (HangingSignBlockEntity)p_277970_;
            this.minecraft.setScreen(new HangingSignEditScreen($$2, p_277980_, this.minecraft.isTextFilteringEnabled()));
        } else {
            this.minecraft.setScreen(new SignEditScreen(p_277970_, p_277980_, this.minecraft.isTextFilteringEnabled()));
        }
    }

    @Override
    public void openMinecartCommandBlock(BaseCommandBlock p_108678_) {
        this.minecraft.setScreen(new MinecartCommandBlockEditScreen(p_108678_));
    }

    @Override
    public void openCommandBlock(CommandBlockEntity p_108680_) {
        this.minecraft.setScreen(new CommandBlockEditScreen(p_108680_));
    }

    @Override
    public void openStructureBlock(StructureBlockEntity p_108686_) {
        this.minecraft.setScreen(new StructureBlockEditScreen(p_108686_));
    }

    @Override
    public void openJigsawBlock(JigsawBlockEntity p_108682_) {
        this.minecraft.setScreen(new JigsawBlockEditScreen(p_108682_));
    }

    @Override
    public void openItemGui(ItemStack p_108673_, InteractionHand p_108674_) {
        if (p_108673_.is(Items.WRITABLE_BOOK)) {
            this.minecraft.setScreen(new BookEditScreen(this, p_108673_, p_108674_));
        }
    }

    @Override
    public void crit(Entity p_108665_) {
        this.minecraft.particleEngine.createTrackingEmitter(p_108665_, ParticleTypes.CRIT);
    }

    @Override
    public void magicCrit(Entity p_108710_) {
        this.minecraft.particleEngine.createTrackingEmitter(p_108710_, ParticleTypes.ENCHANTED_HIT);
    }

    @Override
    public boolean isShiftKeyDown() {
        return this.input != null && this.input.shiftKeyDown;
    }

    @Override
    public boolean isCrouching() {
        return this.crouching;
    }

    public boolean isMovingSlowly() {
        return this.isCrouching() || this.isVisuallyCrawling();
    }

    @Override
    public void serverAiStep() {
        super.serverAiStep();
        if (this.isControlledCamera()) {
            this.xxa = this.input.leftImpulse;
            this.zza = this.input.forwardImpulse;
            this.jumping = this.input.jumping;
            this.yBobO = this.yBob;
            this.xBobO = this.xBob;
            this.xBob += (this.getXRot() - this.xBob) * 0.5f;
            this.yBob += (this.getYRot() - this.yBob) * 0.5f;
        }
    }

    protected boolean isControlledCamera() {
        return this.minecraft.getCameraEntity() == this;
    }

    public void resetPos() {
        this.setPose(Pose.STANDING);
        if (this.level() != null) {
            for (double $$0 = this.getY(); $$0 > (double)this.level().getMinBuildHeight() && $$0 < (double)this.level().getMaxBuildHeight(); $$0 += 1.0) {
                this.setPos(this.getX(), $$0, this.getZ());
                if (this.level().noCollision(this)) break;
            }
            this.setDeltaMovement(Vec3.ZERO);
            this.setXRot(0.0f);
        }
        this.setHealth(this.getMaxHealth());
        this.deathTime = 0;
    }

    @Override
    public void aiStep() {
        PlayerRideableJumping $$15;
        ItemStack $$12;
        boolean $$8;
        if (this.sprintTriggerTime > 0) {
            --this.sprintTriggerTime;
        }
        if (!(this.minecraft.screen instanceof ReceivingLevelScreen)) {
            this.handleConfusionTransitionEffect(this.getActivePortalLocalTransition() == Portal.Transition.CONFUSION);
            this.processPortalCooldown();
        }
        boolean $$0 = this.input.jumping;
        boolean $$1 = this.input.shiftKeyDown;
        boolean $$2 = this.hasEnoughImpulseToStartSprinting();
        Abilities $$3 = this.getAbilities();
        this.crouching = !$$3.flying && !this.isSwimming() && !this.isPassenger() && this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.CROUCHING) && (this.isShiftKeyDown() || !this.isSleeping() && !this.canPlayerFitWithinBlocksAndEntitiesWhen(Pose.STANDING));
        float $$4 = (float)this.getAttributeValue(Attributes.SNEAKING_SPEED);
        this.input.tick(this.isMovingSlowly(), $$4);
        this.minecraft.getTutorial().onInput(this.input);
        if (this.isUsingItem() && !this.isPassenger()) {
            this.input.leftImpulse *= 0.2f;
            this.input.forwardImpulse *= 0.2f;
            this.sprintTriggerTime = 0;
        }
        boolean $$5 = false;
        if (this.autoJumpTime > 0) {
            --this.autoJumpTime;
            $$5 = true;
            this.input.jumping = true;
        }
        if (!this.noPhysics) {
            this.moveTowardsClosestSpace(this.getX() - (double)this.getBbWidth() * 0.35, this.getZ() + (double)this.getBbWidth() * 0.35);
            this.moveTowardsClosestSpace(this.getX() - (double)this.getBbWidth() * 0.35, this.getZ() - (double)this.getBbWidth() * 0.35);
            this.moveTowardsClosestSpace(this.getX() + (double)this.getBbWidth() * 0.35, this.getZ() - (double)this.getBbWidth() * 0.35);
            this.moveTowardsClosestSpace(this.getX() + (double)this.getBbWidth() * 0.35, this.getZ() + (double)this.getBbWidth() * 0.35);
        }
        if ($$1) {
            this.sprintTriggerTime = 0;
        }
        boolean $$6 = this.canStartSprinting();
        boolean $$7 = this.isPassenger() ? this.getVehicle().onGround() : this.onGround();
        boolean bl = $$8 = !$$1 && !$$2;
        if (($$7 || this.isUnderWater()) && $$8 && $$6) {
            if (this.sprintTriggerTime > 0 || this.minecraft.options.keySprint.isDown()) {
                this.setSprinting(true);
            } else {
                this.sprintTriggerTime = 7;
            }
        }
        if ((!this.isInWater() || this.isUnderWater()) && $$6 && this.minecraft.options.keySprint.isDown()) {
            this.setSprinting(true);
        }
        if (this.isSprinting()) {
            boolean $$10;
            boolean $$9 = !this.input.hasForwardImpulse() || !this.hasEnoughFoodToStartSprinting();
            boolean bl2 = $$10 = $$9 || this.horizontalCollision && !this.minorHorizontalCollision || this.isInWater() && !this.isUnderWater();
            if (this.isSwimming()) {
                if (!this.onGround() && !this.input.shiftKeyDown && $$9 || !this.isInWater()) {
                    this.setSprinting(false);
                }
            } else if ($$10) {
                this.setSprinting(false);
            }
        }
        boolean $$11 = false;
        if ($$3.mayfly) {
            if (this.minecraft.gameMode.isAlwaysFlying()) {
                if (!$$3.flying) {
                    $$3.flying = true;
                    $$11 = true;
                    this.onUpdateAbilities();
                }
            } else if (!$$0 && this.input.jumping && !$$5) {
                if (this.jumpTriggerTime == 0) {
                    this.jumpTriggerTime = 7;
                } else if (!this.isSwimming()) {
                    boolean bl3 = $$3.flying = !$$3.flying;
                    if ($$3.flying && this.onGround()) {
                        this.jumpFromGround();
                    }
                    $$11 = true;
                    this.onUpdateAbilities();
                    this.jumpTriggerTime = 0;
                }
            }
        }
        if (this.input.jumping && !$$11 && !$$0 && !$$3.flying && !this.isPassenger() && !this.onClimbable() && ($$12 = this.getItemBySlot(EquipmentSlot.CHEST)).is(Items.ELYTRA) && ElytraItem.isFlyEnabled($$12) && this.tryToStartFallFlying()) {
            this.connection.send(new ServerboundPlayerCommandPacket(this, ServerboundPlayerCommandPacket.Action.START_FALL_FLYING));
        }
        this.wasFallFlying = this.isFallFlying();
        if (this.isInWater() && this.input.shiftKeyDown && this.isAffectedByFluids()) {
            this.goDownInWater();
        }
        if (this.isEyeInFluid(FluidTags.WATER)) {
            int $$13 = this.isSpectator() ? 10 : 1;
            this.waterVisionTime = Mth.clamp(this.waterVisionTime + $$13, 0, 600);
        } else if (this.waterVisionTime > 0) {
            this.isEyeInFluid(FluidTags.WATER);
            this.waterVisionTime = Mth.clamp(this.waterVisionTime - 10, 0, 600);
        }
        if ($$3.flying && this.isControlledCamera()) {
            int $$14 = 0;
            if (this.input.shiftKeyDown) {
                --$$14;
            }
            if (this.input.jumping) {
                ++$$14;
            }
            if ($$14 != 0) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, (float)$$14 * $$3.getFlyingSpeed() * 3.0f, 0.0));
            }
        }
        if (($$15 = this.jumpableVehicle()) != null && $$15.getJumpCooldown() == 0) {
            if (this.jumpRidingTicks < 0) {
                ++this.jumpRidingTicks;
                if (this.jumpRidingTicks == 0) {
                    this.jumpRidingScale = 0.0f;
                }
            }
            if ($$0 && !this.input.jumping) {
                this.jumpRidingTicks = -10;
                $$15.onPlayerJump(Mth.floor(this.getJumpRidingScale() * 100.0f));
                this.sendRidingJump();
            } else if (!$$0 && this.input.jumping) {
                this.jumpRidingTicks = 0;
                this.jumpRidingScale = 0.0f;
            } else if ($$0) {
                ++this.jumpRidingTicks;
                this.jumpRidingScale = this.jumpRidingTicks < 10 ? (float)this.jumpRidingTicks * 0.1f : 0.8f + 2.0f / (float)(this.jumpRidingTicks - 9) * 0.1f;
            }
        } else {
            this.jumpRidingScale = 0.0f;
        }
        super.aiStep();
        if (this.onGround() && $$3.flying && !this.minecraft.gameMode.isAlwaysFlying()) {
            $$3.flying = false;
            this.onUpdateAbilities();
        }
    }

    public Portal.Transition getActivePortalLocalTransition() {
        return this.portalProcess == null ? Portal.Transition.NONE : this.portalProcess.getPortalLocalTransition();
    }

    @Override
    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 20) {
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    private void handleConfusionTransitionEffect(boolean p_350372_) {
        this.oSpinningEffectIntensity = this.spinningEffectIntensity;
        float $$1 = 0.0f;
        if (p_350372_ && this.portalProcess != null && this.portalProcess.isInsidePortalThisTick()) {
            if (!(this.minecraft.screen == null || this.minecraft.screen.isPauseScreen() || this.minecraft.screen instanceof DeathScreen || this.minecraft.screen instanceof WinScreen)) {
                if (this.minecraft.screen instanceof AbstractContainerScreen) {
                    this.closeContainer();
                }
                this.minecraft.setScreen(null);
            }
            if (this.spinningEffectIntensity == 0.0f) {
                this.minecraft.getSoundManager().play(SimpleSoundInstance.forLocalAmbience(SoundEvents.PORTAL_TRIGGER, this.random.nextFloat() * 0.4f + 0.8f, 0.25f));
            }
            $$1 = 0.0125f;
            this.portalProcess.setAsInsidePortalThisTick(false);
        } else if (this.hasEffect(MobEffects.CONFUSION) && !this.getEffect(MobEffects.CONFUSION).endsWithin(60)) {
            $$1 = 0.006666667f;
        } else if (this.spinningEffectIntensity > 0.0f) {
            $$1 = -0.05f;
        }
        this.spinningEffectIntensity = Mth.clamp(this.spinningEffectIntensity + $$1, 0.0f, 1.0f);
    }

    @Override
    public void rideTick() {
        super.rideTick();
        this.handsBusy = false;
        Entity entity = this.getControlledVehicle();
        if (entity instanceof Boat) {
            Boat $$0 = (Boat)entity;
            $$0.setInput(this.input.left, this.input.right, this.input.up, this.input.down);
            this.handsBusy |= this.input.left || this.input.right || this.input.up || this.input.down;
        }
    }

    public boolean isHandsBusy() {
        return this.handsBusy;
    }

    @Override
    @Nullable
    public MobEffectInstance removeEffectNoUpdate(Holder<MobEffect> p_316634_) {
        if (p_316634_.is(MobEffects.CONFUSION)) {
            this.oSpinningEffectIntensity = 0.0f;
            this.spinningEffectIntensity = 0.0f;
        }
        return super.removeEffectNoUpdate(p_316634_);
    }

    @Override
    public void move(MoverType p_108670_, Vec3 p_108671_) {
        double $$2 = this.getX();
        double $$3 = this.getZ();
        super.move(p_108670_, p_108671_);
        this.updateAutoJump((float)(this.getX() - $$2), (float)(this.getZ() - $$3));
    }

    public boolean isAutoJumpEnabled() {
        return this.autoJumpEnabled;
    }

    protected void updateAutoJump(float p_108744_, float p_108745_) {
        if (!this.canAutoJump()) {
            return;
        }
        Vec3 $$2 = this.position();
        Vec3 $$3 = $$2.add(p_108744_, 0.0, p_108745_);
        Vec3 $$4 = new Vec3(p_108744_, 0.0, p_108745_);
        float $$5 = this.getSpeed();
        float $$6 = (float)$$4.lengthSqr();
        if ($$6 <= 0.001f) {
            Vec2 $$7 = this.input.getMoveVector();
            float $$8 = $$5 * $$7.x;
            float $$9 = $$5 * $$7.y;
            float $$10 = Mth.sin(this.getYRot() * ((float)Math.PI / 180));
            float $$11 = Mth.cos(this.getYRot() * ((float)Math.PI / 180));
            $$4 = new Vec3($$8 * $$11 - $$9 * $$10, $$4.y, $$9 * $$11 + $$8 * $$10);
            $$6 = (float)$$4.lengthSqr();
            if ($$6 <= 0.001f) {
                return;
            }
        }
        float $$12 = Mth.invSqrt($$6);
        Vec3 $$13 = $$4.scale($$12);
        Vec3 $$14 = this.getForward();
        float $$15 = (float)($$14.x * $$13.x + $$14.z * $$13.z);
        if ($$15 < -0.15f) {
            return;
        }
        CollisionContext $$16 = CollisionContext.of(this);
        BlockPos $$17 = BlockPos.containing(this.getX(), this.getBoundingBox().maxY, this.getZ());
        BlockState $$18 = this.level().getBlockState($$17);
        if (!$$18.getCollisionShape(this.level(), $$17, $$16).isEmpty()) {
            return;
        }
        $$17 = $$17.above();
        BlockState $$19 = this.level().getBlockState($$17);
        if (!$$19.getCollisionShape(this.level(), $$17, $$16).isEmpty()) {
            return;
        }
        float $$20 = 7.0f;
        float $$21 = 1.2f;
        if (this.hasEffect(MobEffects.JUMP)) {
            $$21 += (float)(this.getEffect(MobEffects.JUMP).getAmplifier() + 1) * 0.75f;
        }
        float $$22 = Math.max($$5 * 7.0f, 1.0f / $$12);
        Vec3 $$23 = $$2;
        Vec3 $$24 = $$3.add($$13.scale($$22));
        float $$25 = this.getBbWidth();
        float $$26 = this.getBbHeight();
        AABB $$27 = new AABB($$23, $$24.add(0.0, $$26, 0.0)).inflate($$25, 0.0, $$25);
        $$23 = $$23.add(0.0, 0.51f, 0.0);
        $$24 = $$24.add(0.0, 0.51f, 0.0);
        Vec3 $$28 = $$13.cross(new Vec3(0.0, 1.0, 0.0));
        Vec3 $$29 = $$28.scale($$25 * 0.5f);
        Vec3 $$30 = $$23.subtract($$29);
        Vec3 $$31 = $$24.subtract($$29);
        Vec3 $$32 = $$23.add($$29);
        Vec3 $$33 = $$24.add($$29);
        Iterable<VoxelShape> $$34 = this.level().getCollisions(this, $$27);
        Iterator $$35 = StreamSupport.stream($$34.spliterator(), false).flatMap(p_234124_ -> p_234124_.toAabbs().stream()).iterator();
        float $$36 = Float.MIN_VALUE;
        while ($$35.hasNext()) {
            AABB $$37 = (AABB)$$35.next();
            if (!$$37.intersects($$30, $$31) && !$$37.intersects($$32, $$33)) continue;
            $$36 = (float)$$37.maxY;
            Vec3 $$38 = $$37.getCenter();
            BlockPos $$39 = BlockPos.containing($$38);
            int $$40 = 1;
            while ((float)$$40 < $$21) {
                BlockPos $$41 = $$39.above($$40);
                BlockState $$42 = this.level().getBlockState($$41);
                VoxelShape $$43 = $$42.getCollisionShape(this.level(), $$41, $$16);
                if (!$$43.isEmpty() && (double)($$36 = (float)$$43.max(Direction.Axis.Y) + (float)$$41.getY()) - this.getY() > (double)$$21) {
                    return;
                }
                if ($$40 > 1) {
                    $$17 = $$17.above();
                    BlockState $$44 = this.level().getBlockState($$17);
                    if (!$$44.getCollisionShape(this.level(), $$17, $$16).isEmpty()) {
                        return;
                    }
                }
                ++$$40;
            }
            break block0;
        }
        if ($$36 == Float.MIN_VALUE) {
            return;
        }
        float $$45 = (float)((double)$$36 - this.getY());
        if ($$45 <= 0.5f || $$45 > $$21) {
            return;
        }
        this.autoJumpTime = 1;
    }

    @Override
    protected boolean isHorizontalCollisionMinor(Vec3 p_197411_) {
        float $$1 = this.getYRot() * ((float)Math.PI / 180);
        double $$2 = Mth.sin($$1);
        double $$3 = Mth.cos($$1);
        double $$4 = (double)this.xxa * $$3 - (double)this.zza * $$2;
        double $$5 = (double)this.zza * $$3 + (double)this.xxa * $$2;
        double $$6 = Mth.square($$4) + Mth.square($$5);
        double $$7 = Mth.square(p_197411_.x) + Mth.square(p_197411_.z);
        if ($$6 < (double)1.0E-5f || $$7 < (double)1.0E-5f) {
            return false;
        }
        double $$8 = $$4 * p_197411_.x + $$5 * p_197411_.z;
        double $$9 = Math.acos($$8 / Math.sqrt($$6 * $$7));
        return $$9 < 0.13962633907794952;
    }

    private boolean canAutoJump() {
        return this.isAutoJumpEnabled() && this.autoJumpTime <= 0 && this.onGround() && !this.isStayingOnGroundSurface() && !this.isPassenger() && this.isMoving() && (double)this.getBlockJumpFactor() >= 1.0;
    }

    private boolean isMoving() {
        Vec2 $$0 = this.input.getMoveVector();
        return $$0.x != 0.0f || $$0.y != 0.0f;
    }

    private boolean canStartSprinting() {
        return !this.isSprinting() && this.hasEnoughImpulseToStartSprinting() && this.hasEnoughFoodToStartSprinting() && !this.isUsingItem() && !this.hasEffect(MobEffects.BLINDNESS) && (!this.isPassenger() || this.vehicleCanSprint(this.getVehicle())) && !this.isFallFlying();
    }

    private boolean vehicleCanSprint(Entity p_265184_) {
        return p_265184_.canSprint() && p_265184_.isControlledByLocalInstance();
    }

    private boolean hasEnoughImpulseToStartSprinting() {
        double $$0 = 0.8;
        return this.isUnderWater() ? this.input.hasForwardImpulse() : (double)this.input.forwardImpulse >= 0.8;
    }

    private boolean hasEnoughFoodToStartSprinting() {
        return this.isPassenger() || (float)this.getFoodData().getFoodLevel() > 6.0f || this.getAbilities().mayfly;
    }

    public float getWaterVision() {
        if (!this.isEyeInFluid(FluidTags.WATER)) {
            return 0.0f;
        }
        float $$0 = 600.0f;
        float $$1 = 100.0f;
        if ((float)this.waterVisionTime >= 600.0f) {
            return 1.0f;
        }
        float $$2 = Mth.clamp((float)this.waterVisionTime / 100.0f, 0.0f, 1.0f);
        float $$3 = (float)this.waterVisionTime < 100.0f ? 0.0f : Mth.clamp(((float)this.waterVisionTime - 100.0f) / 500.0f, 0.0f, 1.0f);
        return $$2 * 0.6f + $$3 * 0.39999998f;
    }

    public void onGameModeChanged(GameType p_287675_) {
        if (p_287675_ == GameType.SPECTATOR) {
            this.setDeltaMovement(this.getDeltaMovement().with(Direction.Axis.Y, 0.0));
        }
    }

    @Override
    public boolean isUnderWater() {
        return this.wasUnderwater;
    }

    @Override
    protected boolean updateIsUnderwater() {
        boolean $$0 = this.wasUnderwater;
        boolean $$1 = super.updateIsUnderwater();
        if (this.isSpectator()) {
            return this.wasUnderwater;
        }
        if (!$$0 && $$1) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.AMBIENT_UNDERWATER_ENTER, SoundSource.AMBIENT, 1.0f, 1.0f, false);
            this.minecraft.getSoundManager().play(new UnderwaterAmbientSoundInstances.UnderwaterAmbientSoundInstance(this));
        }
        if ($$0 && !$$1) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEvents.AMBIENT_UNDERWATER_EXIT, SoundSource.AMBIENT, 1.0f, 1.0f, false);
        }
        return this.wasUnderwater;
    }

    @Override
    public Vec3 getRopeHoldPosition(float p_108758_) {
        if (this.minecraft.options.getCameraType().isFirstPerson()) {
            float $$1 = Mth.lerp(p_108758_ * 0.5f, this.getYRot(), this.yRotO) * ((float)Math.PI / 180);
            float $$2 = Mth.lerp(p_108758_ * 0.5f, this.getXRot(), this.xRotO) * ((float)Math.PI / 180);
            double $$3 = this.getMainArm() == HumanoidArm.RIGHT ? -1.0 : 1.0;
            Vec3 $$4 = new Vec3(0.39 * $$3, -0.6, 0.3);
            return $$4.xRot(-$$2).yRot(-$$1).add(this.getEyePosition(p_108758_));
        }
        return super.getRopeHoldPosition(p_108758_);
    }

    @Override
    public void updateTutorialInventoryAction(ItemStack p_172532_, ItemStack p_172533_, ClickAction p_172534_) {
        this.minecraft.getTutorial().onInventoryAction(p_172532_, p_172533_, p_172534_);
    }

    @Override
    public float getVisualRotationYInDegrees() {
        return this.getYRot();
    }
}

