/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.metadata.gui;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.StringRepresentable;

public interface GuiSpriteScaling {
    public static final Codec<GuiSpriteScaling> CODEC = Type.CODEC.dispatch(GuiSpriteScaling::type, Type::codec);
    public static final GuiSpriteScaling DEFAULT = new Stretch();

    public Type type();

    public static enum Type implements StringRepresentable
    {
        STRETCH("stretch", Stretch.CODEC),
        TILE("tile", Tile.CODEC),
        NINE_SLICE("nine_slice", NineSlice.CODEC);

        public static final Codec<Type> CODEC;
        private final String key;
        private final MapCodec<? extends GuiSpriteScaling> codec;

        private Type(String p_295906_, MapCodec<? extends GuiSpriteScaling> p_338627_) {
            this.key = p_295906_;
            this.codec = p_338627_;
        }

        @Override
        public String getSerializedName() {
            return this.key;
        }

        public MapCodec<? extends GuiSpriteScaling> codec() {
            return this.codec;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Type::values);
        }
    }

    public record Stretch() implements GuiSpriteScaling
    {
        public static final MapCodec<Stretch> CODEC = MapCodec.unit(Stretch::new);

        @Override
        public Type type() {
            return Type.STRETCH;
        }
    }

    public record NineSlice(int width, int height, Border border) implements GuiSpriteScaling
    {
        public static final MapCodec<NineSlice> CODEC = RecordCodecBuilder.mapCodec(p_295296_ -> p_295296_.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("width").forGetter(NineSlice::width), (App)ExtraCodecs.POSITIVE_INT.fieldOf("height").forGetter(NineSlice::height), (App)Border.CODEC.fieldOf("border").forGetter(NineSlice::border)).apply((Applicative)p_295296_, NineSlice::new)).validate(NineSlice::validate);

        private static DataResult<NineSlice> validate(NineSlice p_299275_) {
            Border $$1 = p_299275_.border();
            if ($$1.left() + $$1.right() >= p_299275_.width()) {
                return DataResult.error(() -> "Nine-sliced texture has no horizontal center slice: " + $$1.left() + " + " + $$1.right() + " >= " + p_299275_.width());
            }
            if ($$1.top() + $$1.bottom() >= p_299275_.height()) {
                return DataResult.error(() -> "Nine-sliced texture has no vertical center slice: " + $$1.top() + " + " + $$1.bottom() + " >= " + p_299275_.height());
            }
            return DataResult.success((Object)p_299275_);
        }

        @Override
        public Type type() {
            return Type.NINE_SLICE;
        }

        public record Border(int left, int top, int right, int bottom) {
            private static final Codec<Border> VALUE_CODEC = ExtraCodecs.POSITIVE_INT.flatComapMap(p_295538_ -> new Border((int)p_295538_, (int)p_295538_, (int)p_295538_, (int)p_295538_), p_295407_ -> {
                OptionalInt $$1 = p_295407_.unpackValue();
                if ($$1.isPresent()) {
                    return DataResult.success((Object)$$1.getAsInt());
                }
                return DataResult.error(() -> "Border has different side sizes");
            });
            private static final Codec<Border> RECORD_CODEC = RecordCodecBuilder.create(p_297930_ -> p_297930_.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("left").forGetter(Border::left), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("top").forGetter(Border::top), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("right").forGetter(Border::right), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("bottom").forGetter(Border::bottom)).apply((Applicative)p_297930_, Border::new));
            static final Codec<Border> CODEC = Codec.either(VALUE_CODEC, RECORD_CODEC).xmap(Either::unwrap, p_296295_ -> {
                if (p_296295_.unpackValue().isPresent()) {
                    return Either.left((Object)p_296295_);
                }
                return Either.right((Object)p_296295_);
            });

            private OptionalInt unpackValue() {
                if (this.left() == this.top() && this.top() == this.right() && this.right() == this.bottom()) {
                    return OptionalInt.of(this.left());
                }
                return OptionalInt.empty();
            }
        }
    }

    public record Tile(int width, int height) implements GuiSpriteScaling
    {
        public static final MapCodec<Tile> CODEC = RecordCodecBuilder.mapCodec(p_294311_ -> p_294311_.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("width").forGetter(Tile::width), (App)ExtraCodecs.POSITIVE_INT.fieldOf("height").forGetter(Tile::height)).apply((Applicative)p_294311_, Tile::new));

        @Override
        public Type type() {
            return Type.TILE;
        }
    }
}

