/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Clearable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public interface Container
extends Clearable {
    public static final float DEFAULT_DISTANCE_BUFFER = 4.0f;

    public int getContainerSize();

    public boolean isEmpty();

    public ItemStack getItem(int var1);

    public ItemStack removeItem(int var1, int var2);

    public ItemStack removeItemNoUpdate(int var1);

    public void setItem(int var1, ItemStack var2);

    default public int getMaxStackSize() {
        return 99;
    }

    default public int getMaxStackSize(ItemStack p_335963_) {
        return Math.min(this.getMaxStackSize(), p_335963_.getMaxStackSize());
    }

    public void setChanged();

    public boolean stillValid(Player var1);

    default public void startOpen(Player p_18955_) {
    }

    default public void stopOpen(Player p_18954_) {
    }

    default public boolean canPlaceItem(int p_18952_, ItemStack p_18953_) {
        return true;
    }

    default public boolean canTakeItem(Container p_273520_, int p_272681_, ItemStack p_273702_) {
        return true;
    }

    default public int countItem(Item p_18948_) {
        int $$1 = 0;
        for (int $$2 = 0; $$2 < this.getContainerSize(); ++$$2) {
            ItemStack $$3 = this.getItem($$2);
            if (!$$3.getItem().equals(p_18948_)) continue;
            $$1 += $$3.getCount();
        }
        return $$1;
    }

    default public boolean hasAnyOf(Set<Item> p_18950_) {
        return this.hasAnyMatching(p_216873_ -> !p_216873_.isEmpty() && p_18950_.contains(p_216873_.getItem()));
    }

    default public boolean hasAnyMatching(Predicate<ItemStack> p_216875_) {
        for (int $$1 = 0; $$1 < this.getContainerSize(); ++$$1) {
            ItemStack $$2 = this.getItem($$1);
            if (!p_216875_.test($$2)) continue;
            return true;
        }
        return false;
    }

    public static boolean stillValidBlockEntity(BlockEntity p_273154_, Player p_273222_) {
        return Container.stillValidBlockEntity(p_273154_, p_273222_, 4.0f);
    }

    public static boolean stillValidBlockEntity(BlockEntity p_272877_, Player p_272670_, float p_320837_) {
        Level $$3 = p_272877_.getLevel();
        BlockPos $$4 = p_272877_.getBlockPos();
        if ($$3 == null) {
            return false;
        }
        if ($$3.getBlockEntity($$4) != p_272877_) {
            return false;
        }
        return p_272670_.canInteractWithBlock($$4, p_320837_);
    }
}

