/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.enchantment.Enchantment;

public class ItemEnchantments
implements TooltipProvider {
    public static final ItemEnchantments EMPTY = new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)new Object2IntOpenHashMap(), true);
    private static final Codec<Integer> LEVEL_CODEC = Codec.intRange((int)0, (int)255);
    private static final Codec<Object2IntOpenHashMap<Holder<Enchantment>>> LEVELS_CODEC = Codec.unboundedMap(Enchantment.CODEC, LEVEL_CODEC).xmap(Object2IntOpenHashMap::new, Function.identity());
    private static final Codec<ItemEnchantments> FULL_CODEC = RecordCodecBuilder.create(p_337961_ -> p_337961_.group((App)LEVELS_CODEC.fieldOf("levels").forGetter(p_340785_ -> p_340785_.enchantments), (App)Codec.BOOL.optionalFieldOf("show_in_tooltip", (Object)true).forGetter(p_331891_ -> p_331891_.showInTooltip)).apply((Applicative)p_337961_, ItemEnchantments::new));
    public static final Codec<ItemEnchantments> CODEC = Codec.withAlternative(FULL_CODEC, LEVELS_CODEC, p_340783_ -> new ItemEnchantments((Object2IntOpenHashMap<Holder<Enchantment>>)p_340783_, true));
    public static final StreamCodec<RegistryFriendlyByteBuf, ItemEnchantments> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.map(Object2IntOpenHashMap::new, Enchantment.STREAM_CODEC, ByteBufCodecs.VAR_INT), p_340784_ -> p_340784_.enchantments, ByteBufCodecs.BOOL, p_330450_ -> p_330450_.showInTooltip, ItemEnchantments::new);
    final Object2IntOpenHashMap<Holder<Enchantment>> enchantments;
    final boolean showInTooltip;

    ItemEnchantments(Object2IntOpenHashMap<Holder<Enchantment>> p_341287_, boolean p_330219_) {
        this.enchantments = p_341287_;
        this.showInTooltip = p_330219_;
        for (Object2IntMap.Entry $$2 : p_341287_.object2IntEntrySet()) {
            int $$3 = $$2.getIntValue();
            if ($$3 >= 0 && $$3 <= 255) continue;
            throw new IllegalArgumentException("Enchantment " + String.valueOf($$2.getKey()) + " has invalid level " + $$3);
        }
    }

    public int getLevel(Holder<Enchantment> p_345693_) {
        return this.enchantments.getInt(p_345693_);
    }

    @Override
    public void addToTooltip(Item.TooltipContext p_341290_, Consumer<Component> p_331119_, TooltipFlag p_330400_) {
        if (!this.showInTooltip) {
            return;
        }
        HolderLookup.Provider $$3 = p_341290_.registries();
        HolderSet<Enchantment> $$4 = ItemEnchantments.getTagOrEmpty($$3, Registries.ENCHANTMENT, EnchantmentTags.TOOLTIP_ORDER);
        for (Holder holder : $$4) {
            int $$6 = this.enchantments.getInt((Object)holder);
            if ($$6 <= 0) continue;
            p_331119_.accept(Enchantment.getFullname(holder, $$6));
        }
        for (Object2IntMap.Entry entry : this.enchantments.object2IntEntrySet()) {
            Holder $$8 = (Holder)entry.getKey();
            if ($$4.contains($$8)) continue;
            p_331119_.accept(Enchantment.getFullname((Holder)entry.getKey(), entry.getIntValue()));
        }
    }

    private static <T> HolderSet<T> getTagOrEmpty(@Nullable HolderLookup.Provider p_341186_, ResourceKey<Registry<T>> p_341113_, TagKey<T> p_341409_) {
        Optional<HolderSet.Named<T>> $$3;
        if (p_341186_ != null && ($$3 = p_341186_.lookupOrThrow(p_341113_).get(p_341409_)).isPresent()) {
            return $$3.get();
        }
        return HolderSet.direct(new Holder[0]);
    }

    public ItemEnchantments withTooltip(boolean p_335616_) {
        return new ItemEnchantments(this.enchantments, p_335616_);
    }

    public Set<Holder<Enchantment>> keySet() {
        return Collections.unmodifiableSet(this.enchantments.keySet());
    }

    public Set<Object2IntMap.Entry<Holder<Enchantment>>> entrySet() {
        return Collections.unmodifiableSet(this.enchantments.object2IntEntrySet());
    }

    public int size() {
        return this.enchantments.size();
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }

    public boolean equals(Object p_331697_) {
        if (this == p_331697_) {
            return true;
        }
        if (p_331697_ instanceof ItemEnchantments) {
            ItemEnchantments $$1 = (ItemEnchantments)p_331697_;
            return this.showInTooltip == $$1.showInTooltip && this.enchantments.equals($$1.enchantments);
        }
        return false;
    }

    public int hashCode() {
        int $$0 = this.enchantments.hashCode();
        $$0 = 31 * $$0 + (this.showInTooltip ? 1 : 0);
        return $$0;
    }

    public String toString() {
        return "ItemEnchantments{enchantments=" + String.valueOf(this.enchantments) + ", showInTooltip=" + this.showInTooltip + "}";
    }

    public static class Mutable {
        private final Object2IntOpenHashMap<Holder<Enchantment>> enchantments = new Object2IntOpenHashMap();
        private final boolean showInTooltip;

        public Mutable(ItemEnchantments p_330722_) {
            this.enchantments.putAll(p_330722_.enchantments);
            this.showInTooltip = p_330722_.showInTooltip;
        }

        public void set(Holder<Enchantment> p_344861_, int p_330832_) {
            if (p_330832_ <= 0) {
                this.enchantments.removeInt(p_344861_);
            } else {
                this.enchantments.put(p_344861_, Math.min(p_330832_, 255));
            }
        }

        public void upgrade(Holder<Enchantment> p_346263_, int p_331153_) {
            if (p_331153_ > 0) {
                this.enchantments.merge(p_346263_, Math.min(p_331153_, 255), Integer::max);
            }
        }

        public void removeIf(Predicate<Holder<Enchantment>> p_332079_) {
            this.enchantments.keySet().removeIf(p_332079_);
        }

        public int getLevel(Holder<Enchantment> p_345430_) {
            return this.enchantments.getOrDefault(p_345430_, 0);
        }

        public Set<Holder<Enchantment>> keySet() {
            return this.enchantments.keySet();
        }

        public ItemEnchantments toImmutable() {
            return new ItemEnchantments(this.enchantments, this.showInTooltip);
        }
    }
}

