/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ClipContext {
    private final Vec3 from;
    private final Vec3 to;
    private final Block block;
    private final Fluid fluid;
    private final CollisionContext collisionContext;

    public ClipContext(Vec3 p_45688_, Vec3 p_45689_, Block p_45690_, Fluid p_45691_, Entity p_45692_) {
        this(p_45688_, p_45689_, p_45690_, p_45691_, CollisionContext.of(p_45692_));
    }

    public ClipContext(Vec3 p_311916_, Vec3 p_312802_, Block p_312540_, Fluid p_312487_, CollisionContext p_311823_) {
        this.from = p_311916_;
        this.to = p_312802_;
        this.block = p_312540_;
        this.fluid = p_312487_;
        this.collisionContext = p_311823_;
    }

    public Vec3 getTo() {
        return this.to;
    }

    public Vec3 getFrom() {
        return this.from;
    }

    public VoxelShape getBlockShape(BlockState p_45695_, BlockGetter p_45696_, BlockPos p_45697_) {
        return this.block.get(p_45695_, p_45696_, p_45697_, this.collisionContext);
    }

    public VoxelShape getFluidShape(FluidState p_45699_, BlockGetter p_45700_, BlockPos p_45701_) {
        return this.fluid.canPick(p_45699_) ? p_45699_.getShape(p_45700_, p_45701_) : Shapes.empty();
    }

    public static enum Block implements ShapeGetter
    {
        COLLIDER(BlockBehaviour.BlockStateBase::getCollisionShape),
        OUTLINE(BlockBehaviour.BlockStateBase::getShape),
        VISUAL(BlockBehaviour.BlockStateBase::getVisualShape),
        FALLDAMAGE_RESETTING((p_201982_, p_201983_, p_201984_, p_201985_) -> {
            if (p_201982_.is(BlockTags.FALL_DAMAGE_RESETTING)) {
                return Shapes.block();
            }
            return Shapes.empty();
        });

        private final ShapeGetter shapeGetter;

        private Block(ShapeGetter p_45712_) {
            this.shapeGetter = p_45712_;
        }

        @Override
        public VoxelShape get(BlockState p_45714_, BlockGetter p_45715_, BlockPos p_45716_, CollisionContext p_45717_) {
            return this.shapeGetter.get(p_45714_, p_45715_, p_45716_, p_45717_);
        }
    }

    public static enum Fluid {
        NONE(p_45736_ -> false),
        SOURCE_ONLY(FluidState::isSource),
        ANY(p_45734_ -> !p_45734_.isEmpty()),
        WATER(p_201988_ -> p_201988_.is(FluidTags.WATER));

        private final Predicate<FluidState> canPick;

        private Fluid(Predicate<FluidState> p_45730_) {
            this.canPick = p_45730_;
        }

        public boolean canPick(FluidState p_45732_) {
            return this.canPick.test(p_45732_);
        }
    }

    public static interface ShapeGetter {
        public VoxelShape get(BlockState var1, BlockGetter var2, BlockPos var3, CollisionContext var4);
    }
}

