/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableSet;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.slf4j.Logger;

public abstract class StructurePiece {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final BlockState CAVE_AIR = Blocks.CAVE_AIR.defaultBlockState();
    protected BoundingBox boundingBox;
    @Nullable
    private Direction orientation;
    private Mirror mirror;
    private Rotation rotation;
    protected int genDepth;
    private final StructurePieceType type;
    private static final Set<Block> SHAPE_CHECK_BLOCKS = ImmutableSet.builder().add((Object)Blocks.NETHER_BRICK_FENCE).add((Object)Blocks.TORCH).add((Object)Blocks.WALL_TORCH).add((Object)Blocks.OAK_FENCE).add((Object)Blocks.SPRUCE_FENCE).add((Object)Blocks.DARK_OAK_FENCE).add((Object)Blocks.ACACIA_FENCE).add((Object)Blocks.BIRCH_FENCE).add((Object)Blocks.JUNGLE_FENCE).add((Object)Blocks.LADDER).add((Object)Blocks.IRON_BARS).build();

    protected StructurePiece(StructurePieceType p_209994_, int p_209995_, BoundingBox p_209996_) {
        this.type = p_209994_;
        this.genDepth = p_209995_;
        this.boundingBox = p_209996_;
    }

    public StructurePiece(StructurePieceType p_209998_, CompoundTag p_209999_) {
        this(p_209998_, p_209999_.getInt("GD"), (BoundingBox)BoundingBox.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)p_209999_.get("BB")).getOrThrow(p_347417_ -> new IllegalArgumentException("Invalid boundingbox: " + p_347417_)));
        int $$2 = p_209999_.getInt("O");
        this.setOrientation($$2 == -1 ? null : Direction.from2DDataValue($$2));
    }

    protected static BoundingBox makeBoundingBox(int p_163542_, int p_163543_, int p_163544_, Direction p_163545_, int p_163546_, int p_163547_, int p_163548_) {
        if (p_163545_.getAxis() == Direction.Axis.Z) {
            return new BoundingBox(p_163542_, p_163543_, p_163544_, p_163542_ + p_163546_ - 1, p_163543_ + p_163547_ - 1, p_163544_ + p_163548_ - 1);
        }
        return new BoundingBox(p_163542_, p_163543_, p_163544_, p_163542_ + p_163548_ - 1, p_163543_ + p_163547_ - 1, p_163544_ + p_163546_ - 1);
    }

    protected static Direction getRandomHorizontalDirection(RandomSource p_226761_) {
        return Direction.Plane.HORIZONTAL.getRandomDirection(p_226761_);
    }

    public final CompoundTag createTag(StructurePieceSerializationContext p_192645_) {
        CompoundTag $$1 = new CompoundTag();
        $$1.putString("id", BuiltInRegistries.STRUCTURE_PIECE.getKey(this.getType()).toString());
        BoundingBox.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.boundingBox).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_163579_ -> $$1.put("BB", (Tag)p_163579_));
        Direction $$2 = this.getOrientation();
        $$1.putInt("O", $$2 == null ? -1 : $$2.get2DDataValue());
        $$1.putInt("GD", this.genDepth);
        this.addAdditionalSaveData(p_192645_, $$1);
        return $$1;
    }

    protected abstract void addAdditionalSaveData(StructurePieceSerializationContext var1, CompoundTag var2);

    public void addChildren(StructurePiece p_226835_, StructurePieceAccessor p_226836_, RandomSource p_226837_) {
    }

    public abstract void postProcess(WorldGenLevel var1, StructureManager var2, ChunkGenerator var3, RandomSource var4, BoundingBox var5, ChunkPos var6, BlockPos var7);

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public int getGenDepth() {
        return this.genDepth;
    }

    public void setGenDepth(int p_226759_) {
        this.genDepth = p_226759_;
    }

    public boolean isCloseToChunk(ChunkPos p_73412_, int p_73413_) {
        int $$2 = p_73412_.getMinBlockX();
        int $$3 = p_73412_.getMinBlockZ();
        return this.boundingBox.intersects($$2 - p_73413_, $$3 - p_73413_, $$2 + 15 + p_73413_, $$3 + 15 + p_73413_);
    }

    public BlockPos getLocatorPosition() {
        return new BlockPos(this.boundingBox.getCenter());
    }

    protected BlockPos.MutableBlockPos getWorldPos(int p_163583_, int p_163584_, int p_163585_) {
        return new BlockPos.MutableBlockPos(this.getWorldX(p_163583_, p_163585_), this.getWorldY(p_163584_), this.getWorldZ(p_163583_, p_163585_));
    }

    protected int getWorldX(int p_73393_, int p_73394_) {
        Direction $$2 = this.getOrientation();
        if ($$2 == null) {
            return p_73393_;
        }
        switch ($$2) {
            case NORTH: 
            case SOUTH: {
                return this.boundingBox.minX() + p_73393_;
            }
            case WEST: {
                return this.boundingBox.maxX() - p_73394_;
            }
            case EAST: {
                return this.boundingBox.minX() + p_73394_;
            }
        }
        return p_73393_;
    }

    protected int getWorldY(int p_73545_) {
        if (this.getOrientation() == null) {
            return p_73545_;
        }
        return p_73545_ + this.boundingBox.minY();
    }

    protected int getWorldZ(int p_73526_, int p_73527_) {
        Direction $$2 = this.getOrientation();
        if ($$2 == null) {
            return p_73527_;
        }
        switch ($$2) {
            case NORTH: {
                return this.boundingBox.maxZ() - p_73527_;
            }
            case SOUTH: {
                return this.boundingBox.minZ() + p_73527_;
            }
            case WEST: 
            case EAST: {
                return this.boundingBox.minZ() + p_73526_;
            }
        }
        return p_73527_;
    }

    protected void placeBlock(WorldGenLevel p_73435_, BlockState p_73436_, int p_73437_, int p_73438_, int p_73439_, BoundingBox p_73440_) {
        BlockPos.MutableBlockPos $$6 = this.getWorldPos(p_73437_, p_73438_, p_73439_);
        if (!p_73440_.isInside($$6)) {
            return;
        }
        if (!this.canBeReplaced(p_73435_, p_73437_, p_73438_, p_73439_, p_73440_)) {
            return;
        }
        if (this.mirror != Mirror.NONE) {
            p_73436_ = p_73436_.mirror(this.mirror);
        }
        if (this.rotation != Rotation.NONE) {
            p_73436_ = p_73436_.rotate(this.rotation);
        }
        p_73435_.setBlock($$6, p_73436_, 2);
        FluidState $$7 = p_73435_.getFluidState($$6);
        if (!$$7.isEmpty()) {
            p_73435_.scheduleTick((BlockPos)$$6, $$7.getType(), 0);
        }
        if (SHAPE_CHECK_BLOCKS.contains(p_73436_.getBlock())) {
            p_73435_.getChunk($$6).markPosForPostprocessing($$6);
        }
    }

    protected boolean canBeReplaced(LevelReader p_163553_, int p_163554_, int p_163555_, int p_163556_, BoundingBox p_163557_) {
        return true;
    }

    protected BlockState getBlock(BlockGetter p_73399_, int p_73400_, int p_73401_, int p_73402_, BoundingBox p_73403_) {
        BlockPos.MutableBlockPos $$5 = this.getWorldPos(p_73400_, p_73401_, p_73402_);
        if (!p_73403_.isInside($$5)) {
            return Blocks.AIR.defaultBlockState();
        }
        return p_73399_.getBlockState($$5);
    }

    protected boolean isInterior(LevelReader p_73415_, int p_73416_, int p_73417_, int p_73418_, BoundingBox p_73419_) {
        BlockPos.MutableBlockPos $$5 = this.getWorldPos(p_73416_, p_73417_ + 1, p_73418_);
        if (!p_73419_.isInside($$5)) {
            return false;
        }
        return $$5.getY() < p_73415_.getHeight(Heightmap.Types.OCEAN_FLOOR_WG, $$5.getX(), $$5.getZ());
    }

    protected void generateAirBox(WorldGenLevel p_73536_, BoundingBox p_73537_, int p_73538_, int p_73539_, int p_73540_, int p_73541_, int p_73542_, int p_73543_) {
        for (int $$8 = p_73539_; $$8 <= p_73542_; ++$$8) {
            for (int $$9 = p_73538_; $$9 <= p_73541_; ++$$9) {
                for (int $$10 = p_73540_; $$10 <= p_73543_; ++$$10) {
                    this.placeBlock(p_73536_, Blocks.AIR.defaultBlockState(), $$9, $$8, $$10, p_73537_);
                }
            }
        }
    }

    protected void generateBox(WorldGenLevel p_73442_, BoundingBox p_73443_, int p_73444_, int p_73445_, int p_73446_, int p_73447_, int p_73448_, int p_73449_, BlockState p_73450_, BlockState p_73451_, boolean p_73452_) {
        for (int $$11 = p_73445_; $$11 <= p_73448_; ++$$11) {
            for (int $$12 = p_73444_; $$12 <= p_73447_; ++$$12) {
                for (int $$13 = p_73446_; $$13 <= p_73449_; ++$$13) {
                    if (p_73452_ && this.getBlock(p_73442_, $$12, $$11, $$13, p_73443_).isAir()) continue;
                    if ($$11 == p_73445_ || $$11 == p_73448_ || $$12 == p_73444_ || $$12 == p_73447_ || $$13 == p_73446_ || $$13 == p_73449_) {
                        this.placeBlock(p_73442_, p_73450_, $$12, $$11, $$13, p_73443_);
                        continue;
                    }
                    this.placeBlock(p_73442_, p_73451_, $$12, $$11, $$13, p_73443_);
                }
            }
        }
    }

    protected void generateBox(WorldGenLevel p_163559_, BoundingBox p_163560_, BoundingBox p_163561_, BlockState p_163562_, BlockState p_163563_, boolean p_163564_) {
        this.generateBox(p_163559_, p_163560_, p_163561_.minX(), p_163561_.minY(), p_163561_.minZ(), p_163561_.maxX(), p_163561_.maxY(), p_163561_.maxZ(), p_163562_, p_163563_, p_163564_);
    }

    protected void generateBox(WorldGenLevel p_226777_, BoundingBox p_226778_, int p_226779_, int p_226780_, int p_226781_, int p_226782_, int p_226783_, int p_226784_, boolean p_226785_, RandomSource p_226786_, BlockSelector p_226787_) {
        for (int $$11 = p_226780_; $$11 <= p_226783_; ++$$11) {
            for (int $$12 = p_226779_; $$12 <= p_226782_; ++$$12) {
                for (int $$13 = p_226781_; $$13 <= p_226784_; ++$$13) {
                    if (p_226785_ && this.getBlock(p_226777_, $$12, $$11, $$13, p_226778_).isAir()) continue;
                    p_226787_.next(p_226786_, $$12, $$11, $$13, $$11 == p_226780_ || $$11 == p_226783_ || $$12 == p_226779_ || $$12 == p_226782_ || $$13 == p_226781_ || $$13 == p_226784_);
                    this.placeBlock(p_226777_, p_226787_.getNext(), $$12, $$11, $$13, p_226778_);
                }
            }
        }
    }

    protected void generateBox(WorldGenLevel p_226829_, BoundingBox p_226830_, BoundingBox p_226831_, boolean p_226832_, RandomSource p_226833_, BlockSelector p_226834_) {
        this.generateBox(p_226829_, p_226830_, p_226831_.minX(), p_226831_.minY(), p_226831_.minZ(), p_226831_.maxX(), p_226831_.maxY(), p_226831_.maxZ(), p_226832_, p_226833_, p_226834_);
    }

    protected void generateMaybeBox(WorldGenLevel p_226789_, BoundingBox p_226790_, RandomSource p_226791_, float p_226792_, int p_226793_, int p_226794_, int p_226795_, int p_226796_, int p_226797_, int p_226798_, BlockState p_226799_, BlockState p_226800_, boolean p_226801_, boolean p_226802_) {
        for (int $$14 = p_226794_; $$14 <= p_226797_; ++$$14) {
            for (int $$15 = p_226793_; $$15 <= p_226796_; ++$$15) {
                for (int $$16 = p_226795_; $$16 <= p_226798_; ++$$16) {
                    if (p_226791_.nextFloat() > p_226792_ || p_226801_ && this.getBlock(p_226789_, $$15, $$14, $$16, p_226790_).isAir() || p_226802_ && !this.isInterior(p_226789_, $$15, $$14, $$16, p_226790_)) continue;
                    if ($$14 == p_226794_ || $$14 == p_226797_ || $$15 == p_226793_ || $$15 == p_226796_ || $$16 == p_226795_ || $$16 == p_226798_) {
                        this.placeBlock(p_226789_, p_226799_, $$15, $$14, $$16, p_226790_);
                        continue;
                    }
                    this.placeBlock(p_226789_, p_226800_, $$15, $$14, $$16, p_226790_);
                }
            }
        }
    }

    protected void maybeGenerateBlock(WorldGenLevel p_226804_, BoundingBox p_226805_, RandomSource p_226806_, float p_226807_, int p_226808_, int p_226809_, int p_226810_, BlockState p_226811_) {
        if (p_226806_.nextFloat() < p_226807_) {
            this.placeBlock(p_226804_, p_226811_, p_226808_, p_226809_, p_226810_, p_226805_);
        }
    }

    protected void generateUpperHalfSphere(WorldGenLevel p_73454_, BoundingBox p_73455_, int p_73456_, int p_73457_, int p_73458_, int p_73459_, int p_73460_, int p_73461_, BlockState p_73462_, boolean p_73463_) {
        float $$10 = p_73459_ - p_73456_ + 1;
        float $$11 = p_73460_ - p_73457_ + 1;
        float $$12 = p_73461_ - p_73458_ + 1;
        float $$13 = (float)p_73456_ + $$10 / 2.0f;
        float $$14 = (float)p_73458_ + $$12 / 2.0f;
        for (int $$15 = p_73457_; $$15 <= p_73460_; ++$$15) {
            float $$16 = (float)($$15 - p_73457_) / $$11;
            for (int $$17 = p_73456_; $$17 <= p_73459_; ++$$17) {
                float $$18 = ((float)$$17 - $$13) / ($$10 * 0.5f);
                for (int $$19 = p_73458_; $$19 <= p_73461_; ++$$19) {
                    float $$21;
                    float $$20 = ((float)$$19 - $$14) / ($$12 * 0.5f);
                    if (p_73463_ && this.getBlock(p_73454_, $$17, $$15, $$19, p_73455_).isAir() || !(($$21 = $$18 * $$18 + $$16 * $$16 + $$20 * $$20) <= 1.05f)) continue;
                    this.placeBlock(p_73454_, p_73462_, $$17, $$15, $$19, p_73455_);
                }
            }
        }
    }

    protected void fillColumnDown(WorldGenLevel p_73529_, BlockState p_73530_, int p_73531_, int p_73532_, int p_73533_, BoundingBox p_73534_) {
        BlockPos.MutableBlockPos $$6 = this.getWorldPos(p_73531_, p_73532_, p_73533_);
        if (!p_73534_.isInside($$6)) {
            return;
        }
        while (this.isReplaceableByStructures(p_73529_.getBlockState($$6)) && $$6.getY() > p_73529_.getMinBuildHeight() + 1) {
            p_73529_.setBlock($$6, p_73530_, 2);
            $$6.move(Direction.DOWN);
        }
    }

    protected boolean isReplaceableByStructures(BlockState p_163573_) {
        return p_163573_.isAir() || p_163573_.liquid() || p_163573_.is(Blocks.GLOW_LICHEN) || p_163573_.is(Blocks.SEAGRASS) || p_163573_.is(Blocks.TALL_SEAGRASS);
    }

    protected boolean createChest(WorldGenLevel p_226812_, BoundingBox p_226813_, RandomSource p_226814_, int p_226815_, int p_226816_, int p_226817_, ResourceKey<LootTable> p_335835_) {
        return this.createChest(p_226812_, p_226813_, p_226814_, this.getWorldPos(p_226815_, p_226816_, p_226817_), p_335835_, null);
    }

    public static BlockState reorient(BlockGetter p_73408_, BlockPos p_73409_, BlockState p_73410_) {
        Direction $$3 = null;
        for (Direction $$4 : Direction.Plane.HORIZONTAL) {
            BlockPos $$5 = p_73409_.relative($$4);
            BlockState $$6 = p_73408_.getBlockState($$5);
            if ($$6.is(Blocks.CHEST)) {
                return p_73410_;
            }
            if (!$$6.isSolidRender(p_73408_, $$5)) continue;
            if ($$3 == null) {
                $$3 = $$4;
                continue;
            }
            $$3 = null;
            break;
        }
        if ($$3 != null) {
            return (BlockState)p_73410_.setValue(HorizontalDirectionalBlock.FACING, $$3.getOpposite());
        }
        Direction $$7 = p_73410_.getValue(HorizontalDirectionalBlock.FACING);
        BlockPos $$8 = p_73409_.relative($$7);
        if (p_73408_.getBlockState($$8).isSolidRender(p_73408_, $$8)) {
            $$7 = $$7.getOpposite();
            $$8 = p_73409_.relative($$7);
        }
        if (p_73408_.getBlockState($$8).isSolidRender(p_73408_, $$8)) {
            $$7 = $$7.getClockWise();
            $$8 = p_73409_.relative($$7);
        }
        if (p_73408_.getBlockState($$8).isSolidRender(p_73408_, $$8)) {
            $$7 = $$7.getOpposite();
            $$8 = p_73409_.relative($$7);
        }
        return (BlockState)p_73410_.setValue(HorizontalDirectionalBlock.FACING, $$7);
    }

    protected boolean createChest(ServerLevelAccessor p_226763_, BoundingBox p_226764_, RandomSource p_226765_, BlockPos p_226766_, ResourceKey<LootTable> p_335513_, @Nullable BlockState p_226768_) {
        if (!p_226764_.isInside(p_226766_) || p_226763_.getBlockState(p_226766_).is(Blocks.CHEST)) {
            return false;
        }
        if (p_226768_ == null) {
            p_226768_ = StructurePiece.reorient(p_226763_, p_226766_, Blocks.CHEST.defaultBlockState());
        }
        p_226763_.setBlock(p_226766_, p_226768_, 2);
        BlockEntity $$6 = p_226763_.getBlockEntity(p_226766_);
        if ($$6 instanceof ChestBlockEntity) {
            ((ChestBlockEntity)$$6).setLootTable(p_335513_, p_226765_.nextLong());
        }
        return true;
    }

    protected boolean createDispenser(WorldGenLevel p_226820_, BoundingBox p_226821_, RandomSource p_226822_, int p_226823_, int p_226824_, int p_226825_, Direction p_226826_, ResourceKey<LootTable> p_336026_) {
        BlockPos.MutableBlockPos $$8 = this.getWorldPos(p_226823_, p_226824_, p_226825_);
        if (p_226821_.isInside($$8) && !p_226820_.getBlockState($$8).is(Blocks.DISPENSER)) {
            this.placeBlock(p_226820_, (BlockState)Blocks.DISPENSER.defaultBlockState().setValue(DispenserBlock.FACING, p_226826_), p_226823_, p_226824_, p_226825_, p_226821_);
            BlockEntity $$9 = p_226820_.getBlockEntity($$8);
            if ($$9 instanceof DispenserBlockEntity) {
                ((DispenserBlockEntity)$$9).setLootTable(p_336026_, p_226822_.nextLong());
            }
            return true;
        }
        return false;
    }

    public void move(int p_73395_, int p_73396_, int p_73397_) {
        this.boundingBox.move(p_73395_, p_73396_, p_73397_);
    }

    public static BoundingBox createBoundingBox(Stream<StructurePiece> p_192652_) {
        return BoundingBox.encapsulatingBoxes(p_192652_.map(StructurePiece::getBoundingBox)::iterator).orElseThrow(() -> new IllegalStateException("Unable to calculate boundingbox without pieces"));
    }

    @Nullable
    public static StructurePiece findCollisionPiece(List<StructurePiece> p_192649_, BoundingBox p_192650_) {
        for (StructurePiece $$2 : p_192649_) {
            if (!$$2.getBoundingBox().intersects(p_192650_)) continue;
            return $$2;
        }
        return null;
    }

    @Nullable
    public Direction getOrientation() {
        return this.orientation;
    }

    public void setOrientation(@Nullable Direction p_73520_) {
        this.orientation = p_73520_;
        if (p_73520_ == null) {
            this.rotation = Rotation.NONE;
            this.mirror = Mirror.NONE;
        } else {
            switch (p_73520_) {
                case SOUTH: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.mirror = Mirror.LEFT_RIGHT;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.mirror = Mirror.NONE;
                    this.rotation = Rotation.NONE;
                }
            }
        }
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public Mirror getMirror() {
        return this.mirror;
    }

    public StructurePieceType getType() {
        return this.type;
    }

    public static abstract class BlockSelector {
        protected BlockState next = Blocks.AIR.defaultBlockState();

        public abstract void next(RandomSource var1, int var2, int var3, int var4, boolean var5);

        public BlockState getNext() {
            return this.next;
        }
    }
}

