/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;

public class PreloadedTexture
extends SimpleTexture {
    @Nullable
    private CompletableFuture<SimpleTexture.TextureImage> future;

    public PreloadedTexture(ResourceManager p_118102_, ResourceLocation p_118103_, Executor p_118104_) {
        super(p_118103_);
        this.future = CompletableFuture.supplyAsync(() -> SimpleTexture.TextureImage.load(p_118102_, p_118103_), p_118104_);
    }

    @Override
    protected SimpleTexture.TextureImage getTextureImage(ResourceManager p_118126_) {
        if (this.future != null) {
            SimpleTexture.TextureImage $$1 = this.future.join();
            this.future = null;
            return $$1;
        }
        return SimpleTexture.TextureImage.load(p_118126_, this.location);
    }

    public CompletableFuture<Void> getFuture() {
        return this.future == null ? CompletableFuture.completedFuture(null) : this.future.thenApply(p_118110_ -> null);
    }

    @Override
    public void reset(TextureManager p_118114_, ResourceManager p_118115_, ResourceLocation p_118116_, Executor p_118117_) {
        this.future = CompletableFuture.supplyAsync(() -> SimpleTexture.TextureImage.load(p_118115_, this.location), Util.backgroundExecutor());
        this.future.thenRunAsync(() -> p_118114_.register(this.location, this), PreloadedTexture.executor(p_118117_));
    }

    private static Executor executor(Executor p_118121_) {
        return p_118124_ -> p_118121_.execute(() -> RenderSystem.recordRenderCall(p_118124_::run));
    }
}

