/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.VarInt;

public class Utf8String {
    public static String read(ByteBuf p_295677_, int p_295190_) {
        int $$2 = ByteBufUtil.utf8MaxBytes((int)p_295190_);
        int $$3 = VarInt.read(p_295677_);
        if ($$3 > $$2) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + $$3 + " > " + $$2 + ")");
        }
        if ($$3 < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        int $$4 = p_295677_.readableBytes();
        if ($$3 > $$4) {
            throw new DecoderException("Not enough bytes in buffer, expected " + $$3 + ", but got " + $$4);
        }
        String $$5 = p_295677_.toString(p_295677_.readerIndex(), $$3, StandardCharsets.UTF_8);
        p_295677_.readerIndex(p_295677_.readerIndex() + $$3);
        if ($$5.length() > p_295190_) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + $$5.length() + " > " + p_295190_ + ")");
        }
        return $$5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(ByteBuf p_295811_, CharSequence p_295702_, int p_295310_) {
        if (p_295702_.length() > p_295310_) {
            throw new EncoderException("String too big (was " + p_295702_.length() + " characters, max " + p_295310_ + ")");
        }
        int $$3 = ByteBufUtil.utf8MaxBytes((CharSequence)p_295702_);
        ByteBuf $$4 = p_295811_.alloc().buffer($$3);
        try {
            int $$5 = ByteBufUtil.writeUtf8((ByteBuf)$$4, (CharSequence)p_295702_);
            int $$6 = ByteBufUtil.utf8MaxBytes((int)p_295310_);
            if ($$5 > $$6) {
                throw new EncoderException("String too big (was " + $$5 + " bytes encoded, max " + $$6 + ")");
            }
            VarInt.write(p_295811_, $$5);
            p_295811_.writeBytes($$4);
        }
        finally {
            $$4.release();
        }
    }
}

