/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DownloadCacheCleaner {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void vacuumCacheDir(Path p_314919_, int p_314928_) {
        try {
            List<PathAndTime> $$2 = DownloadCacheCleaner.listFilesWithModificationTimes(p_314919_);
            int $$3 = $$2.size() - p_314928_;
            if ($$3 <= 0) {
                return;
            }
            $$2.sort(PathAndTime.NEWEST_FIRST);
            List<PathAndPriority> $$4 = DownloadCacheCleaner.prioritizeFilesInDirs($$2);
            Collections.reverse($$4);
            $$4.sort(PathAndPriority.HIGHEST_PRIORITY_FIRST);
            HashSet<Path> $$5 = new HashSet<Path>();
            for (int $$6 = 0; $$6 < $$3; ++$$6) {
                PathAndPriority $$7 = $$4.get($$6);
                Path $$8 = $$7.path;
                try {
                    Files.delete($$8);
                    if ($$7.removalPriority != 0) continue;
                    $$5.add($$8.getParent());
                    continue;
                }
                catch (IOException $$9) {
                    LOGGER.warn("Failed to delete cache file {}", (Object)$$8, (Object)$$9);
                }
            }
            $$5.remove(p_314919_);
            for (Path $$10 : $$5) {
                try {
                    Files.delete($$10);
                }
                catch (DirectoryNotEmptyException $$8) {
                }
                catch (IOException $$11) {
                    LOGGER.warn("Failed to delete empty(?) cache directory {}", (Object)$$10, (Object)$$11);
                }
            }
        }
        catch (IOException | UncheckedIOException $$12) {
            LOGGER.error("Failed to vacuum cache dir {}", (Object)p_314919_, (Object)$$12);
        }
    }

    private static List<PathAndTime> listFilesWithModificationTimes(final Path p_314985_) throws IOException {
        try {
            final ArrayList<PathAndTime> $$1 = new ArrayList<PathAndTime>();
            Files.walkFileTree(p_314985_, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path p_314922_, BasicFileAttributes p_315004_) {
                    if (p_315004_.isRegularFile() && !p_314922_.getParent().equals(p_314985_)) {
                        FileTime $$2 = p_315004_.lastModifiedTime();
                        $$1.add(new PathAndTime(p_314922_, $$2));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public /* synthetic */ FileVisitResult visitFile(Object object, BasicFileAttributes basicFileAttributes) throws IOException {
                    return this.visitFile((Path)object, basicFileAttributes);
                }
            });
            return $$1;
        }
        catch (NoSuchFileException $$2) {
            return List.of();
        }
    }

    private static List<PathAndPriority> prioritizeFilesInDirs(List<PathAndTime> p_314924_) {
        ArrayList<PathAndPriority> $$1 = new ArrayList<PathAndPriority>();
        Object2IntOpenHashMap $$2 = new Object2IntOpenHashMap();
        for (PathAndTime $$3 : p_314924_) {
            int $$4 = $$2.addTo((Object)$$3.path.getParent(), 1);
            $$1.add(new PathAndPriority($$3.path, $$4));
        }
        return $$1;
    }

    record PathAndTime(Path path, FileTime modifiedTime) {
        public static final Comparator<PathAndTime> NEWEST_FIRST = Comparator.comparing(PathAndTime::modifiedTime).reversed();
    }

    record PathAndPriority(Path path, int removalPriority) {
        public static final Comparator<PathAndPriority> HIGHEST_PRIORITY_FIRST = Comparator.comparing(PathAndPriority::removalPriority).reversed();
    }
}

