/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallSignBlock
extends SignBlock {
    public static final MapCodec<WallSignBlock> CODEC = RecordCodecBuilder.mapCodec(p_308847_ -> p_308847_.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(SignBlock::type), WallSignBlock.propertiesCodec()).apply((Applicative)p_308847_, WallSignBlock::new));
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final float AABB_THICKNESS = 2.0f;
    protected static final float AABB_BOTTOM = 4.5f;
    protected static final float AABB_TOP = 12.5f;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box(0.0, 4.5, 14.0, 16.0, 12.5, 16.0), (Object)Direction.SOUTH, (Object)Block.box(0.0, 4.5, 0.0, 16.0, 12.5, 2.0), (Object)Direction.EAST, (Object)Block.box(0.0, 4.5, 0.0, 2.0, 12.5, 16.0), (Object)Direction.WEST, (Object)Block.box(14.0, 4.5, 0.0, 16.0, 12.5, 16.0)));

    public MapCodec<WallSignBlock> codec() {
        return CODEC;
    }

    public WallSignBlock(WoodType p_58069_, BlockBehaviour.Properties p_58068_) {
        super(p_58069_, p_58068_.sound(p_58069_.soundType()));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(WATERLOGGED, false));
    }

    @Override
    public String getDescriptionId() {
        return this.asItem().getDescriptionId();
    }

    @Override
    protected VoxelShape getShape(BlockState p_58092_, BlockGetter p_58093_, BlockPos p_58094_, CollisionContext p_58095_) {
        return AABBS.get(p_58092_.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(BlockState p_58073_, LevelReader p_58074_, BlockPos p_58075_) {
        return p_58074_.getBlockState(p_58075_.relative(p_58073_.getValue(FACING).getOpposite())).isSolid();
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_58071_) {
        Direction[] $$5;
        BlockState $$1 = this.defaultBlockState();
        FluidState $$2 = p_58071_.getLevel().getFluidState(p_58071_.getClickedPos());
        Level $$3 = p_58071_.getLevel();
        BlockPos $$4 = p_58071_.getClickedPos();
        for (Direction $$6 : $$5 = p_58071_.getNearestLookingDirections()) {
            Direction $$7;
            if (!$$6.getAxis().isHorizontal() || !($$1 = (BlockState)$$1.setValue(FACING, $$7 = $$6.getOpposite())).canSurvive($$3, $$4)) continue;
            return (BlockState)$$1.setValue(WATERLOGGED, $$2.getType() == Fluids.WATER);
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState p_58083_, Direction p_58084_, BlockState p_58085_, LevelAccessor p_58086_, BlockPos p_58087_, BlockPos p_58088_) {
        if (p_58084_.getOpposite() == p_58083_.getValue(FACING) && !p_58083_.canSurvive(p_58086_, p_58087_)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(p_58083_, p_58084_, p_58085_, p_58086_, p_58087_, p_58088_);
    }

    @Override
    public float getYRotationDegrees(BlockState p_278024_) {
        return p_278024_.getValue(FACING).toYRot();
    }

    @Override
    public Vec3 getSignHitboxCenterPosition(BlockState p_278316_) {
        VoxelShape $$1 = AABBS.get(p_278316_.getValue(FACING));
        return $$1.bounds().getCenter();
    }

    @Override
    protected BlockState rotate(BlockState p_58080_, Rotation p_58081_) {
        return (BlockState)p_58080_.setValue(FACING, p_58081_.rotate(p_58080_.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState p_58077_, Mirror p_58078_) {
        return p_58077_.rotate(p_58078_.getRotation(p_58077_.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_58090_) {
        p_58090_.add(FACING, WATERLOGGED);
    }
}

