MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for armorer
    event.removeVanillaTypedTrades("minecraft:armorer");
    event.removeModdedTypedTrades("minecraft:armorer");

    // Level 1 Trades
    // Leather Armor (2 sprockets for each)
    const leatherArmor = [
        "minecraft:leather_helmet",
        "minecraft:leather_chestplate",
        "minecraft:leather_leggings",
        "minecraft:leather_boots"
    ];

    leatherArmor.forEach((armor, index) => {
        event.addTrade("minecraft:armorer", 1, Item.of("numismatics:sprocket", 2), Item.of(armor, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Armor Trim Smithing Templates (3 sprockets for each)
    const level1Trims = [
        "minecraft:host_armor_trim_smithing_template",
        "minecraft:shaper_armor_trim_smithing_template",
        "minecraft:raiser_armor_trim_smithing_template",
        "minecraft:wayfinder_armor_trim_smithing_template"
    ];

    level1Trims.forEach((trim, index) => {
        event.addTrade("minecraft:armorer", 1, Item.of("numismatics:sprocket", 3), Item.of(trim, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 2 Trades
    // Chainmail Armor (3 sprockets for each)
    const chainmailArmor = [
        "minecraft:chainmail_helmet",
        "minecraft:chainmail_chestplate",
        "minecraft:chainmail_leggings",
        "minecraft:chainmail_boots"
    ];

    chainmailArmor.forEach((armor, index) => {
        event.addTrade("minecraft:armorer", 2, Item.of("numismatics:sprocket", 3), Item.of(armor, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 12;
                offer.villagerExperience = 60;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Armor Trim Smithing Templates (1 cog for each)
    const level2Trims = [
        "minecraft:vex_armor_trim_smithing_template",
        "minecraft:ward_armor_trim_smithing_template",
        "minecraft:sentry_armor_trim_smithing_template",
        "minecraft:snout_armor_trim_smithing_template"
    ];

    level2Trims.forEach((trim, index) => {
        event.addTrade("minecraft:armorer", 2, Item.of("numismatics:cog", 1), Item.of(trim, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 12;
                offer.villagerExperience = 60;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 3 Trades
    // Iron Armor (2 cogs for each)
    const ironArmor = [
        "minecraft:iron_helmet",
        "minecraft:iron_chestplate",
        "minecraft:iron_leggings",
        "minecraft:iron_boots"
    ];

    ironArmor.forEach((armor, index) => {
        event.addTrade("minecraft:armorer", 3, Item.of("numismatics:cog", 2), Item.of(armor, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Golden Armor (2 cogs for each)
    const goldenArmor = [
        "minecraft:golden_helmet",
        "minecraft:golden_chestplate",
        "minecraft:golden_leggings",
        "minecraft:golden_boots"
    ];

    goldenArmor.forEach((armor, index) => {
        event.addTrade("minecraft:armorer", 3, Item.of("numismatics:cog", 2), Item.of(armor, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Armor Trim Smithing Templates (4 cogs for each)
    const level3Trims = [
        "minecraft:coast_armor_trim_smithing_template",
        "minecraft:rib_armor_trim_smithing_template",
        "minecraft:silence_armor_trim_smithing_template",
        "minecraft:bolt_armor_trim_smithing_template",
        "minecraft:wild_armor_trim_smithing_template"
    ];

    level3Trims.forEach((trim, index) => {
        event.addTrade("minecraft:armorer", 3, Item.of("numismatics:cog", 4), Item.of(trim, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 4 Trades
    // Diamond Armor (6 cogs for each)
    const diamondArmor = [
        "minecraft:diamond_helmet",
        "minecraft:diamond_chestplate",
        "minecraft:diamond_leggings",
        "minecraft:diamond_boots"
    ];

    diamondArmor.forEach((armor, index) => {
        event.addTrade("minecraft:armorer", 4, Item.of("numismatics:cog", 6), Item.of(armor, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 6;
                offer.villagerExperience = 150;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Armor Trim Smithing Templates and Modded Templates (6 cogs for each)
    const level4Trims = [
        "minecraft:spire_armor_trim_smithing_template",
        "minecraft:flow_armor_trim_smithing_template",
        "minecraft:eye_armor_trim_smithing_template",
        "minecraft:dune_armor_trim_smithing_template",
        "minecraft:tide_armor_trim_smithing_template",
        "create_enchantment_industry:enchanting_template"
    ];

    level4Trims.forEach((trim, index) => {
        event.addTrade("minecraft:armorer", 4, Item.of("numismatics:cog", 6), Item.of(trim, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 6;
                offer.villagerExperience = 150;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 5 Trades
    // Netherite Armor (4 crowns for each)
    const netheriteArmor = [
        "minecraft:netherite_helmet",
        "minecraft:netherite_chestplate",
        "minecraft:netherite_leggings",
        "minecraft:netherite_boots"
    ];

    netheriteArmor.forEach((armor, index) => {
        event.addTrade("minecraft:armorer", 5, Item.of("numismatics:crown", 4), Item.of(armor, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Upgrade Smithing Templates (6 crowns for each, except blaze_upgrade_smithing_template which is 4 crowns)
    const level5Trims = [
        { item: "create_enchantment_industry:super_enchanting_template", cost: 6 },
        { item: "cataclysm:cursium_upgrade_smithing_template", cost: 6 },
        { item: "cataclysm:ignitium_upgrade_smithing_template", cost: 6 },
        { item: "minecraft:netherite_upgrade_smithing_template", cost: 6 },
        { item: "nexus:chrono_upgrade_smithing_template", cost: 6 },
        { item: "create_dragons_plus:blaze_upgrade_smithing_template", cost: 4 }
    ];

    level5Trims.forEach((trim, index) => {
        event.addTrade("minecraft:armorer", 5, Item.of("numismatics:crown", trim.cost), Item.of(trim.item, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });
});