MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for cartographer
    event.removeVanillaTypedTrades("minecraft:cartographer");
    event.removeModdedTypedTrades("minecraft:cartographer");

    // 1 sprocket for 1 item_frame
    event.addTrade("minecraft:cartographer", 1, Item.of("numismatics:cog", 1), Item.of("kubejs:nether_key", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 1 Trades
    // Flowers (4 of each flower for 1 bevel)
    const flowers = [
        "minecraft:dandelion",
        "minecraft:poppy",
        "minecraft:blue_orchid",
        "minecraft:allium",
        "minecraft:azure_bluet",
        "minecraft:red_tulip",
        "minecraft:orange_tulip",
        "minecraft:white_tulip",
        "minecraft:pink_tulip",
        "minecraft:oxeye_daisy",
        "minecraft:cornflower",
        "minecraft:lily_of_the_valley",
        "minecraft:wither_rose",
        "minecraft:torchflower",
        "minecraft:pitcher_plant",
        "minecraft:sunflower",
        "minecraft:lilac",
        "minecraft:rose_bush",
        "minecraft:peony"
    ];

    flowers.forEach((flower, index) => {
        event.addTrade("minecraft:cartographer", 2, Item.of("numismatics:bevel", 1), Item.of(flower, 4))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // 1 sprocket for 1 item_frame
    event.addTrade("minecraft:cartographer", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:item_frame", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 map
    event.addTrade("minecraft:cartographer", 1, Item.of("numismatics:sprocket", 1), Item.of("minecraft:map", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2 Trades
    // 1 sprocket for 1 compass
    event.addTrade("minecraft:cartographer", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:compass", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 1 spyglass
    event.addTrade("minecraft:cartographer", 2, Item.of("numismatics:sprocket", 2), Item.of("minecraft:spyglass", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Banner Colors (1 of each banner for 1 sprocket)
    const banners = [
        "minecraft:white_banner",
        "minecraft:orange_banner",
        "minecraft:magenta_banner",
        "minecraft:light_blue_banner",
        "minecraft:yellow_banner",
        "minecraft:lime_banner",
        "minecraft:pink_banner",
        "minecraft:gray_banner",
        "minecraft:light_gray_banner",
        "minecraft:cyan_banner",
        "minecraft:purple_banner",
        "minecraft:blue_banner",
        "minecraft:brown_banner",
        "minecraft:green_banner",
        "minecraft:red_banner",
        "minecraft:black_banner"
    ];

    banners.forEach((banner, index) => {
        event.addTrade("minecraft:cartographer", 2, Item.of("numismatics:sprocket", 1), Item.of(banner, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 12;
                offer.villagerExperience = 60;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 3 Trades
    // 3 sprockets for 1 recovery_compass
    event.addTrade("minecraft:cartographer", 3, Item.of("numismatics:sprocket", 3), Item.of("minecraft:recovery_compass", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Banner Patterns (1 of each pattern for 1 cog)
    const patterns = [
        "minecraft:creeper_banner_pattern",
        "minecraft:skull_banner_pattern",
        "minecraft:flower_banner_pattern",
        "minecraft:mojang_banner_pattern",
        "minecraft:globe_banner_pattern",
        "minecraft:piglin_banner_pattern",
        "minecraft:flow_banner_pattern",
        "minecraft:guster_banner_pattern"
    ];

    patterns.forEach((pattern, index) => {
        event.addTrade("minecraft:cartographer", 3, Item.of("numismatics:cog", 1), Item.of(pattern, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // 1 cog for 1 sniffer_egg
    event.addTrade("minecraft:cartographer", 3, Item.of("numismatics:cog", 1), Item.of("minecraft:sniffer_egg", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4 Trades
    // 1 cog for 1 goat_horn
    event.addTrade("minecraft:cartographer", 4, Item.of("numismatics:cog", 1), Item.of("minecraft:goat_horn", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Saplings (4 cogs for 1 of each sapling)
    const saplings = [
        "minecraft:oak_sapling",
        "minecraft:spruce_sapling",
        "minecraft:birch_sapling",
        "minecraft:jungle_sapling",
        "minecraft:acacia_sapling",
        "minecraft:dark_oak_sapling",
        "minecraft:mangrove_propagule",
        "minecraft:cherry_sapling",
        "minecraft:azalea",
        "minecraft:flowering_azalea"
    ];

    saplings.forEach((sapling, index) => {
        event.addTrade("minecraft:cartographer", 4, Item.of("numismatics:cog", 4), Item.of(sapling, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 6;
                offer.villagerExperience = 150;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 5 Trades
    // Spawn Eggs (6 cogs for 1 of each spawn egg)
    const spawnEggs = [
        "minecraft:camel_spawn_egg",
        "minecraft:polar_bear_spawn_egg",
        "minecraft:axolotl_spawn_egg",
        "minecraft:goat_spawn_egg",
        "minecraft:armadillo_spawn_egg",
        "minecraft:panda_spawn_egg",
        "minecraft:allay_spawn_egg",
        "minecraft:parrot_spawn_egg"
    ];

    spawnEggs.forEach((egg, index) => {
        event.addTrade("minecraft:cartographer", 4, Item.of("numismatics:cog", 6), Item.of(egg, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Music Discs (1 crown for 1 of each music disc)
    const musicDiscs = [
        "minecraft:music_disc_13",
        "minecraft:music_disc_cat",
        "minecraft:music_disc_blocks",
        "minecraft:music_disc_chirp",
        "minecraft:music_disc_far",
        "minecraft:music_disc_mall",
        "minecraft:music_disc_mellohi",
        "minecraft:music_disc_stal",
        "minecraft:music_disc_strad",
        "minecraft:music_disc_ward",
        "minecraft:music_disc_11",
        "minecraft:music_disc_wait",
        "minecraft:music_disc_otherside",
        "minecraft:music_disc_5",
        "minecraft:music_disc_pigstep",
        "minecraft:music_disc_relic",
        "minecraft:music_disc_creator",
        "minecraft:music_disc_creator_music_box",
        "minecraft:music_disc_precipice"
    ];

    musicDiscs.forEach((disc, index) => {
        event.addTrade("minecraft:cartographer", 4, Item.of("numismatics:crown", 1), Item.of(disc, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // 1 cog for 1 goat_horn
    event.addTrade("minecraft:cartographer", 5, Item.of("numismatics:sun", 64), Item.of("kubejs:end_key", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });
});