MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for fisherman
    event.removeVanillaTypedTrades("minecraft:fisherman");
    event.removeModdedTypedTrades("minecraft:fisherman");

    // Level 1 Trades
    // 1 bevel for 1 fishing_rod
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:fishing_rod", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 bevel for 4 kelp
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:kelp", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 bevel for 4 seagrass
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:bevel", 1), Item.of("minecraft:seagrass", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 2 fish_bones
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:sprocket", 1), Item.of("hybrid-aquatic:barbed_hook", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 1 iron_hook
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:sprocket", 2), Item.of("hybrid-aquatic:glowing_hook", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 fishing_line
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:sprocket", 1), Item.of("hybrid-aquatic:magnetic_hook", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 1 bobber
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:sprocket", 1), Item.of("hybrid-aquatic:creepermagnet_hook", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 1 tackle_box
    event.addTrade("minecraft:fisherman", 1, Item.of("numismatics:sprocket", 3), Item.of("hybrid-aquatic:ominous_hook", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2 Trades
    // 1 sprocket for 2 cod
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:cod", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 2 salmon
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:salmon", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 2 tropical_fish
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 1), Item.of("minecraft:tropical_fish", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 3 ink_sac
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 2), Item.of("minecraft:ink_sac", 3))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 sprockets for 4 fish_fillet_raw
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:sprocket", 2), Item.of("hybrid-aquatic:raw_fish_meat", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 cog for 1 gold_hook
    event.addTrade("minecraft:fisherman", 2, Item.of("numismatics:cog", 1), Item.of("hybrid-aquatic:moon_jellyfish_hat", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 12;
            offer.villagerExperience = 60;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 3 Trades
    // 1 cog for 3 glow_ink_sac
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:cog", 1), Item.of("minecraft:glow_ink_sac", 3))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 sprocket for 6 algae
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:sprocket", 1), Item.of("hybrid-aquatic:raw_crab", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 4 cogs for 1 diamond_hook
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:cog", 4), Item.of("hybrid-aquatic:raw_lobster", 2))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 8 leech
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:sprocket", 3), Item.of("hybrid-aquatic:raw_lobster_tail", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 8 worm
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:sprocket", 3), Item.of("hybrid-aquatic:raw_shrimp", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 8 minnow
    event.addTrade("minecraft:fisherman", 3, Item.of("numismatics:sprocket", 3), Item.of("hybrid-aquatic:raw_crayfish", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 8;
            offer.villagerExperience = 80;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 4 Trades
    // 3 sprockets for 1 guardian
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:sprocket", 3), Item.of("oceansdelight:guardian", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 4 tentacles
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:sprocket", 3), Item.of("oceansdelight:tentacles", 4))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 1 box_turtle
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:sprocket", 3), Item.of("hybrid-aquatic:shark_tooth", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 cogs for 1 note_hook
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:cog", 2), Item.of("hybrid-aquatic:coral_chunk", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 cogs for 1 redstone_hook
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:cog", 2), Item.of("hybrid-aquatic:cuttlebone", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 cogs for 1 double_hook
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:cog", 2), Item.of("hybrid-aquatic:eel_scarf", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 cogs for 1 heavy_hook
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:cog", 2), Item.of("hybrid-aquatic:moon_jellyfish_hat", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 2 cogs for 1 light_hook
    event.addTrade("minecraft:fisherman", 4, Item.of("numismatics:cog", 2), Item.of("hybrid-aquatic:pearl", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 6;
            offer.villagerExperience = 150;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 5 Trades
    // 2 cogs for 1 elder_guardian_slab
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:cog", 2), Item.of("oceansdelight:elder_guardian_slab", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 3 sprockets for 8 sea_pickle
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:sprocket", 3), Item.of("minecraft:sea_pickle", 8))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 cog for 1 turtle_scute
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:cog", 1), Item.of("minecraft:turtle_scute", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 4 crowns for 1 nether_star_hook
    event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:crown", 4), Item.of("hybrid-aquatic:black_pearl", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Spawn Eggs (6 cogs for 1 of each spawn egg)
    const spawnEggs = [
        "minecraft:dolphin_spawn_egg",
        "minecraft:pufferfish_spawn_egg",
        "minecraft:salmon_spawn_egg",
        "minecraft:guardian_spawn_egg",
        "minecraft:glow_squid_spawn_egg",
        "minecraft:tropical_fish_spawn_egg",
        "minecraft:cod_spawn_egg",
        "minecraft:tadpole_spawn_egg",
        "minecraft:squid_spawn_egg",
        "minecraft:turtle_spawn_egg"
    ];

    spawnEggs.forEach((egg, index) => {
        event.addTrade("minecraft:fisherman", 5, Item.of("numismatics:cog", 6), Item.of(egg, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 4;
                offer.villagerExperience = 250;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });
});