MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for mason
    event.removeVanillaTypedTrades("minecraft:mason");
    event.removeModdedTypedTrades("minecraft:mason");

    // Level 1 Trades
    // 4 cardboard for 1 bevel
    event.addTrade("minecraft:mason", 1, Item.of("create:cardboard", 4), Item.of("numismatics:bevel", 1))
        .transform((offer, entity, random) => {
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 builders_tea for 1 sprocket
    event.addTrade("minecraft:mason", 1, Item.of("create:builders_tea", 1), Item.of("numismatics:sprocket", 1))
        .transform((offer, entity, random) => {
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Workbenches for 2 sprockets each
    const workbenches = [
        "chipped:botanist_workbench",
        "chipped:tinkering_table",
        "chipped:alchemy_bench",
        "chipped:mason_table",
        "chipped:loom_table",
        "chipped:carpenters_table",
        "chipped:glassblower"
    ];

    workbenches.forEach(workbench => {
        event.addTrade("minecraft:mason", 1, Item.of("numismatics:sprocket", 2), Item.of(workbench, 1))
            .transform((offer, entity, random) => {
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 2 Trades
    const level2Items = [
        "chipped:watering_can",
        "chipped:multimeter",
        "chipped:saw",
        "chipped:needles",
        "chipped:chisel",
        "chipped:alchemy_book"
    ];

    level2Items.forEach(item => {
        event.addTrade("minecraft:mason", 2, Item.of("numismatics:sprocket", 2), Item.of(item, 1))
            .transform((offer, entity, random) => {
                offer.maxUses = 12;
                offer.villagerExperience = 60;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 3 Trades
    const saws = [
        "createqol:botanist_saw",
        "createqol:glassblower_saw",
        "createqol:carpenters_saw",
        "createqol:loom_saw",
        "createqol:mason_saw",
        "createqol:alchemy_saw",
        "createqol:tinkering_saw"
    ];

    saws.forEach(saw => {
        event.addTrade("minecraft:mason", 3, Item.of("numismatics:sprocket", 3), Item.of(saw, 1))
            .transform((offer, entity, random) => {
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 4 Trades
    // 1 trash_can for 3 sprockets
    event.addTrade("minecraft:mason", 4, Item.of("numismatics:sprocket", 3), Item.of("createqol:trash_can", 1))
        .transform((offer, entity, random) => {
            offer.maxUses = 8;
            offer.villagerExperience = 100;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // 1 brass_trash_can for 1 cog
    event.addTrade("minecraft:mason", 4, Item.of("numismatics:cog", 1), Item.of("createqol:brass_trash_can", 1))
        .transform((offer, entity, random) => {
            offer.maxUses = 8;
            offer.villagerExperience = 100;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 5 Trades
    const lightItems = [
        "simplylight:lamp_post",
        "simplylight:edge_light",
        "simplylight:wall_lamp",
        "simplylight:rodlamp",
        "simplylight:illuminant_panel",
        "simplylight:illuminant_block_on",
        "simplylight:illuminant_block"
    ];

    lightItems.forEach(light => {
        event.addTrade("minecraft:mason", 5, Item.of("numismatics:cog", 1), Item.of(light, 16))
            .transform((offer, entity, random) => {
                offer.maxUses = 8;
                offer.villagerExperience = 120;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });
});