ServerEvents.commandRegistry(event => {
  const { commands: Commands } = event;

  event.register(
    Commands.literal('rules') // Command name: /rules
      .executes(ctx => {
        const player = ctx.source.player; // Get the player who ran the command
        if (!player) return 0; // Fail if not a player (e.g., console)

        // Send rules as chat messages with formatting
        player.displayClientMessage(Component.gold('=== Server Rules ==='), false);
        player.displayClientMessage(Component.white('1. No griefing or stealing from other players.'), false);
        player.displayClientMessage(Component.white('2. No cheating, hacking, or exploiting bugs.'), false);
        player.displayClientMessage(Component.white('3. Keep builds appropriate and lag-friendly.'), false);
        player.displayClientMessage(Component.white('4. Just because a rule against something isn\'t listed here doesn\'t mean it\'s okay, so just try to use common sense!'), false);
        player.displayClientMessage(Component.gold('==================='), false);

        return 1; // Success
      })
  );
});


