MoreJS.villagerTrades(event => {
    // Remove all vanilla and modded trades for shepherd
    event.removeVanillaTypedTrades("minecraft:shepherd");
    event.removeModdedTypedTrades("minecraft:shepherd");

    // Level 1 Trades
    // Dyes (1 bevel for 4 of each dye color)
    const dyes = [
        "minecraft:white_dye",
        "minecraft:orange_dye",
        "minecraft:magenta_dye",
        "minecraft:light_blue_dye",
        "minecraft:yellow_dye",
        "minecraft:lime_dye",
        "minecraft:pink_dye",
        "minecraft:gray_dye",
        "minecraft:light_gray_dye",
        "minecraft:cyan_dye",
        "minecraft:purple_dye",
        "minecraft:blue_dye",
        "minecraft:brown_dye",
        "minecraft:green_dye",
        "minecraft:red_dye",
        "minecraft:black_dye"
    ];

    dyes.forEach((dye, index) => {
        event.addTrade("minecraft:shepherd", 1, Item.of("numismatics:bevel", 1), Item.of(dye, 4))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 16;
                offer.villagerExperience = 10;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // 1 sprocket for 1 shears
    event.addTrade("minecraft:shepherd", 1, Item.of("numismatics:sprocket", 1), Item.of("minecraft:shears", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 16;
            offer.villagerExperience = 10;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });

    // Level 2 Trades
    // Wool (1 sprocket for 1 of each wool color)
    const wools = [
        "minecraft:white_wool",
        "minecraft:orange_wool",
        "minecraft:magenta_wool",
        "minecraft:light_blue_wool",
        "minecraft:yellow_wool",
        "minecraft:lime_wool",
        "minecraft:pink_wool",
        "minecraft:gray_wool",
        "minecraft:light_gray_wool",
        "minecraft:cyan_wool",
        "minecraft:purple_wool",
        "minecraft:blue_wool",
        "minecraft:brown_wool",
        "minecraft:green_wool",
        "minecraft:red_wool",
        "minecraft:black_wool"
    ];

    wools.forEach((wool, index) => {
        event.addTrade("minecraft:shepherd", 2, Item.of("numismatics:sprocket", 1), Item.of(wool, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 12;
                offer.villagerExperience = 60;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 3 Trades
    // Carpets (1 sprocket for 3 of each carpet color)
    const carpets = [
        "minecraft:white_carpet",
        "minecraft:orange_carpet",
        "minecraft:magenta_carpet",
        "minecraft:light_blue_carpet",
        "minecraft:yellow_carpet",
        "minecraft:lime_carpet",
        "minecraft:pink_carpet",
        "minecraft:gray_carpet",
        "minecraft:light_gray_carpet",
        "minecraft:cyan_carpet",
        "minecraft:purple_carpet",
        "minecraft:blue_carpet",
        "minecraft:brown_carpet",
        "minecraft:green_carpet",
        "minecraft:red_carpet",
        "minecraft:black_carpet"
    ];

    carpets.forEach((carpet, index) => {
        event.addTrade("minecraft:shepherd", 3, Item.of("numismatics:sprocket", 1), Item.of(carpet, 3))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 8;
                offer.villagerExperience = 80;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 4 Trades
    // Beds (3 sprockets for 1 of each bed color)
    const beds = [
        "minecraft:white_bed",
        "minecraft:orange_bed",
        "minecraft:magenta_bed",
        "minecraft:light_blue_bed",
        "minecraft:yellow_bed",
        "minecraft:lime_bed",
        "minecraft:pink_bed",
        "minecraft:gray_bed",
        "minecraft:light_gray_bed",
        "minecraft:cyan_bed",
        "minecraft:purple_bed",
        "minecraft:blue_bed",
        "minecraft:brown_bed",
        "minecraft:green_bed",
        "minecraft:red_bed",
        "minecraft:black_bed"
    ];

    beds.forEach((bed, index) => {
        event.addTrade("minecraft:shepherd", 4, Item.of("numismatics:sprocket", 3), Item.of(bed, 1))
            .transform((offer, entity, random) => {
                if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                    offer.setDisabled(true);
                    return;
                }
                offer.maxUses = 6;
                offer.villagerExperience = 150;
                offer.priceMultiplier = 0.05;
                offer.demand = 5;
            });
    });

    // Level 5 Trades
    // 4 cogs for 1 sheep_spawn_egg
    event.addTrade("minecraft:shepherd", 5, Item.of("numismatics:cog", 4), Item.of("minecraft:sheep_spawn_egg", 1))
        .transform((offer, entity, random) => {
            if (offer.firstCost.isEmpty() || offer.output.isEmpty()) {
                offer.setDisabled(true);
                return;
            }
            offer.maxUses = 4;
            offer.villagerExperience = 250;
            offer.priceMultiplier = 0.05;
            offer.demand = 5;
        });
});