// kubejs/server_scripts/trading.js
ServerEvents.recipes(event => {
  // Value 1: Spur (Basic, quick trades for common items)
  event.custom({
    type: 'trading_station:trading',
    result: { id: 'numismatics:spur', count: 1 },
    ingredients: [{ ingredient: { tag: 'numismatics:value_1' }, count: 1 }],
    processingTime: 5000, // ~5 seconds, minimal delay for common items
    requirements: [
    {
      "value": [
        "powered",
        "mechanical"
      ],
      "type": "trading_station:machine_id"
    }
    ]
  });

  // Value 8: Bevel (Powered, moderate delay)
  event.custom({
    type: 'trading_station:trading',
    result: { id: 'numismatics:bevel', count: 1 },
    ingredients: [{ ingredient: { tag: 'numismatics:value_8' }, count: 1 }],
    processingTime: 4000, // ~10 seconds, moderate grind
    requirements: [
    {
      "value": [
        "powered",
        "mechanical"
      ],
      "type": "trading_station:machine_id"
    }
    ]
  });

  // Value 16: Sprocket (Mechanical, longer delay)
  event.custom({
    type: 'trading_station:trading',
    result: { id: 'numismatics:sprocket', count: 1 },
    ingredients: [{ ingredient: { tag: 'numismatics:value_16' }, count: 1 }],
    processingTime: 3000, // ~20 seconds, significant for automation
    requirements: [
    {
      "value": [
        "powered",
        "mechanical"
      ],
      "type": "trading_station:machine_id"
    }
    ]
  });

  // Value 64: Cog (Mechanical + Powered, long delay)
  event.custom({
    type: 'trading_station:trading',
    result: { id: 'numismatics:cog', count: 1 },
    ingredients: [{ ingredient: { tag: 'numismatics:value_64' }, count: 1 }],
    processingTime: 2000, // ~30 seconds, high effort for diamond gear
    requirements: [
    {
      "value": [
        "powered",
        "mechanical"
      ],
      "type": "trading_station:machine_id"
    }
    ]
  });

  // Value 512: Crown (Ender, very long delay)
  event.custom({
    type: 'trading_station:trading',
    result: { id: 'numismatics:crown', count: 1 },
    ingredients: [{ ingredient: { tag: 'numismatics:value_512' }, count: 1 }],
    processingTime: 1000, // ~50 seconds, punishing for netherite gear
    requirements: [
    {
      "value": [
        "powered",
        "mechanical"
      ],
      "type": "trading_station:machine_id"
    }
    ]
  });

  // Value 4096: Sun (Ender + Powered, extremely long delay)
  event.custom({
    type: 'trading_station:trading',
    result: { id: 'numismatics:sun', count: 1 },
    ingredients: [{ ingredient: { tag: 'numismatics:value_4096' }, count: 1 }],
    processingTime: 25, // ~100 seconds, brutal for end-game items
    requirements: [
    {
      "value": [
        "powered",
        "mechanical"
      ],
      "type": "trading_station:machine_id"
    }
    ]
  });
});