/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.slf4j.Logger;

public class ClientRecipeBook
extends RecipeBook {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<RecipeBookCategories, List<RecipeCollection>> collectionsByTab = ImmutableMap.of();
    private List<RecipeCollection> allCollections = ImmutableList.of();

    public void setupCollections(Iterable<RecipeHolder<?>> p_266814_, RegistryAccess p_266878_) {
        Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> $$2 = ClientRecipeBook.categorizeAndGroupRecipes(p_266814_);
        HashMap $$3 = Maps.newHashMap();
        ImmutableList.Builder $$4 = ImmutableList.builder();
        $$2.forEach((p_266602_, p_266603_) -> $$3.put(p_266602_, (List)p_266603_.stream().map(p_266605_ -> new RecipeCollection(p_266878_, (List<RecipeHolder<?>>)p_266605_)).peek(arg_0 -> ((ImmutableList.Builder)$$4).add(arg_0)).collect(ImmutableList.toImmutableList())));
        RecipeBookCategories.AGGREGATE_CATEGORIES.forEach((p_90637_, p_90638_) -> $$3.put(p_90637_, (List)p_90638_.stream().flatMap(p_167706_ -> ((List)$$3.getOrDefault(p_167706_, ImmutableList.of())).stream()).collect(ImmutableList.toImmutableList())));
        this.collectionsByTab = ImmutableMap.copyOf((Map)$$3);
        this.allCollections = $$4.build();
    }

    private static Map<RecipeBookCategories, List<List<RecipeHolder<?>>>> categorizeAndGroupRecipes(Iterable<RecipeHolder<?>> p_90643_) {
        HashMap $$1 = Maps.newHashMap();
        HashBasedTable $$2 = HashBasedTable.create();
        for (RecipeHolder<?> $$3 : p_90643_) {
            Object $$4 = $$3.value();
            if ($$4.isSpecial() || $$4.isIncomplete()) continue;
            RecipeBookCategories $$5 = ClientRecipeBook.getCategory($$3);
            String $$6 = $$4.getGroup();
            if ($$6.isEmpty()) {
                $$1.computeIfAbsent($$5, p_90645_ -> Lists.newArrayList()).add(ImmutableList.of($$3));
                continue;
            }
            List $$7 = (List)$$2.get((Object)$$5, (Object)$$6);
            if ($$7 == null) {
                $$7 = Lists.newArrayList();
                $$2.put((Object)$$5, (Object)$$6, (Object)$$7);
                $$1.computeIfAbsent($$5, p_90641_ -> Lists.newArrayList()).add($$7);
            }
            $$7.add($$3);
        }
        return $$1;
    }

    private static RecipeBookCategories getCategory(RecipeHolder<?> p_301136_) {
        Object $$1 = p_301136_.value();
        if ($$1 instanceof CraftingRecipe) {
            CraftingRecipe $$2 = (CraftingRecipe)$$1;
            return switch ($$2.category()) {
                default -> throw new MatchException(null, null);
                case CraftingBookCategory.BUILDING -> RecipeBookCategories.CRAFTING_BUILDING_BLOCKS;
                case CraftingBookCategory.EQUIPMENT -> RecipeBookCategories.CRAFTING_EQUIPMENT;
                case CraftingBookCategory.REDSTONE -> RecipeBookCategories.CRAFTING_REDSTONE;
                case CraftingBookCategory.MISC -> RecipeBookCategories.CRAFTING_MISC;
            };
        }
        RecipeType<?> $$3 = $$1.getType();
        if ($$1 instanceof AbstractCookingRecipe) {
            AbstractCookingRecipe $$4 = (AbstractCookingRecipe)$$1;
            CookingBookCategory $$5 = $$4.category();
            if ($$3 == RecipeType.SMELTING) {
                return switch ($$5) {
                    default -> throw new MatchException(null, null);
                    case CookingBookCategory.BLOCKS -> RecipeBookCategories.FURNACE_BLOCKS;
                    case CookingBookCategory.FOOD -> RecipeBookCategories.FURNACE_FOOD;
                    case CookingBookCategory.MISC -> RecipeBookCategories.FURNACE_MISC;
                };
            }
            if ($$3 == RecipeType.BLASTING) {
                return $$5 == CookingBookCategory.BLOCKS ? RecipeBookCategories.BLAST_FURNACE_BLOCKS : RecipeBookCategories.BLAST_FURNACE_MISC;
            }
            if ($$3 == RecipeType.SMOKING) {
                return RecipeBookCategories.SMOKER_FOOD;
            }
            if ($$3 == RecipeType.CAMPFIRE_COOKING) {
                return RecipeBookCategories.CAMPFIRE;
            }
        }
        if ($$3 == RecipeType.STONECUTTING) {
            return RecipeBookCategories.STONECUTTER;
        }
        if ($$3 == RecipeType.SMITHING) {
            return RecipeBookCategories.SMITHING;
        }
        LOGGER.warn("Unknown recipe category: {}/{}", LogUtils.defer(() -> BuiltInRegistries.RECIPE_TYPE.getKey($$1.getType())), LogUtils.defer(p_301136_::id));
        return RecipeBookCategories.UNKNOWN;
    }

    public List<RecipeCollection> getCollections() {
        return this.allCollections;
    }

    public List<RecipeCollection> getCollection(RecipeBookCategories p_90624_) {
        return this.collectionsByTab.getOrDefault((Object)p_90624_, Collections.emptyList());
    }
}

