/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockTintCache;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.prediction.BlockStatePredictionHandler;
import net.minecraft.client.particle.FireworkParticles;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.resources.sounds.EntityBoundSoundInstance;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Difficulty;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.TransientEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.slf4j.Logger;

public class ClientLevel
extends Level {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final double FLUID_PARTICLE_SPAWN_OFFSET = 0.05;
    private static final int NORMAL_LIGHT_UPDATES_PER_FRAME = 10;
    private static final int LIGHT_UPDATE_QUEUE_SIZE_THRESHOLD = 1000;
    final EntityTickList tickingEntities = new EntityTickList();
    private final TransientEntitySectionManager<Entity> entityStorage = new TransientEntitySectionManager<Entity>(Entity.class, new EntityCallbacks());
    private final ClientPacketListener connection;
    private final LevelRenderer levelRenderer;
    private final ClientLevelData clientLevelData;
    private final DimensionSpecialEffects effects;
    private final TickRateManager tickRateManager;
    private final Minecraft minecraft = Minecraft.getInstance();
    final List<AbstractClientPlayer> players = Lists.newArrayList();
    private final Map<MapId, MapItemSavedData> mapData = Maps.newHashMap();
    private static final long CLOUD_COLOR = 0xFFFFFFL;
    private int skyFlashTime;
    private final Object2ObjectArrayMap<ColorResolver, BlockTintCache> tintCaches = Util.make(new Object2ObjectArrayMap(3), p_194170_ -> {
        p_194170_.put((Object)BiomeColors.GRASS_COLOR_RESOLVER, (Object)new BlockTintCache(p_194181_ -> this.calculateBlockTint((BlockPos)p_194181_, BiomeColors.GRASS_COLOR_RESOLVER)));
        p_194170_.put((Object)BiomeColors.FOLIAGE_COLOR_RESOLVER, (Object)new BlockTintCache(p_194177_ -> this.calculateBlockTint((BlockPos)p_194177_, BiomeColors.FOLIAGE_COLOR_RESOLVER)));
        p_194170_.put((Object)BiomeColors.WATER_COLOR_RESOLVER, (Object)new BlockTintCache(p_194168_ -> this.calculateBlockTint((BlockPos)p_194168_, BiomeColors.WATER_COLOR_RESOLVER)));
    });
    private final ClientChunkCache chunkSource;
    private final Deque<Runnable> lightUpdateQueue = Queues.newArrayDeque();
    private int serverSimulationDistance;
    private final BlockStatePredictionHandler blockStatePredictionHandler = new BlockStatePredictionHandler();
    private static final Set<Item> MARKER_PARTICLE_ITEMS = Set.of(Items.BARRIER, Items.LIGHT);

    public void handleBlockChangedAck(int p_233652_) {
        this.blockStatePredictionHandler.endPredictionsUpTo(p_233652_, this);
    }

    public void setServerVerifiedBlockState(BlockPos p_233654_, BlockState p_233655_, int p_233656_) {
        if (!this.blockStatePredictionHandler.updateKnownServerState(p_233654_, p_233655_)) {
            super.setBlock(p_233654_, p_233655_, p_233656_, 512);
        }
    }

    public void syncBlockState(BlockPos p_233648_, BlockState p_233649_, Vec3 p_233650_) {
        BlockState $$3 = this.getBlockState(p_233648_);
        if ($$3 != p_233649_) {
            this.setBlock(p_233648_, p_233649_, 19);
            LocalPlayer $$4 = this.minecraft.player;
            if (this == $$4.level() && $$4.isColliding(p_233648_, p_233649_)) {
                $$4.absMoveTo(p_233650_.x, p_233650_.y, p_233650_.z);
            }
        }
    }

    BlockStatePredictionHandler getBlockStatePredictionHandler() {
        return this.blockStatePredictionHandler;
    }

    @Override
    public boolean setBlock(BlockPos p_233643_, BlockState p_233644_, int p_233645_, int p_233646_) {
        if (this.blockStatePredictionHandler.isPredicting()) {
            BlockState $$4 = this.getBlockState(p_233643_);
            boolean $$5 = super.setBlock(p_233643_, p_233644_, p_233645_, p_233646_);
            if ($$5) {
                this.blockStatePredictionHandler.retainKnownServerState(p_233643_, $$4, this.minecraft.player);
            }
            return $$5;
        }
        return super.setBlock(p_233643_, p_233644_, p_233645_, p_233646_);
    }

    public ClientLevel(ClientPacketListener p_205505_, ClientLevelData p_205506_, ResourceKey<Level> p_205507_, Holder<DimensionType> p_205508_, int p_205509_, int p_205510_, Supplier<ProfilerFiller> p_205511_, LevelRenderer p_205512_, boolean p_205513_, long p_205514_) {
        super(p_205506_, p_205507_, p_205505_.registryAccess(), p_205508_, p_205511_, true, p_205513_, p_205514_, 1000000);
        this.connection = p_205505_;
        this.chunkSource = new ClientChunkCache(this, p_205509_);
        this.tickRateManager = new TickRateManager();
        this.clientLevelData = p_205506_;
        this.levelRenderer = p_205512_;
        this.effects = DimensionSpecialEffects.forType(p_205508_.value());
        this.setDefaultSpawnPos(new BlockPos(8, 64, 8), 0.0f);
        this.serverSimulationDistance = p_205510_;
        this.updateSkyBrightness();
        this.prepareWeather();
    }

    public void queueLightUpdate(Runnable p_194172_) {
        this.lightUpdateQueue.add(p_194172_);
    }

    public void pollLightUpdates() {
        Runnable $$3;
        int $$0 = this.lightUpdateQueue.size();
        int $$1 = $$0 < 1000 ? Math.max(10, $$0 / 10) : $$0;
        for (int $$2 = 0; $$2 < $$1 && ($$3 = this.lightUpdateQueue.poll()) != null; ++$$2) {
            $$3.run();
        }
    }

    public boolean isLightUpdateQueueEmpty() {
        return this.lightUpdateQueue.isEmpty();
    }

    public DimensionSpecialEffects effects() {
        return this.effects;
    }

    public void tick(BooleanSupplier p_104727_) {
        this.getWorldBorder().tick();
        if (this.tickRateManager().runsNormally()) {
            this.tickTime();
        }
        if (this.skyFlashTime > 0) {
            this.setSkyFlashTime(this.skyFlashTime - 1);
        }
        this.getProfiler().push("blocks");
        this.chunkSource.tick(p_104727_, true);
        this.getProfiler().pop();
    }

    private void tickTime() {
        this.setGameTime(this.levelData.getGameTime() + 1L);
        if (this.levelData.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)) {
            this.setDayTime(this.levelData.getDayTime() + 1L);
        }
    }

    public void setGameTime(long p_104638_) {
        this.clientLevelData.setGameTime(p_104638_);
    }

    public void setDayTime(long p_104747_) {
        if (p_104747_ < 0L) {
            p_104747_ = -p_104747_;
            this.getGameRules().getRule(GameRules.RULE_DAYLIGHT).set(false, null);
        } else {
            this.getGameRules().getRule(GameRules.RULE_DAYLIGHT).set(true, null);
        }
        this.clientLevelData.setDayTime(p_104747_);
    }

    public Iterable<Entity> entitiesForRendering() {
        return this.getEntities().getAll();
    }

    public void tickEntities() {
        ProfilerFiller $$0 = this.getProfiler();
        $$0.push("entities");
        this.tickingEntities.forEach(p_308457_ -> {
            if (p_308457_.isRemoved() || p_308457_.isPassenger() || this.tickRateManager.isEntityFrozen((Entity)p_308457_)) {
                return;
            }
            this.guardEntityTick(this::tickNonPassenger, p_308457_);
        });
        $$0.pop();
        this.tickBlockEntities();
    }

    @Override
    public boolean shouldTickDeath(Entity p_194185_) {
        return p_194185_.chunkPosition().getChessboardDistance(this.minecraft.player.chunkPosition()) <= this.serverSimulationDistance;
    }

    public void tickNonPassenger(Entity p_104640_) {
        p_104640_.setOldPosAndRot();
        ++p_104640_.tickCount;
        this.getProfiler().push(() -> BuiltInRegistries.ENTITY_TYPE.getKey(p_104640_.getType()).toString());
        p_104640_.tick();
        this.getProfiler().pop();
        for (Entity $$1 : p_104640_.getPassengers()) {
            this.tickPassenger(p_104640_, $$1);
        }
    }

    private void tickPassenger(Entity p_104642_, Entity p_104643_) {
        if (p_104643_.isRemoved() || p_104643_.getVehicle() != p_104642_) {
            p_104643_.stopRiding();
            return;
        }
        if (!(p_104643_ instanceof Player) && !this.tickingEntities.contains(p_104643_)) {
            return;
        }
        p_104643_.setOldPosAndRot();
        ++p_104643_.tickCount;
        p_104643_.rideTick();
        for (Entity $$2 : p_104643_.getPassengers()) {
            this.tickPassenger(p_104643_, $$2);
        }
    }

    public void unload(LevelChunk p_104666_) {
        p_104666_.clearAllBlockEntities();
        this.chunkSource.getLightEngine().setLightEnabled(p_104666_.getPos(), false);
        this.entityStorage.stopTicking(p_104666_.getPos());
    }

    public void onChunkLoaded(ChunkPos p_171650_) {
        this.tintCaches.forEach((p_194154_, p_194155_) -> p_194155_.invalidateForChunk(p_194153_.x, p_194153_.z));
        this.entityStorage.startTicking(p_171650_);
        this.levelRenderer.onChunkLoaded(p_171650_);
    }

    public void clearTintCaches() {
        this.tintCaches.forEach((p_194157_, p_194158_) -> p_194158_.invalidateAll());
    }

    @Override
    public boolean hasChunk(int p_104737_, int p_104738_) {
        return true;
    }

    public int getEntityCount() {
        return this.entityStorage.count();
    }

    public void addEntity(Entity p_104741_) {
        this.removeEntity(p_104741_.getId(), Entity.RemovalReason.DISCARDED);
        this.entityStorage.addEntity(p_104741_);
    }

    public void removeEntity(int p_171643_, Entity.RemovalReason p_171644_) {
        Entity $$2 = this.getEntities().get(p_171643_);
        if ($$2 != null) {
            $$2.setRemoved(p_171644_);
            $$2.onClientRemoval();
        }
    }

    @Override
    @Nullable
    public Entity getEntity(int p_104609_) {
        return this.getEntities().get(p_104609_);
    }

    @Override
    public void disconnect() {
        this.connection.getConnection().disconnect(Component.translatable("multiplayer.status.quitting"));
    }

    public void animateTick(int p_104785_, int p_104786_, int p_104787_) {
        int $$3 = 32;
        RandomSource $$4 = RandomSource.create();
        Block $$5 = this.getMarkerParticleTarget();
        BlockPos.MutableBlockPos $$6 = new BlockPos.MutableBlockPos();
        for (int $$7 = 0; $$7 < 667; ++$$7) {
            this.doAnimateTick(p_104785_, p_104786_, p_104787_, 16, $$4, $$5, $$6);
            this.doAnimateTick(p_104785_, p_104786_, p_104787_, 32, $$4, $$5, $$6);
        }
    }

    @Nullable
    private Block getMarkerParticleTarget() {
        ItemStack $$0;
        Item $$1;
        if (this.minecraft.gameMode.getPlayerMode() == GameType.CREATIVE && MARKER_PARTICLE_ITEMS.contains($$1 = ($$0 = this.minecraft.player.getMainHandItem()).getItem()) && $$1 instanceof BlockItem) {
            BlockItem $$2 = (BlockItem)$$1;
            return $$2.getBlock();
        }
        return null;
    }

    public void doAnimateTick(int p_233613_, int p_233614_, int p_233615_, int p_233616_, RandomSource p_233617_, @Nullable Block p_233618_, BlockPos.MutableBlockPos p_233619_) {
        int $$7 = p_233613_ + this.random.nextInt(p_233616_) - this.random.nextInt(p_233616_);
        int $$8 = p_233614_ + this.random.nextInt(p_233616_) - this.random.nextInt(p_233616_);
        int $$9 = p_233615_ + this.random.nextInt(p_233616_) - this.random.nextInt(p_233616_);
        p_233619_.set($$7, $$8, $$9);
        BlockState $$10 = this.getBlockState(p_233619_);
        $$10.getBlock().animateTick($$10, this, p_233619_, p_233617_);
        FluidState $$11 = this.getFluidState(p_233619_);
        if (!$$11.isEmpty()) {
            $$11.animateTick(this, p_233619_, p_233617_);
            ParticleOptions $$12 = $$11.getDripParticle();
            if ($$12 != null && this.random.nextInt(10) == 0) {
                boolean $$13 = $$10.isFaceSturdy(this, p_233619_, Direction.DOWN);
                Vec3i $$14 = p_233619_.below();
                this.trySpawnDripParticles((BlockPos)$$14, this.getBlockState((BlockPos)$$14), $$12, $$13);
            }
        }
        if (p_233618_ == $$10.getBlock()) {
            this.addParticle(new BlockParticleOption(ParticleTypes.BLOCK_MARKER, $$10), (double)$$7 + 0.5, (double)$$8 + 0.5, (double)$$9 + 0.5, 0.0, 0.0, 0.0);
        }
        if (!$$10.isCollisionShapeFullBlock(this, p_233619_)) {
            this.getBiome(p_233619_).value().getAmbientParticle().ifPresent(p_264703_ -> {
                if (p_264703_.canSpawn(this.random)) {
                    this.addParticle(p_264703_.getOptions(), (double)p_233619_.getX() + this.random.nextDouble(), (double)p_233619_.getY() + this.random.nextDouble(), (double)p_233619_.getZ() + this.random.nextDouble(), 0.0, 0.0, 0.0);
                }
            });
        }
    }

    private void trySpawnDripParticles(BlockPos p_104690_, BlockState p_104691_, ParticleOptions p_104692_, boolean p_104693_) {
        if (!p_104691_.getFluidState().isEmpty()) {
            return;
        }
        VoxelShape $$4 = p_104691_.getCollisionShape(this, p_104690_);
        double $$5 = $$4.max(Direction.Axis.Y);
        if ($$5 < 1.0) {
            if (p_104693_) {
                this.spawnFluidParticle(p_104690_.getX(), p_104690_.getX() + 1, p_104690_.getZ(), p_104690_.getZ() + 1, (double)(p_104690_.getY() + 1) - 0.05, p_104692_);
            }
        } else if (!p_104691_.is(BlockTags.IMPERMEABLE)) {
            double $$6 = $$4.min(Direction.Axis.Y);
            if ($$6 > 0.0) {
                this.spawnParticle(p_104690_, p_104692_, $$4, (double)p_104690_.getY() + $$6 - 0.05);
            } else {
                BlockPos $$7 = p_104690_.below();
                BlockState $$8 = this.getBlockState($$7);
                VoxelShape $$9 = $$8.getCollisionShape(this, $$7);
                double $$10 = $$9.max(Direction.Axis.Y);
                if ($$10 < 1.0 && $$8.getFluidState().isEmpty()) {
                    this.spawnParticle(p_104690_, p_104692_, $$4, (double)p_104690_.getY() - 0.05);
                }
            }
        }
    }

    private void spawnParticle(BlockPos p_104695_, ParticleOptions p_104696_, VoxelShape p_104697_, double p_104698_) {
        this.spawnFluidParticle((double)p_104695_.getX() + p_104697_.min(Direction.Axis.X), (double)p_104695_.getX() + p_104697_.max(Direction.Axis.X), (double)p_104695_.getZ() + p_104697_.min(Direction.Axis.Z), (double)p_104695_.getZ() + p_104697_.max(Direction.Axis.Z), p_104698_, p_104696_);
    }

    private void spawnFluidParticle(double p_104593_, double p_104594_, double p_104595_, double p_104596_, double p_104597_, ParticleOptions p_104598_) {
        this.addParticle(p_104598_, Mth.lerp(this.random.nextDouble(), p_104593_, p_104594_), p_104597_, Mth.lerp(this.random.nextDouble(), p_104595_, p_104596_), 0.0, 0.0, 0.0);
    }

    @Override
    public CrashReportCategory fillReportDetails(CrashReport p_104729_) {
        CrashReportCategory $$1 = super.fillReportDetails(p_104729_);
        $$1.setDetail("Server brand", () -> this.minecraft.player.connection.serverBrand());
        $$1.setDetail("Server type", () -> this.minecraft.getSingleplayerServer() == null ? "Non-integrated multiplayer server" : "Integrated singleplayer server");
        $$1.setDetail("Tracked entity count", () -> String.valueOf(this.getEntityCount()));
        return $$1;
    }

    @Override
    public void playSeededSound(@Nullable Player p_263381_, double p_263372_, double p_263404_, double p_263365_, Holder<SoundEvent> p_263335_, SoundSource p_263417_, float p_263416_, float p_263349_, long p_263408_) {
        if (p_263381_ == this.minecraft.player) {
            this.playSound(p_263372_, p_263404_, p_263365_, p_263335_.value(), p_263417_, p_263416_, p_263349_, false, p_263408_);
        }
    }

    @Override
    public void playSeededSound(@Nullable Player p_263514_, Entity p_263536_, Holder<SoundEvent> p_263518_, SoundSource p_263487_, float p_263538_, float p_263524_, long p_263509_) {
        if (p_263514_ == this.minecraft.player) {
            this.minecraft.getSoundManager().play(new EntityBoundSoundInstance(p_263518_.value(), p_263487_, p_263538_, p_263524_, p_263536_, p_263509_));
        }
    }

    @Override
    public void playLocalSound(Entity p_312749_, SoundEvent p_312635_, SoundSource p_312007_, float p_312298_, float p_312772_) {
        this.minecraft.getSoundManager().play(new EntityBoundSoundInstance(p_312635_, p_312007_, p_312298_, p_312772_, p_312749_, this.random.nextLong()));
    }

    @Override
    public void playLocalSound(double p_104600_, double p_104601_, double p_104602_, SoundEvent p_104603_, SoundSource p_104604_, float p_104605_, float p_104606_, boolean p_104607_) {
        this.playSound(p_104600_, p_104601_, p_104602_, p_104603_, p_104604_, p_104605_, p_104606_, p_104607_, this.random.nextLong());
    }

    private void playSound(double p_233603_, double p_233604_, double p_233605_, SoundEvent p_233606_, SoundSource p_233607_, float p_233608_, float p_233609_, boolean p_233610_, long p_233611_) {
        double $$9 = this.minecraft.gameRenderer.getMainCamera().getPosition().distanceToSqr(p_233603_, p_233604_, p_233605_);
        SimpleSoundInstance $$10 = new SimpleSoundInstance(p_233606_, p_233607_, p_233608_, p_233609_, RandomSource.create(p_233611_), p_233603_, p_233604_, p_233605_);
        if (p_233610_ && $$9 > 100.0) {
            double $$11 = Math.sqrt($$9) / 40.0;
            this.minecraft.getSoundManager().playDelayed($$10, (int)($$11 * 20.0));
        } else {
            this.minecraft.getSoundManager().play($$10);
        }
    }

    @Override
    public void createFireworks(double p_104585_, double p_104586_, double p_104587_, double p_104588_, double p_104589_, double p_104590_, List<FireworkExplosion> p_330281_) {
        if (p_330281_.isEmpty()) {
            for (int $$7 = 0; $$7 < this.random.nextInt(3) + 2; ++$$7) {
                this.addParticle(ParticleTypes.POOF, p_104585_, p_104586_, p_104587_, this.random.nextGaussian() * 0.05, 0.005, this.random.nextGaussian() * 0.05);
            }
        } else {
            this.minecraft.particleEngine.add(new FireworkParticles.Starter(this, p_104585_, p_104586_, p_104587_, p_104588_, p_104589_, p_104590_, this.minecraft.particleEngine, p_330281_));
        }
    }

    @Override
    public void sendPacketToServer(Packet<?> p_104734_) {
        this.connection.send(p_104734_);
    }

    @Override
    public RecipeManager getRecipeManager() {
        return this.connection.getRecipeManager();
    }

    @Override
    public TickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    @Override
    public LevelTickAccess<Block> getBlockTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    @Override
    public LevelTickAccess<Fluid> getFluidTicks() {
        return BlackholeTickAccess.emptyLevelList();
    }

    @Override
    public ClientChunkCache getChunkSource() {
        return this.chunkSource;
    }

    @Override
    @Nullable
    public MapItemSavedData getMapData(MapId p_323873_) {
        return this.mapData.get(p_323873_);
    }

    public void overrideMapData(MapId p_323577_, MapItemSavedData p_259308_) {
        this.mapData.put(p_323577_, p_259308_);
    }

    @Override
    public void setMapData(MapId p_324501_, MapItemSavedData p_171671_) {
    }

    @Override
    public MapId getFreeMapId() {
        return new MapId(0);
    }

    @Override
    public Scoreboard getScoreboard() {
        return this.connection.scoreboard();
    }

    @Override
    public void sendBlockUpdated(BlockPos p_104685_, BlockState p_104686_, BlockState p_104687_, int p_104688_) {
        this.levelRenderer.blockChanged(this, p_104685_, p_104686_, p_104687_, p_104688_);
    }

    @Override
    public void setBlocksDirty(BlockPos p_104759_, BlockState p_104760_, BlockState p_104761_) {
        this.levelRenderer.setBlockDirty(p_104759_, p_104760_, p_104761_);
    }

    public void setSectionDirtyWithNeighbors(int p_104794_, int p_104795_, int p_104796_) {
        this.levelRenderer.setSectionDirtyWithNeighbors(p_104794_, p_104795_, p_104796_);
    }

    @Override
    public void destroyBlockProgress(int p_104634_, BlockPos p_104635_, int p_104636_) {
        this.levelRenderer.destroyBlockProgress(p_104634_, p_104635_, p_104636_);
    }

    @Override
    public void globalLevelEvent(int p_104743_, BlockPos p_104744_, int p_104745_) {
        this.levelRenderer.globalLevelEvent(p_104743_, p_104744_, p_104745_);
    }

    @Override
    public void levelEvent(@Nullable Player p_104654_, int p_104655_, BlockPos p_104656_, int p_104657_) {
        try {
            this.levelRenderer.levelEvent(p_104655_, p_104656_, p_104657_);
        }
        catch (Throwable $$4) {
            CrashReport $$5 = CrashReport.forThrowable($$4, "Playing level event");
            CrashReportCategory $$6 = $$5.addCategory("Level event being played");
            $$6.setDetail("Block coordinates", CrashReportCategory.formatLocation(this, p_104656_));
            $$6.setDetail("Event source", p_104654_);
            $$6.setDetail("Event type", p_104655_);
            $$6.setDetail("Event data", p_104657_);
            throw new ReportedException($$5);
        }
    }

    @Override
    public void addParticle(ParticleOptions p_104706_, double p_104707_, double p_104708_, double p_104709_, double p_104710_, double p_104711_, double p_104712_) {
        this.levelRenderer.addParticle(p_104706_, p_104706_.getType().getOverrideLimiter(), p_104707_, p_104708_, p_104709_, p_104710_, p_104711_, p_104712_);
    }

    @Override
    public void addParticle(ParticleOptions p_104714_, boolean p_104715_, double p_104716_, double p_104717_, double p_104718_, double p_104719_, double p_104720_, double p_104721_) {
        this.levelRenderer.addParticle(p_104714_, p_104714_.getType().getOverrideLimiter() || p_104715_, p_104716_, p_104717_, p_104718_, p_104719_, p_104720_, p_104721_);
    }

    @Override
    public void addAlwaysVisibleParticle(ParticleOptions p_104766_, double p_104767_, double p_104768_, double p_104769_, double p_104770_, double p_104771_, double p_104772_) {
        this.levelRenderer.addParticle(p_104766_, false, true, p_104767_, p_104768_, p_104769_, p_104770_, p_104771_, p_104772_);
    }

    @Override
    public void addAlwaysVisibleParticle(ParticleOptions p_104774_, boolean p_104775_, double p_104776_, double p_104777_, double p_104778_, double p_104779_, double p_104780_, double p_104781_) {
        this.levelRenderer.addParticle(p_104774_, p_104774_.getType().getOverrideLimiter() || p_104775_, true, p_104776_, p_104777_, p_104778_, p_104779_, p_104780_, p_104781_);
    }

    public List<AbstractClientPlayer> players() {
        return this.players;
    }

    @Override
    public Holder<Biome> getUncachedNoiseBiome(int p_205516_, int p_205517_, int p_205518_) {
        return this.registryAccess().registryOrThrow(Registries.BIOME).getHolderOrThrow(Biomes.PLAINS);
    }

    public float getSkyDarken(float p_104806_) {
        float $$1 = this.getTimeOfDay(p_104806_);
        float $$2 = 1.0f - (Mth.cos($$1 * ((float)Math.PI * 2)) * 2.0f + 0.2f);
        $$2 = Mth.clamp($$2, 0.0f, 1.0f);
        $$2 = 1.0f - $$2;
        $$2 *= 1.0f - this.getRainLevel(p_104806_) * 5.0f / 16.0f;
        return ($$2 *= 1.0f - this.getThunderLevel(p_104806_) * 5.0f / 16.0f) * 0.8f + 0.2f;
    }

    public Vec3 getSkyColor(Vec3 p_171661_, float p_171662_) {
        int $$16;
        float $$13;
        float $$2 = this.getTimeOfDay(p_171662_);
        Vec3 $$3 = p_171661_.subtract(2.0, 2.0, 2.0).scale(0.25);
        BiomeManager $$4 = this.getBiomeManager();
        Vec3 $$5 = CubicSampler.gaussianSampleVec3($$3, (p_194161_, p_194162_, p_194163_) -> Vec3.fromRGB24($$4.getNoiseBiomeAtQuart(p_194161_, p_194162_, p_194163_).value().getSkyColor()));
        float $$6 = Mth.cos($$2 * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        $$6 = Mth.clamp($$6, 0.0f, 1.0f);
        float $$7 = (float)$$5.x * $$6;
        float $$8 = (float)$$5.y * $$6;
        float $$9 = (float)$$5.z * $$6;
        float $$10 = this.getRainLevel(p_171662_);
        if ($$10 > 0.0f) {
            float $$11 = ($$7 * 0.3f + $$8 * 0.59f + $$9 * 0.11f) * 0.6f;
            float $$12 = 1.0f - $$10 * 0.75f;
            $$7 = $$7 * $$12 + $$11 * (1.0f - $$12);
            $$8 = $$8 * $$12 + $$11 * (1.0f - $$12);
            $$9 = $$9 * $$12 + $$11 * (1.0f - $$12);
        }
        if (($$13 = this.getThunderLevel(p_171662_)) > 0.0f) {
            float $$14 = ($$7 * 0.3f + $$8 * 0.59f + $$9 * 0.11f) * 0.2f;
            float $$15 = 1.0f - $$13 * 0.75f;
            $$7 = $$7 * $$15 + $$14 * (1.0f - $$15);
            $$8 = $$8 * $$15 + $$14 * (1.0f - $$15);
            $$9 = $$9 * $$15 + $$14 * (1.0f - $$15);
        }
        if (($$16 = this.getSkyFlashTime()) > 0) {
            float $$17 = (float)$$16 - p_171662_;
            if ($$17 > 1.0f) {
                $$17 = 1.0f;
            }
            $$7 = $$7 * (1.0f - ($$17 *= 0.45f)) + 0.8f * $$17;
            $$8 = $$8 * (1.0f - $$17) + 0.8f * $$17;
            $$9 = $$9 * (1.0f - $$17) + 1.0f * $$17;
        }
        return new Vec3($$7, $$8, $$9);
    }

    public Vec3 getCloudColor(float p_104809_) {
        float $$1 = this.getTimeOfDay(p_104809_);
        float $$2 = Mth.cos($$1 * ((float)Math.PI * 2)) * 2.0f + 0.5f;
        $$2 = Mth.clamp($$2, 0.0f, 1.0f);
        float $$3 = 1.0f;
        float $$4 = 1.0f;
        float $$5 = 1.0f;
        float $$6 = this.getRainLevel(p_104809_);
        if ($$6 > 0.0f) {
            float $$7 = ($$3 * 0.3f + $$4 * 0.59f + $$5 * 0.11f) * 0.6f;
            float $$8 = 1.0f - $$6 * 0.95f;
            $$3 = $$3 * $$8 + $$7 * (1.0f - $$8);
            $$4 = $$4 * $$8 + $$7 * (1.0f - $$8);
            $$5 = $$5 * $$8 + $$7 * (1.0f - $$8);
        }
        $$3 *= $$2 * 0.9f + 0.1f;
        $$4 *= $$2 * 0.9f + 0.1f;
        $$5 *= $$2 * 0.85f + 0.15f;
        float $$9 = this.getThunderLevel(p_104809_);
        if ($$9 > 0.0f) {
            float $$10 = ($$3 * 0.3f + $$4 * 0.59f + $$5 * 0.11f) * 0.2f;
            float $$11 = 1.0f - $$9 * 0.95f;
            $$3 = $$3 * $$11 + $$10 * (1.0f - $$11);
            $$4 = $$4 * $$11 + $$10 * (1.0f - $$11);
            $$5 = $$5 * $$11 + $$10 * (1.0f - $$11);
        }
        return new Vec3($$3, $$4, $$5);
    }

    public float getStarBrightness(float p_104812_) {
        float $$1 = this.getTimeOfDay(p_104812_);
        float $$2 = 1.0f - (Mth.cos($$1 * ((float)Math.PI * 2)) * 2.0f + 0.25f);
        $$2 = Mth.clamp($$2, 0.0f, 1.0f);
        return $$2 * $$2 * 0.5f;
    }

    public int getSkyFlashTime() {
        return this.minecraft.options.hideLightningFlash().get() != false ? 0 : this.skyFlashTime;
    }

    @Override
    public void setSkyFlashTime(int p_104783_) {
        this.skyFlashTime = p_104783_;
    }

    @Override
    public float getShade(Direction p_104703_, boolean p_104704_) {
        boolean $$2 = this.effects().constantAmbientLight();
        if (!p_104704_) {
            return $$2 ? 0.9f : 1.0f;
        }
        switch (p_104703_) {
            case DOWN: {
                return $$2 ? 0.9f : 0.5f;
            }
            case UP: {
                return $$2 ? 0.9f : 1.0f;
            }
            case NORTH: 
            case SOUTH: {
                return 0.8f;
            }
            case WEST: 
            case EAST: {
                return 0.6f;
            }
        }
        return 1.0f;
    }

    @Override
    public int getBlockTint(BlockPos p_104700_, ColorResolver p_104701_) {
        BlockTintCache $$2 = (BlockTintCache)this.tintCaches.get((Object)p_104701_);
        return $$2.getColor(p_104700_);
    }

    public int calculateBlockTint(BlockPos p_104763_, ColorResolver p_104764_) {
        int $$2 = Minecraft.getInstance().options.biomeBlendRadius().get();
        if ($$2 == 0) {
            return p_104764_.getColor(this.getBiome(p_104763_).value(), p_104763_.getX(), p_104763_.getZ());
        }
        int $$3 = ($$2 * 2 + 1) * ($$2 * 2 + 1);
        int $$4 = 0;
        int $$5 = 0;
        int $$6 = 0;
        Cursor3D $$7 = new Cursor3D(p_104763_.getX() - $$2, p_104763_.getY(), p_104763_.getZ() - $$2, p_104763_.getX() + $$2, p_104763_.getY(), p_104763_.getZ() + $$2);
        BlockPos.MutableBlockPos $$8 = new BlockPos.MutableBlockPos();
        while ($$7.advance()) {
            $$8.set($$7.nextX(), $$7.nextY(), $$7.nextZ());
            int $$9 = p_104764_.getColor(this.getBiome($$8).value(), $$8.getX(), $$8.getZ());
            $$4 += ($$9 & 0xFF0000) >> 16;
            $$5 += ($$9 & 0xFF00) >> 8;
            $$6 += $$9 & 0xFF;
        }
        return ($$4 / $$3 & 0xFF) << 16 | ($$5 / $$3 & 0xFF) << 8 | $$6 / $$3 & 0xFF;
    }

    public void setDefaultSpawnPos(BlockPos p_104753_, float p_104754_) {
        this.levelData.setSpawn(p_104753_, p_104754_);
    }

    public String toString() {
        return "ClientLevel";
    }

    @Override
    public ClientLevelData getLevelData() {
        return this.clientLevelData;
    }

    @Override
    public void gameEvent(Holder<GameEvent> p_316478_, Vec3 p_233640_, GameEvent.Context p_233641_) {
    }

    protected Map<MapId, MapItemSavedData> getAllMapData() {
        return ImmutableMap.copyOf(this.mapData);
    }

    protected void addMapData(Map<MapId, MapItemSavedData> p_171673_) {
        this.mapData.putAll(p_171673_);
    }

    @Override
    protected LevelEntityGetter<Entity> getEntities() {
        return this.entityStorage.getEntityGetter();
    }

    @Override
    public String gatherChunkSourceStats() {
        return "Chunks[C] W: " + this.chunkSource.gatherStats() + " E: " + this.entityStorage.gatherStats();
    }

    @Override
    public void addDestroyBlockEffect(BlockPos p_171667_, BlockState p_171668_) {
        this.minecraft.particleEngine.destroy(p_171667_, p_171668_);
    }

    public void setServerSimulationDistance(int p_194175_) {
        this.serverSimulationDistance = p_194175_;
    }

    public int getServerSimulationDistance() {
        return this.serverSimulationDistance;
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.connection.enabledFeatures();
    }

    @Override
    public PotionBrewing potionBrewing() {
        return this.connection.potionBrewing();
    }

    @Override
    public /* synthetic */ LevelData getLevelData() {
        return this.getLevelData();
    }

    @Override
    public /* synthetic */ ChunkSource getChunkSource() {
        return this.getChunkSource();
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        @Override
        public void onCreated(Entity p_171696_) {
        }

        @Override
        public void onDestroyed(Entity p_171700_) {
        }

        @Override
        public void onTickingStart(Entity p_171704_) {
            ClientLevel.this.tickingEntities.add(p_171704_);
        }

        @Override
        public void onTickingEnd(Entity p_171708_) {
            ClientLevel.this.tickingEntities.remove(p_171708_);
        }

        @Override
        public void onTrackingStart(Entity p_171712_) {
            if (p_171712_ instanceof AbstractClientPlayer) {
                ClientLevel.this.players.add((AbstractClientPlayer)p_171712_);
            }
        }

        @Override
        public void onTrackingEnd(Entity p_171716_) {
            p_171716_.unRide();
            ClientLevel.this.players.remove(p_171716_);
        }

        @Override
        public void onSectionChange(Entity p_233660_) {
        }

        @Override
        public /* synthetic */ void onSectionChange(Object object) {
            this.onSectionChange((Entity)object);
        }

        @Override
        public /* synthetic */ void onTrackingEnd(Object object) {
            this.onTrackingEnd((Entity)object);
        }

        @Override
        public /* synthetic */ void onTrackingStart(Object object) {
            this.onTrackingStart((Entity)object);
        }

        @Override
        public /* synthetic */ void onTickingStart(Object object) {
            this.onTickingStart((Entity)object);
        }

        @Override
        public /* synthetic */ void onDestroyed(Object object) {
            this.onDestroyed((Entity)object);
        }

        @Override
        public /* synthetic */ void onCreated(Object object) {
            this.onCreated((Entity)object);
        }
    }

    public static class ClientLevelData
    implements WritableLevelData {
        private final boolean hardcore;
        private final GameRules gameRules;
        private final boolean isFlat;
        private BlockPos spawnPos;
        private float spawnAngle;
        private long gameTime;
        private long dayTime;
        private boolean raining;
        private Difficulty difficulty;
        private boolean difficultyLocked;

        public ClientLevelData(Difficulty p_104843_, boolean p_104844_, boolean p_104845_) {
            this.difficulty = p_104843_;
            this.hardcore = p_104844_;
            this.isFlat = p_104845_;
            this.gameRules = new GameRules();
        }

        @Override
        public BlockPos getSpawnPos() {
            return this.spawnPos;
        }

        @Override
        public float getSpawnAngle() {
            return this.spawnAngle;
        }

        @Override
        public long getGameTime() {
            return this.gameTime;
        }

        @Override
        public long getDayTime() {
            return this.dayTime;
        }

        public void setGameTime(long p_104850_) {
            this.gameTime = p_104850_;
        }

        public void setDayTime(long p_104864_) {
            this.dayTime = p_104864_;
        }

        @Override
        public void setSpawn(BlockPos p_104854_, float p_104855_) {
            this.spawnPos = p_104854_.immutable();
            this.spawnAngle = p_104855_;
        }

        @Override
        public boolean isThundering() {
            return false;
        }

        @Override
        public boolean isRaining() {
            return this.raining;
        }

        @Override
        public void setRaining(boolean p_104866_) {
            this.raining = p_104866_;
        }

        @Override
        public boolean isHardcore() {
            return this.hardcore;
        }

        @Override
        public GameRules getGameRules() {
            return this.gameRules;
        }

        @Override
        public Difficulty getDifficulty() {
            return this.difficulty;
        }

        @Override
        public boolean isDifficultyLocked() {
            return this.difficultyLocked;
        }

        @Override
        public void fillCrashReportCategory(CrashReportCategory p_171690_, LevelHeightAccessor p_171691_) {
            WritableLevelData.super.fillCrashReportCategory(p_171690_, p_171691_);
        }

        public void setDifficulty(Difficulty p_104852_) {
            this.difficulty = p_104852_;
        }

        public void setDifficultyLocked(boolean p_104859_) {
            this.difficultyLocked = p_104859_;
        }

        public double getHorizonHeight(LevelHeightAccessor p_171688_) {
            if (this.isFlat) {
                return p_171688_.getMinBuildHeight();
            }
            return 63.0;
        }

        public float getClearColorScale() {
            if (this.isFlat) {
                return 1.0f;
            }
            return 0.03125f;
        }
    }
}

