/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.ClientRecipeBook;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.searchtree.FullTextSearchTree;
import net.minecraft.client.searchtree.IdSearchTree;
import net.minecraft.client.searchtree.SearchTree;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class SessionSearchTrees {
    private static final Key RECIPE_COLLECTIONS = new Key();
    private static final Key CREATIVE_NAMES = new Key();
    private static final Key CREATIVE_TAGS = new Key();
    private CompletableFuture<SearchTree<ItemStack>> creativeByNameSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private CompletableFuture<SearchTree<ItemStack>> creativeByTagSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private CompletableFuture<SearchTree<RecipeCollection>> recipeSearch = CompletableFuture.completedFuture(SearchTree.empty());
    private final Map<Key, Runnable> reloaders = new IdentityHashMap<Key, Runnable>();

    private void register(Key p_345458_, Runnable p_346175_) {
        p_346175_.run();
        this.reloaders.put(p_345458_, p_346175_);
    }

    public void rebuildAfterLanguageChange() {
        for (Runnable $$0 : this.reloaders.values()) {
            $$0.run();
        }
    }

    private static Stream<String> getTooltipLines(Stream<ItemStack> p_344879_, Item.TooltipContext p_345662_, TooltipFlag p_345262_) {
        return p_344879_.flatMap(p_344980_ -> p_344980_.getTooltipLines(p_345662_, null, p_345262_).stream()).map(p_345615_ -> ChatFormatting.stripFormatting(p_345615_.getString()).trim()).filter(p_346341_ -> !p_346341_.isEmpty());
    }

    public void updateRecipes(ClientRecipeBook p_346233_, RegistryAccess.Frozen p_345600_) {
        this.register(RECIPE_COLLECTIONS, () -> {
            List<RecipeCollection> $$2 = p_346233_.getCollections();
            Registry<Item> $$3 = p_345600_.registryOrThrow(Registries.ITEM);
            Item.TooltipContext $$4 = Item.TooltipContext.of(p_345600_);
            TooltipFlag.Default $$5 = TooltipFlag.Default.NORMAL;
            CompletableFuture<SearchTree<RecipeCollection>> $$6 = this.recipeSearch;
            this.recipeSearch = CompletableFuture.supplyAsync(() -> new FullTextSearchTree<RecipeCollection>(p_346411_ -> SessionSearchTrees.getTooltipLines(p_346411_.getRecipes().stream().map(p_345321_ -> p_345321_.value().getResultItem(p_345600_)), $$4, $$5), p_345180_ -> p_345180_.getRecipes().stream().map(p_346084_ -> $$3.getKey(p_346084_.value().getResultItem(p_345600_).getItem())), $$2), Util.backgroundExecutor());
            $$6.cancel(true);
        });
    }

    public SearchTree<RecipeCollection> recipes() {
        return this.recipeSearch.join();
    }

    public void updateCreativeTags(List<ItemStack> p_346121_) {
        this.register(CREATIVE_TAGS, () -> {
            CompletableFuture<SearchTree<ItemStack>> $$1 = this.creativeByTagSearch;
            this.creativeByTagSearch = CompletableFuture.supplyAsync(() -> new IdSearchTree<ItemStack>(p_344728_ -> p_344728_.getTags().map(TagKey::location), p_346121_), Util.backgroundExecutor());
            $$1.cancel(true);
        });
    }

    public SearchTree<ItemStack> creativeTagSearch() {
        return this.creativeByTagSearch.join();
    }

    public void updateCreativeTooltips(HolderLookup.Provider p_345391_, List<ItemStack> p_346357_) {
        this.register(CREATIVE_NAMES, () -> {
            Item.TooltipContext $$2 = Item.TooltipContext.of(p_345391_);
            TooltipFlag.Default $$3 = TooltipFlag.Default.NORMAL.asCreative();
            CompletableFuture<SearchTree<ItemStack>> $$4 = this.creativeByNameSearch;
            this.creativeByNameSearch = CompletableFuture.supplyAsync(() -> new FullTextSearchTree<ItemStack>(p_345006_ -> SessionSearchTrees.getTooltipLines(Stream.of(p_345006_), $$2, $$3), p_345861_ -> p_345861_.getItemHolder().unwrapKey().map(ResourceKey::location).stream(), p_346357_), Util.backgroundExecutor());
            $$4.cancel(true);
        });
    }

    public SearchTree<ItemStack> creativeNameSearch() {
        return this.creativeByNameSearch.join();
    }

    static class Key {
        Key() {
        }
    }
}

