/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.chat.report;

import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.UserApiService;
import com.mojang.authlib.minecraft.report.AbuseReport;
import com.mojang.authlib.minecraft.report.AbuseReportLimits;
import com.mojang.authlib.yggdrasil.request.AbuseReportRequest;
import com.mojang.datafixers.util.Unit;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.chat.report.ReportEnvironment;
import net.minecraft.client.multiplayer.chat.report.ReportType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ThrowingComponent;

public interface AbuseReportSender {
    public static AbuseReportSender create(ReportEnvironment p_239536_, UserApiService p_239537_) {
        return new Services(p_239536_, p_239537_);
    }

    public CompletableFuture<Unit> send(UUID var1, ReportType var2, AbuseReport var3);

    public boolean isEnabled();

    default public AbuseReportLimits reportLimits() {
        return AbuseReportLimits.DEFAULTS;
    }

    public record Services(ReportEnvironment environment, UserApiService userApiService) implements AbuseReportSender
    {
        private static final Component SERVICE_UNAVAILABLE_TEXT = Component.translatable("gui.abuseReport.send.service_unavailable");
        private static final Component HTTP_ERROR_TEXT = Component.translatable("gui.abuseReport.send.http_error");
        private static final Component JSON_ERROR_TEXT = Component.translatable("gui.abuseReport.send.json_error");

        @Override
        public CompletableFuture<Unit> send(UUID p_239470_, ReportType p_299858_, AbuseReport p_239471_) {
            return CompletableFuture.supplyAsync(() -> {
                AbuseReportRequest $$3 = new AbuseReportRequest(1, p_239470_, p_239471_, this.environment.clientInfo(), this.environment.thirdPartyServerInfo(), this.environment.realmInfo(), p_299858_.backendName());
                try {
                    this.userApiService.reportAbuse($$3);
                    return Unit.INSTANCE;
                }
                catch (MinecraftClientHttpException $$4) {
                    Component $$5 = this.getHttpErrorDescription($$4);
                    throw new CompletionException(new SendException($$5, (Throwable)$$4));
                }
                catch (MinecraftClientException $$6) {
                    Component $$7 = this.getErrorDescription($$6);
                    throw new CompletionException(new SendException($$7, (Throwable)$$6));
                }
            }, Util.ioPool());
        }

        @Override
        public boolean isEnabled() {
            return this.userApiService.canSendReports();
        }

        private Component getHttpErrorDescription(MinecraftClientHttpException p_239705_) {
            return Component.translatable("gui.abuseReport.send.error_message", p_239705_.getMessage());
        }

        private Component getErrorDescription(MinecraftClientException p_240068_) {
            return switch (p_240068_.getType()) {
                default -> throw new MatchException(null, null);
                case MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE -> SERVICE_UNAVAILABLE_TEXT;
                case MinecraftClientException.ErrorType.HTTP_ERROR -> HTTP_ERROR_TEXT;
                case MinecraftClientException.ErrorType.JSON_ERROR -> JSON_ERROR_TEXT;
            };
        }

        @Override
        public AbuseReportLimits reportLimits() {
            return this.userApiService.getAbuseReportLimits();
        }
    }

    public static class SendException
    extends ThrowingComponent {
        public SendException(Component p_239646_, Throwable p_239647_) {
            super(p_239646_, p_239647_);
        }
    }
}

