/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.mojang.authlib.GameProfile;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractClientPlayer
extends Player {
    @Nullable
    private PlayerInfo playerInfo;
    protected Vec3 deltaMovementOnPreviousTick = Vec3.ZERO;
    public float elytraRotX;
    public float elytraRotY;
    public float elytraRotZ;
    public final ClientLevel clientLevel;

    public AbstractClientPlayer(ClientLevel p_250460_, GameProfile p_249912_) {
        super(p_250460_, p_250460_.getSharedSpawnPos(), p_250460_.getSharedSpawnAngle(), p_249912_);
        this.clientLevel = p_250460_;
    }

    @Override
    public boolean isSpectator() {
        PlayerInfo $$0 = this.getPlayerInfo();
        return $$0 != null && $$0.getGameMode() == GameType.SPECTATOR;
    }

    @Override
    public boolean isCreative() {
        PlayerInfo $$0 = this.getPlayerInfo();
        return $$0 != null && $$0.getGameMode() == GameType.CREATIVE;
    }

    @Nullable
    protected PlayerInfo getPlayerInfo() {
        if (this.playerInfo == null) {
            this.playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(this.getUUID());
        }
        return this.playerInfo;
    }

    @Override
    public void tick() {
        this.deltaMovementOnPreviousTick = this.getDeltaMovement();
        super.tick();
    }

    public Vec3 getDeltaMovementLerped(float p_272943_) {
        return this.deltaMovementOnPreviousTick.lerp(this.getDeltaMovement(), p_272943_);
    }

    public PlayerSkin getSkin() {
        PlayerInfo $$0 = this.getPlayerInfo();
        return $$0 == null ? DefaultPlayerSkin.get(this.getUUID()) : $$0.getSkin();
    }

    public float getFieldOfViewModifier() {
        float $$0 = 1.0f;
        if (this.getAbilities().flying) {
            $$0 *= 1.1f;
        }
        if (this.getAbilities().getWalkingSpeed() == 0.0f || Float.isNaN($$0 *= ((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED) / this.getAbilities().getWalkingSpeed() + 1.0f) / 2.0f) || Float.isInfinite($$0)) {
            $$0 = 1.0f;
        }
        ItemStack $$1 = this.getUseItem();
        if (this.isUsingItem()) {
            if ($$1.is(Items.BOW)) {
                int $$2 = this.getTicksUsingItem();
                float $$3 = (float)$$2 / 20.0f;
                $$3 = $$3 > 1.0f ? 1.0f : ($$3 *= $$3);
                $$0 *= 1.0f - $$3 * 0.15f;
            } else if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && this.isScoping()) {
                return 0.1f;
            }
        }
        return Mth.lerp(Minecraft.getInstance().options.fovEffectScale().get().floatValue(), 1.0f, $$0);
    }
}

