/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.blockentity;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;

public class HangingSignRenderer
extends SignRenderer {
    private static final String PLANK = "plank";
    private static final String V_CHAINS = "vChains";
    private static final String NORMAL_CHAINS = "normalChains";
    private static final String CHAIN_L_1 = "chainL1";
    private static final String CHAIN_L_2 = "chainL2";
    private static final String CHAIN_R_1 = "chainR1";
    private static final String CHAIN_R_2 = "chainR2";
    private static final String BOARD = "board";
    private static final float MODEL_RENDER_SCALE = 1.0f;
    private static final float TEXT_RENDER_SCALE = 0.9f;
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, -0.32f, 0.073f);
    private final Map<WoodType, HangingSignModel> hangingSignModels = (Map)WoodType.values().collect(ImmutableMap.toImmutableMap(p_249901_ -> p_249901_, p_251956_ -> new HangingSignModel(p_248772_.bakeLayer(ModelLayers.createHangingSignModelName(p_251956_)))));

    public HangingSignRenderer(BlockEntityRendererProvider.Context p_248772_) {
        super(p_248772_);
    }

    @Override
    public float getSignModelRenderScale() {
        return 1.0f;
    }

    @Override
    public float getSignTextRenderScale() {
        return 0.9f;
    }

    @Override
    public void render(SignBlockEntity p_249482_, float p_249273_, PoseStack p_250062_, MultiBufferSource p_250878_, int p_249035_, int p_252030_) {
        BlockState $$6 = p_249482_.getBlockState();
        SignBlock $$7 = (SignBlock)$$6.getBlock();
        WoodType $$8 = SignBlock.getWoodType($$7);
        HangingSignModel $$9 = this.hangingSignModels.get($$8);
        $$9.evaluateVisibleParts($$6);
        this.renderSignWithText(p_249482_, p_250062_, p_250878_, p_249035_, p_252030_, $$6, $$7, $$8, $$9);
    }

    @Override
    void translateSign(PoseStack p_277807_, float p_277917_, BlockState p_277638_) {
        p_277807_.translate(0.5, 0.9375, 0.5);
        p_277807_.mulPose(Axis.YP.rotationDegrees(p_277917_));
        p_277807_.translate(0.0f, -0.3125f, 0.0f);
    }

    @Override
    void renderSignModel(PoseStack p_251159_, int p_249874_, int p_249794_, Model p_248746_, VertexConsumer p_249165_) {
        HangingSignModel $$5 = (HangingSignModel)p_248746_;
        $$5.root.render(p_251159_, p_249165_, p_249874_, p_249794_);
    }

    @Override
    Material getSignMaterial(WoodType p_251791_) {
        return Sheets.getHangingSignMaterial(p_251791_);
    }

    @Override
    Vec3 getTextOffset() {
        return TEXT_OFFSET;
    }

    public static LayerDefinition createHangingSignLayer() {
        MeshDefinition $$0 = new MeshDefinition();
        PartDefinition $$1 = $$0.getRoot();
        $$1.addOrReplaceChild(BOARD, CubeListBuilder.create().texOffs(0, 12).addBox(-7.0f, 0.0f, -1.0f, 14.0f, 10.0f, 2.0f), PartPose.ZERO);
        $$1.addOrReplaceChild(PLANK, CubeListBuilder.create().texOffs(0, 0).addBox(-8.0f, -6.0f, -2.0f, 16.0f, 2.0f, 4.0f), PartPose.ZERO);
        PartDefinition $$2 = $$1.addOrReplaceChild(NORMAL_CHAINS, CubeListBuilder.create(), PartPose.ZERO);
        $$2.addOrReplaceChild(CHAIN_L_1, CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(-5.0f, -6.0f, 0.0f, 0.0f, -0.7853982f, 0.0f));
        $$2.addOrReplaceChild(CHAIN_L_2, CubeListBuilder.create().texOffs(6, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(-5.0f, -6.0f, 0.0f, 0.0f, 0.7853982f, 0.0f));
        $$2.addOrReplaceChild(CHAIN_R_1, CubeListBuilder.create().texOffs(0, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(5.0f, -6.0f, 0.0f, 0.0f, -0.7853982f, 0.0f));
        $$2.addOrReplaceChild(CHAIN_R_2, CubeListBuilder.create().texOffs(6, 6).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 6.0f, 0.0f), PartPose.offsetAndRotation(5.0f, -6.0f, 0.0f, 0.0f, 0.7853982f, 0.0f));
        $$1.addOrReplaceChild(V_CHAINS, CubeListBuilder.create().texOffs(14, 6).addBox(-6.0f, -6.0f, 0.0f, 12.0f, 6.0f, 0.0f), PartPose.ZERO);
        return LayerDefinition.create($$0, 64, 32);
    }

    public static final class HangingSignModel
    extends Model {
        public final ModelPart root;
        public final ModelPart plank;
        public final ModelPart vChains;
        public final ModelPart normalChains;

        public HangingSignModel(ModelPart p_249124_) {
            super(RenderType::entityCutoutNoCull);
            this.root = p_249124_;
            this.plank = p_249124_.getChild(HangingSignRenderer.PLANK);
            this.normalChains = p_249124_.getChild(HangingSignRenderer.NORMAL_CHAINS);
            this.vChains = p_249124_.getChild(HangingSignRenderer.V_CHAINS);
        }

        public void evaluateVisibleParts(BlockState p_250268_) {
            boolean $$1;
            this.plank.visible = $$1 = !(p_250268_.getBlock() instanceof CeilingHangingSignBlock);
            this.vChains.visible = false;
            this.normalChains.visible = true;
            if (!$$1) {
                boolean $$2 = p_250268_.getValue(BlockStateProperties.ATTACHED);
                this.normalChains.visible = !$$2;
                this.vChains.visible = $$2;
            }
        }

        @Override
        public void renderToBuffer(PoseStack p_251590_, VertexConsumer p_249470_, int p_250912_, int p_251773_, int p_350547_) {
            this.root.render(p_251590_, p_249470_, p_250912_, p_251773_, p_350547_);
        }
    }
}

