/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sounds;

import java.io.BufferedInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.sounds.AudioStream;

public class LoopingAudioStream
implements AudioStream {
    private final AudioStreamProvider provider;
    private AudioStream stream;
    private final BufferedInputStream bufferedInputStream;

    public LoopingAudioStream(AudioStreamProvider p_120163_, InputStream p_120164_) throws IOException {
        this.provider = p_120163_;
        this.bufferedInputStream = new BufferedInputStream(p_120164_);
        this.bufferedInputStream.mark(Integer.MAX_VALUE);
        this.stream = p_120163_.create(new NoCloseBuffer(this.bufferedInputStream));
    }

    @Override
    public AudioFormat getFormat() {
        return this.stream.getFormat();
    }

    @Override
    public ByteBuffer read(int p_120167_) throws IOException {
        ByteBuffer $$1 = this.stream.read(p_120167_);
        if (!$$1.hasRemaining()) {
            this.stream.close();
            this.bufferedInputStream.reset();
            this.stream = this.provider.create(new NoCloseBuffer(this.bufferedInputStream));
            $$1 = this.stream.read(p_120167_);
        }
        return $$1;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.bufferedInputStream.close();
    }

    @FunctionalInterface
    public static interface AudioStreamProvider {
        public AudioStream create(InputStream var1) throws IOException;
    }

    static class NoCloseBuffer
    extends FilterInputStream {
        NoCloseBuffer(InputStream p_120172_) {
            super(p_120172_);
        }

        @Override
        public void close() {
        }
    }
}

