/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.ServerGamePacketListener;

public abstract class ServerboundMovePlayerPacket
implements Packet<ServerGamePacketListener> {
    protected final double x;
    protected final double y;
    protected final double z;
    protected final float yRot;
    protected final float xRot;
    protected final boolean onGround;
    protected final boolean hasPos;
    protected final boolean hasRot;

    protected ServerboundMovePlayerPacket(double p_179675_, double p_179676_, double p_179677_, float p_179678_, float p_179679_, boolean p_179680_, boolean p_179681_, boolean p_179682_) {
        this.x = p_179675_;
        this.y = p_179676_;
        this.z = p_179677_;
        this.yRot = p_179678_;
        this.xRot = p_179679_;
        this.onGround = p_179680_;
        this.hasPos = p_179681_;
        this.hasRot = p_179682_;
    }

    @Override
    public abstract PacketType<? extends ServerboundMovePlayerPacket> type();

    @Override
    public void handle(ServerGamePacketListener p_134138_) {
        p_134138_.handleMovePlayer(this);
    }

    public double getX(double p_134130_) {
        return this.hasPos ? this.x : p_134130_;
    }

    public double getY(double p_134141_) {
        return this.hasPos ? this.y : p_134141_;
    }

    public double getZ(double p_134147_) {
        return this.hasPos ? this.z : p_134147_;
    }

    public float getYRot(float p_134132_) {
        return this.hasRot ? this.yRot : p_134132_;
    }

    public float getXRot(float p_134143_) {
        return this.hasRot ? this.xRot : p_134143_;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public boolean hasPosition() {
        return this.hasPos;
    }

    public boolean hasRotation() {
        return this.hasRot;
    }

    public static class StatusOnly
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, StatusOnly> STREAM_CODEC = Packet.codec(StatusOnly::write, StatusOnly::read);

        public StatusOnly(boolean p_179692_) {
            super(0.0, 0.0, 0.0, 0.0f, 0.0f, p_179692_, false, false);
        }

        private static StatusOnly read(FriendlyByteBuf p_179698_) {
            boolean $$1 = p_179698_.readUnsignedByte() != 0;
            return new StatusOnly($$1);
        }

        private void write(FriendlyByteBuf p_179694_) {
            p_179694_.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<StatusOnly> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_STATUS_ONLY;
        }
    }

    public static class Rot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Rot> STREAM_CODEC = Packet.codec(Rot::write, Rot::read);

        public Rot(float p_134176_, float p_134177_, boolean p_134178_) {
            super(0.0, 0.0, 0.0, p_134176_, p_134177_, p_134178_, false, true);
        }

        private static Rot read(FriendlyByteBuf p_179690_) {
            float $$1 = p_179690_.readFloat();
            float $$2 = p_179690_.readFloat();
            boolean $$3 = p_179690_.readUnsignedByte() != 0;
            return new Rot($$1, $$2, $$3);
        }

        private void write(FriendlyByteBuf p_134184_) {
            p_134184_.writeFloat(this.yRot);
            p_134184_.writeFloat(this.xRot);
            p_134184_.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<Rot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_ROT;
        }
    }

    public static class Pos
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, Pos> STREAM_CODEC = Packet.codec(Pos::write, Pos::read);

        public Pos(double p_134150_, double p_134151_, double p_134152_, boolean p_134153_) {
            super(p_134150_, p_134151_, p_134152_, 0.0f, 0.0f, p_134153_, true, false);
        }

        private static Pos read(FriendlyByteBuf p_179686_) {
            double $$1 = p_179686_.readDouble();
            double $$2 = p_179686_.readDouble();
            double $$3 = p_179686_.readDouble();
            boolean $$4 = p_179686_.readUnsignedByte() != 0;
            return new Pos($$1, $$2, $$3, $$4);
        }

        private void write(FriendlyByteBuf p_134159_) {
            p_134159_.writeDouble(this.x);
            p_134159_.writeDouble(this.y);
            p_134159_.writeDouble(this.z);
            p_134159_.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<Pos> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS;
        }
    }

    public static class PosRot
    extends ServerboundMovePlayerPacket {
        public static final StreamCodec<FriendlyByteBuf, PosRot> STREAM_CODEC = Packet.codec(PosRot::write, PosRot::read);

        public PosRot(double p_134162_, double p_134163_, double p_134164_, float p_134165_, float p_134166_, boolean p_134167_) {
            super(p_134162_, p_134163_, p_134164_, p_134165_, p_134166_, p_134167_, true, true);
        }

        private static PosRot read(FriendlyByteBuf p_179688_) {
            double $$1 = p_179688_.readDouble();
            double $$2 = p_179688_.readDouble();
            double $$3 = p_179688_.readDouble();
            float $$4 = p_179688_.readFloat();
            float $$5 = p_179688_.readFloat();
            boolean $$6 = p_179688_.readUnsignedByte() != 0;
            return new PosRot($$1, $$2, $$3, $$4, $$5, $$6);
        }

        private void write(FriendlyByteBuf p_134173_) {
            p_134173_.writeDouble(this.x);
            p_134173_.writeDouble(this.y);
            p_134173_.writeDouble(this.z);
            p_134173_.writeFloat(this.yRot);
            p_134173_.writeFloat(this.xRot);
            p_134173_.writeByte(this.onGround ? 1 : 0);
        }

        @Override
        public PacketType<PosRot> type() {
            return GamePacketTypes.SERVERBOUND_MOVE_PLAYER_POS_ROT;
        }
    }
}

