/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.FallbackResourceManager;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceFilterSection;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class MultiPackResourceManager
implements CloseableResourceManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, FallbackResourceManager> namespacedManagers;
    private final List<PackResources> packs;

    public MultiPackResourceManager(PackType p_203797_, List<PackResources> p_203798_) {
        this.packs = List.copyOf(p_203798_);
        HashMap<String, FallbackResourceManager> $$2 = new HashMap<String, FallbackResourceManager>();
        List $$3 = p_203798_.stream().flatMap(p_215471_ -> p_215471_.getNamespaces(p_203797_).stream()).distinct().toList();
        for (PackResources $$4 : p_203798_) {
            ResourceFilterSection $$5 = this.getPackFilterSection($$4);
            Set<String> $$6 = $$4.getNamespaces(p_203797_);
            Predicate<ResourceLocation> $$7 = $$5 != null ? p_215474_ -> $$5.isPathFiltered(p_215474_.getPath()) : null;
            for (String $$8 : $$3) {
                boolean $$10;
                boolean $$9 = $$6.contains($$8);
                boolean bl = $$10 = $$5 != null && $$5.isNamespaceFiltered($$8);
                if (!$$9 && !$$10) continue;
                FallbackResourceManager $$11 = (FallbackResourceManager)$$2.get($$8);
                if ($$11 == null) {
                    $$11 = new FallbackResourceManager(p_203797_, $$8);
                    $$2.put($$8, $$11);
                }
                if ($$9 && $$10) {
                    $$11.push($$4, $$7);
                    continue;
                }
                if ($$9) {
                    $$11.push($$4);
                    continue;
                }
                $$11.pushFilterOnly($$4.packId(), $$7);
            }
        }
        this.namespacedManagers = $$2;
    }

    @Nullable
    private ResourceFilterSection getPackFilterSection(PackResources p_215468_) {
        try {
            return p_215468_.getMetadataSection(ResourceFilterSection.TYPE);
        }
        catch (IOException $$1) {
            LOGGER.error("Failed to get filter section from pack {}", (Object)p_215468_.packId());
            return null;
        }
    }

    @Override
    public Set<String> getNamespaces() {
        return this.namespacedManagers.keySet();
    }

    @Override
    public Optional<Resource> getResource(ResourceLocation p_215482_) {
        ResourceManager $$1 = this.namespacedManagers.get(p_215482_.getNamespace());
        if ($$1 != null) {
            return $$1.getResource(p_215482_);
        }
        return Optional.empty();
    }

    @Override
    public List<Resource> getResourceStack(ResourceLocation p_215466_) {
        ResourceManager $$1 = this.namespacedManagers.get(p_215466_.getNamespace());
        if ($$1 != null) {
            return $$1.getResourceStack(p_215466_);
        }
        return List.of();
    }

    @Override
    public Map<ResourceLocation, Resource> listResources(String p_215476_, Predicate<ResourceLocation> p_215477_) {
        MultiPackResourceManager.checkTrailingDirectoryPath(p_215476_);
        TreeMap<ResourceLocation, Resource> $$2 = new TreeMap<ResourceLocation, Resource>();
        for (FallbackResourceManager $$3 : this.namespacedManagers.values()) {
            $$2.putAll($$3.listResources(p_215476_, p_215477_));
        }
        return $$2;
    }

    @Override
    public Map<ResourceLocation, List<Resource>> listResourceStacks(String p_215479_, Predicate<ResourceLocation> p_215480_) {
        MultiPackResourceManager.checkTrailingDirectoryPath(p_215479_);
        TreeMap<ResourceLocation, List<Resource>> $$2 = new TreeMap<ResourceLocation, List<Resource>>();
        for (FallbackResourceManager $$3 : this.namespacedManagers.values()) {
            $$2.putAll($$3.listResourceStacks(p_215479_, p_215480_));
        }
        return $$2;
    }

    private static void checkTrailingDirectoryPath(String p_249608_) {
        if (p_249608_.endsWith("/")) {
            throw new IllegalArgumentException("Trailing slash in path " + p_249608_);
        }
    }

    @Override
    public Stream<PackResources> listPacks() {
        return this.packs.stream();
    }

    @Override
    public void close() {
        this.packs.forEach(PackResources::close);
    }
}

