/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior.declarative;

import com.mojang.datafixers.kinds.Const;
import com.mojang.datafixers.kinds.IdF;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.kinds.OptionalBox;
import com.mojang.datafixers.util.Unit;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public interface MemoryCondition<F extends K1, Value> {
    public MemoryModuleType<Value> memory();

    public MemoryStatus condition();

    @Nullable
    public MemoryAccessor<F, Value> createAccessor(Brain<?> var1, Optional<Value> var2);

    public record Absent<Value>(MemoryModuleType<Value> memory) implements MemoryCondition<Const.Mu<Unit>, Value>
    {
        @Override
        public MemoryStatus condition() {
            return MemoryStatus.VALUE_ABSENT;
        }

        @Override
        public MemoryAccessor<Const.Mu<Unit>, Value> createAccessor(Brain<?> p_259727_, Optional<Value> p_260359_) {
            if (p_260359_.isPresent()) {
                return null;
            }
            return new MemoryAccessor(p_259727_, this.memory, Const.create((Object)Unit.INSTANCE));
        }
    }

    public record Present<Value>(MemoryModuleType<Value> memory) implements MemoryCondition<IdF.Mu, Value>
    {
        @Override
        public MemoryStatus condition() {
            return MemoryStatus.VALUE_PRESENT;
        }

        @Override
        public MemoryAccessor<IdF.Mu, Value> createAccessor(Brain<?> p_259253_, Optional<Value> p_260268_) {
            if (p_260268_.isEmpty()) {
                return null;
            }
            return new MemoryAccessor(p_259253_, this.memory, IdF.create(p_260268_.get()));
        }
    }

    public record Registered<Value>(MemoryModuleType<Value> memory) implements MemoryCondition<OptionalBox.Mu, Value>
    {
        @Override
        public MemoryStatus condition() {
            return MemoryStatus.REGISTERED;
        }

        @Override
        public MemoryAccessor<OptionalBox.Mu, Value> createAccessor(Brain<?> p_260149_, Optional<Value> p_259303_) {
            return new MemoryAccessor(p_260149_, this.memory, OptionalBox.create(p_259303_));
        }
    }
}

