/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.world.phys.shapes.CubePointRange;
import net.minecraft.world.phys.shapes.IndexMerger;
import net.minecraft.world.phys.shapes.Shapes;

public final class DiscreteCubeMerger
implements IndexMerger {
    private final CubePointRange result;
    private final int firstDiv;
    private final int secondDiv;

    DiscreteCubeMerger(int p_82776_, int p_82777_) {
        this.result = new CubePointRange((int)Shapes.lcm(p_82776_, p_82777_));
        int $$2 = IntMath.gcd((int)p_82776_, (int)p_82777_);
        this.firstDiv = p_82776_ / $$2;
        this.secondDiv = p_82777_ / $$2;
    }

    @Override
    public boolean forMergedIndexes(IndexMerger.IndexConsumer p_82780_) {
        int $$1 = this.result.size() - 1;
        for (int $$2 = 0; $$2 < $$1; ++$$2) {
            if (p_82780_.merge($$2 / this.secondDiv, $$2 / this.firstDiv, $$2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    public DoubleList getList() {
        return this.result;
    }
}

