/*
 * Decompiled with CFR 0.152.
 */
package net.neoforged.fml.loading.moddiscovery;

import cpw.mods.jarhandling.JarContents;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.neoforged.fml.loading.StringUtils;

public enum IncompatibleModReason {
    OLDFORGE(IncompatibleModReason.filePresent("mcmod.info")),
    MINECRAFT_FORGE(IncompatibleModReason.filePresent("META-INF/mods.toml")),
    FABRIC(IncompatibleModReason.filePresent("fabric.mod.json")),
    QUILT(IncompatibleModReason.filePresent("quilt.mod.json")),
    LITELOADER(IncompatibleModReason.filePresent("litemod.json")),
    OPTIFINE(IncompatibleModReason.filePresent("optifine/Installer.class")),
    BUKKIT(IncompatibleModReason.filePresent("plugin.yml"));

    private final Predicate<JarContents> ident;

    private IncompatibleModReason(Predicate<JarContents> identifier) {
        this.ident = identifier;
    }

    public String getReason() {
        return "fml.modloadingissue.brokenfile." + StringUtils.toLowerCase(this.name());
    }

    public static Optional<IncompatibleModReason> detect(JarContents jar) {
        return Arrays.stream(IncompatibleModReason.values()).filter(i -> i.ident.test(jar)).findAny();
    }

    private static Predicate<JarContents> filePresent(String filename) {
        return jarContents -> jarContents.findFile(filename).isPresent();
    }
}

