/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.EffectCures;

public class MilkBucketItem
extends Item {
    private static final int DRINK_DURATION = 32;

    public MilkBucketItem(Item.Properties p_42921_) {
        super(p_42921_);
    }

    @Override
    public ItemStack finishUsingItem(ItemStack p_42923_, Level p_42924_, LivingEntity p_42925_) {
        if (p_42925_ instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)p_42925_;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, p_42923_);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!p_42924_.isClientSide) {
            p_42925_.removeEffectsCuredBy(EffectCures.MILK);
        }
        if (p_42925_ instanceof Player) {
            Player player = (Player)p_42925_;
            return ItemUtils.createFilledResult((ItemStack)p_42923_, (Player)player, (ItemStack)new ItemStack(Items.BUCKET), (boolean)false);
        }
        p_42923_.consume(1, p_42925_);
        return p_42923_;
    }

    @Override
    public int getUseDuration(ItemStack p_42933_, LivingEntity p_345727_) {
        return 32;
    }

    @Override
    public UseAnim getUseAnimation(ItemStack p_42931_) {
        return UseAnim.DRINK;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level p_42927_, Player p_42928_, InteractionHand p_42929_) {
        return ItemUtils.startUsingInstantly((Level)p_42927_, (Player)p_42928_, (InteractionHand)p_42929_);
    }
}

