/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.commands.Commands;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.WorldDataConfiguration;
import net.neoforged.neoforge.registries.DataPackRegistriesHooks;
import org.slf4j.Logger;

public class WorldLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <D, R> CompletableFuture<R> load(InitConfig p_214363_, WorldDataSupplier<D> p_214364_, ResultFactory<D, R> p_214365_, Executor p_214366_, Executor p_214367_) {
        try {
            Pair<WorldDataConfiguration, CloseableResourceManager> pair = p_214363_.packConfig.createResourceManager();
            CloseableResourceManager closeableresourcemanager = (CloseableResourceManager)pair.getSecond();
            LayeredRegistryAccess layeredregistryaccess = RegistryLayer.createRegistryAccess();
            LayeredRegistryAccess<RegistryLayer> layeredregistryaccess1 = WorldLoader.loadAndReplaceLayer((ResourceManager)closeableresourcemanager, (LayeredRegistryAccess<RegistryLayer>)layeredregistryaccess, RegistryLayer.WORLDGEN, DataPackRegistriesHooks.getDataPackRegistries());
            RegistryAccess.Frozen registryaccess$frozen = layeredregistryaccess1.getAccessForLoading((Object)RegistryLayer.DIMENSIONS);
            RegistryAccess.Frozen registryaccess$frozen1 = RegistryDataLoader.load((ResourceManager)closeableresourcemanager, (RegistryAccess)registryaccess$frozen, RegistryDataLoader.DIMENSION_REGISTRIES);
            WorldDataConfiguration worlddataconfiguration = (WorldDataConfiguration)pair.getFirst();
            DataLoadOutput<D> dataloadoutput = p_214364_.get(new DataLoadContext((ResourceManager)closeableresourcemanager, worlddataconfiguration, registryaccess$frozen, registryaccess$frozen1));
            LayeredRegistryAccess layeredregistryaccess2 = layeredregistryaccess1.replaceFrom((Object)RegistryLayer.DIMENSIONS, new RegistryAccess.Frozen[]{dataloadoutput.finalDimensions});
            return ((CompletableFuture)ReloadableServerResources.loadResources((ResourceManager)closeableresourcemanager, (LayeredRegistryAccess<RegistryLayer>)layeredregistryaccess2, worlddataconfiguration.enabledFeatures(), p_214363_.commandSelection(), p_214363_.functionCompilationLevel(), p_214366_, p_214367_).whenComplete((p_214370_, p_214371_) -> {
                if (p_214371_ != null) {
                    closeableresourcemanager.close();
                }
            })).thenApplyAsync(p_335216_ -> {
                p_335216_.updateRegistryTags();
                return p_214365_.create(closeableresourcemanager, (ReloadableServerResources)p_335216_, (LayeredRegistryAccess<RegistryLayer>)layeredregistryaccess2, dataloadoutput.cookie);
            }, p_214367_);
        }
        catch (Exception exception) {
            return CompletableFuture.failedFuture(exception);
        }
    }

    private static RegistryAccess.Frozen loadLayer(ResourceManager p_251529_, LayeredRegistryAccess<RegistryLayer> p_250737_, RegistryLayer p_250790_, List<RegistryDataLoader.RegistryData<?>> p_249516_) {
        RegistryAccess.Frozen registryaccess$frozen = p_250737_.getAccessForLoading((Object)p_250790_);
        return RegistryDataLoader.load(p_251529_, (RegistryAccess)registryaccess$frozen, p_249516_);
    }

    private static LayeredRegistryAccess<RegistryLayer> loadAndReplaceLayer(ResourceManager p_249913_, LayeredRegistryAccess<RegistryLayer> p_252077_, RegistryLayer p_250346_, List<RegistryDataLoader.RegistryData<?>> p_250589_) {
        RegistryAccess.Frozen registryaccess$frozen = WorldLoader.loadLayer(p_249913_, p_252077_, p_250346_, p_250589_);
        return p_252077_.replaceFrom((Object)p_250346_, new RegistryAccess.Frozen[]{registryaccess$frozen});
    }

    public record InitConfig(PackConfig packConfig, Commands.CommandSelection commandSelection, int functionCompilationLevel) {
    }

    public record PackConfig(PackRepository packRepository, WorldDataConfiguration initialDataConfig, boolean safeMode, boolean initMode) {
        public Pair<WorldDataConfiguration, CloseableResourceManager> createResourceManager() {
            WorldDataConfiguration worlddataconfiguration = MinecraftServer.configurePackRepository(this.packRepository, this.initialDataConfig, this.initMode, this.safeMode);
            List<PackResources> list = this.packRepository.openAllSelected();
            MultiPackResourceManager closeableresourcemanager = new MultiPackResourceManager(PackType.SERVER_DATA, list);
            return Pair.of((Object)worlddataconfiguration, (Object)closeableresourcemanager);
        }
    }

    public record DataLoadContext(ResourceManager resources, WorldDataConfiguration dataConfiguration, RegistryAccess.Frozen datapackWorldgen, RegistryAccess.Frozen datapackDimensions) {
    }

    @FunctionalInterface
    public static interface WorldDataSupplier<D> {
        public DataLoadOutput<D> get(DataLoadContext var1);
    }

    public record DataLoadOutput<D>(D cookie, RegistryAccess.Frozen finalDimensions) {
    }

    @FunctionalInterface
    public static interface ResultFactory<D, R> {
        public R create(CloseableResourceManager var1, ReloadableServerResources var2, LayeredRegistryAccess<RegistryLayer> var3, D var4);
    }
}

