/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 '2\u00020\u00012\u00020\u0002:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J(\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0014J2\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020#H\u0016J(\u0010$\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020%2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u001bH\u0016\u00a8\u0006("}, d2={"Ldev/hybridlabs/aquatic/block/BaseCattailBlock;", "Lnet/minecraft/world/level/block/DoublePlantBlock;", "Lnet/minecraft/world/level/block/LiquidBlockContainer;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "world", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "mayPlaceOn", "", "floor", "canSurvive", "level", "Lnet/minecraft/world/level/LevelReader;", "getStateForPlacement", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "canPlaceLiquid", "p0", "Lnet/minecraft/world/entity/player/Player;", "p1", "p2", "p3", "p4", "Lnet/minecraft/world/level/material/Fluid;", "placeLiquid", "Lnet/minecraft/world/level/LevelAccessor;", "fluidState", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public class BaseCattailBlock
extends DoublePlantBlock
implements LiquidBlockContainer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EnumProperty<DoubleBlockHalf> HALF;
    @NotNull
    private static final VoxelShape SHAPE;

    public BaseCattailBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return SHAPE;
    }

    protected boolean mayPlaceOn(@NotNull BlockState floor, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)floor, (String)"floor");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return floor.is(BlockTags.DIRT) || floor.is(Blocks.CLAY) || floor.is(BlockTags.SAND);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (state.getValue((Property)HALF) == DoubleBlockHalf.UPPER) {
            BlockState belowState = level.getBlockState(pos.below());
            if (!belowState.is((Block)this)) return false;
            if (belowState.getValue((Property)HALF) != DoubleBlockHalf.LOWER) return false;
            return true;
        }
        FluidState fluidHere = level.getFluidState(pos);
        BlockState blockBelow = level.getBlockState(pos.below());
        if (!fluidHere.is(FluidTags.WATER)) return false;
        if (fluidHere.getAmount() != 8) return false;
        Intrinsics.checkNotNull((Object)blockBelow);
        BlockGetter blockGetter = (BlockGetter)level;
        BlockPos blockPos = pos.below();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"below(...)");
        if (!this.mayPlaceOn(blockBelow, blockGetter, blockPos)) return false;
        return true;
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        FluidState fluidHere = world.getFluidState(pos);
        BlockState blockAbove = world.getBlockState(pos.above());
        return fluidHere.is(FluidTags.WATER) && fluidHere.getAmount() == 8 && blockAbove.isAir() ? this.defaultBlockState() : null;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state.getValue((Property)HALF) == DoubleBlockHalf.LOWER) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            Intrinsics.checkNotNull((Object)fluidState2);
            fluidState = fluidState2;
        } else {
            FluidState fluidState3 = Fluids.EMPTY.defaultFluidState();
            Intrinsics.checkNotNull((Object)fluidState3);
            fluidState = fluidState3;
        }
        return fluidState;
    }

    public boolean canPlaceLiquid(@Nullable Player p0, @NotNull BlockGetter p1, @NotNull BlockPos p2, @NotNull BlockState p3, @NotNull Fluid p4) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Intrinsics.checkNotNullParameter((Object)p3, (String)"p3");
        Intrinsics.checkNotNullParameter((Object)p4, (String)"p4");
        return false;
    }

    public boolean placeLiquid(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)fluidState, (String)"fluidState");
        return false;
    }

    static {
        EnumProperty enumProperty = DoublePlantBlock.HALF;
        Intrinsics.checkNotNullExpressionValue((Object)enumProperty, (String)"HALF");
        HALF = enumProperty;
        VoxelShape voxelShape = DoublePlantBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/hybridlabs/aquatic/block/BaseCattailBlock$Companion;", "", "<init>", "()V", "HALF", "Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "Lnet/minecraft/world/level/block/state/properties/DoubleBlockHalf;", "getHALF", "()Lnet/minecraft/world/level/block/state/properties/EnumProperty;", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnumProperty<DoubleBlockHalf> getHALF() {
            return HALF;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

