/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\bH\u0014J8\u0010\u0012\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0014J\u001c\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u001eH\u0014J(\u0010\u001f\u001a\u00020 2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0014J \u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020%2\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010&\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0014\u00a8\u0006*"}, d2={"Ldev/hybridlabs/aquatic/block/RaftBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "isPathfindable", "", "state", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "updateShape", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "world", "Lnet/minecraft/world/level/LevelAccessor;", "pos", "Lnet/minecraft/core/BlockPos;", "neighborPos", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "canSurvive", "Lnet/minecraft/world/level/LevelReader;", "rotate", "rotation", "Lnet/minecraft/world/level/block/Rotation;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class RaftBlock
extends Block
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final DirectionProperty FACING;
    @NotNull
    private static final VoxelShape SHAPE;
    @NotNull
    private static final VoxelShape LAND_SHAPE;

    public RaftBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
    }

    @NotNull
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        boolean waterlogged = Intrinsics.areEqual((Object)ctx.getLevel().getFluidState(ctx.getClickedPos()), (Object)Fluids.WATER.getSource(false));
        Object object = ((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged))).setValue((Property)FACING, (Comparable)ctx.getHorizontalDirection().getClockWise());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"setValue(...)");
        return (BlockState)object;
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (this.canSurvive(state, (LevelReader)world, pos)) {
            BlockState blockState2 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            blockState = blockState2;
            Intrinsics.checkNotNullExpressionValue((Object)blockState2, (String)"updateShape(...)");
        } else {
            BlockState blockState3 = Blocks.AIR.defaultBlockState();
            blockState = blockState3;
            Intrinsics.checkNotNullExpressionValue((Object)blockState3, (String)"defaultBlockState(...)");
        }
        return blockState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{BlockStateProperties.WATERLOGGED, FACING};
        builder.add(propertyArray);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? SHAPE : LAND_SHAPE;
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        FluidState fluidStateAbove = world.getFluidState(pos.above());
        if (!fluidStateAbove.is(Fluids.EMPTY)) {
            return false;
        }
        BlockState stateBelow = world.getBlockState(pos.below());
        if (Intrinsics.areEqual((Object)stateBelow.getBlock(), (Object)((Object)this))) {
            return false;
        }
        FluidState fluidState = world.getFluidState(pos);
        return fluidState.is((Fluid)Fluids.WATER) || Block.canSupportCenter((LevelReader)world, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    @NotNull
    protected BlockState rotate(@NotNull BlockState state, @NotNull Rotation rotation) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Property property = (Property)FACING;
        Comparable comparable = state.getValue((Property)FACING);
        Intrinsics.checkNotNull((Object)comparable, (String)"null cannot be cast to non-null type net.minecraft.core.Direction");
        Object object = state.setValue(property, (Comparable)rotation.rotate((Direction)comparable));
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type net.minecraft.world.level.block.state.BlockState");
        return (BlockState)object;
    }

    static {
        DirectionProperty directionProperty = HorizontalDirectionalBlock.FACING;
        Intrinsics.checkNotNullExpressionValue((Object)directionProperty, (String)"FACING");
        FACING = directionProperty;
        VoxelShape voxelShape = Block.box((double)1.0, (double)12.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        SHAPE = voxelShape;
        VoxelShape voxelShape2 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.5, (double)15.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        LAND_SHAPE = voxelShape2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ldev/hybridlabs/aquatic/block/RaftBlock$Companion;", "", "<init>", "()V", "FACING", "Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "getFACING", "()Lnet/minecraft/world/level/block/state/properties/DirectionProperty;", "SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "LAND_SHAPE", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectionProperty getFACING() {
            return FACING;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

