/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u00012\u00020\u00022\u00020\u0003:\u00013B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0017J8\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000bH\u0014J(\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\r\u001a\u00020\tH\u0014J\u001c\u0010\u001f\u001a\u00020 2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\t0\"H\u0014J \u0010$\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020%2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\tH\u0016J(\u0010&\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\tH\u0016J(\u0010*\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020+2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\tH\u0016J\u0018\u0010,\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\t2\u0006\u0010-\u001a\u00020.H\u0014J \u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0010\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000102H\u0014\u00a8\u00064"}, d2={"Ldev/hybridlabs/aquatic/block/TubeWormBlock;", "Lnet/minecraft/world/level/block/BushBlock;", "Lnet/minecraft/world/level/block/BonemealableBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "getStateForPlacement", "Lnet/minecraft/world/level/block/state/BlockState;", "ctx", "Lnet/minecraft/world/item/context/BlockPlaceContext;", "updateShape", "state", "direction", "Lnet/minecraft/core/Direction;", "neighborState", "world", "Lnet/minecraft/world/level/LevelAccessor;", "pos", "Lnet/minecraft/core/BlockPos;", "neighborPos", "canBeReplaced", "", "context", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getFluidState", "Lnet/minecraft/world/level/material/FluidState;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "isValidBonemealTarget", "Lnet/minecraft/world/level/LevelReader;", "isBonemealSuccess", "Lnet/minecraft/world/level/Level;", "random", "Lnet/minecraft/util/RandomSource;", "performBonemeal", "Lnet/minecraft/server/level/ServerLevel;", "isPathfindable", "type", "Lnet/minecraft/world/level/pathfinder/PathComputationType;", "mayPlaceOn", "floor", "codec", "Lcom/mojang/serialization/MapCodec;", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class TubeWormBlock
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final MapCodec<TubeWormBlock> CODEC;
    @NotNull
    private static final IntegerProperty WORMS;
    @NotNull
    private static final BooleanProperty WATERLOGGED;
    @NotNull
    private static final Codec<IntProvider> WORM_COUNT_CODEC;
    @NotNull
    private static final VoxelShape ONE_WORM_SHAPE;
    @NotNull
    private static final VoxelShape TWO_WORMS_SHAPE;
    @NotNull
    private static final VoxelShape THREE_WORMS_SHAPE;
    @NotNull
    private static final VoxelShape FOUR_WORMS_SHAPE;

    public TubeWormBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)WORMS, (Comparable)Integer.valueOf(TubeWormBlock.WORMS.min)));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        BlockState blockState2 = ctx.getLevel().getBlockState(ctx.getClickedPos());
        if (blockState2.is((Block)this)) {
            blockState = (BlockState)blockState2.setValue((Property)WORMS, (Comparable)Integer.valueOf(RangesKt.coerceAtMost((int)(((Number)((Object)blockState2.getValue((Property)WORMS))).intValue() + 1), (int)TubeWormBlock.WORMS.max)));
        } else {
            FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
            boolean isWaterlogged = fluidState.is(FluidTags.WATER);
            BlockState blockState3 = super.getStateForPlacement(ctx);
            blockState = blockState3 != null ? (BlockState)blockState3.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged)) : null;
        }
        return blockState;
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction direction, @NotNull BlockState neighborState, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockPos neighborPos) {
        BlockState blockState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)neighborState, (String)"neighborState");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)neighborPos, (String)"neighborPos");
        if (!state.canSurvive((LevelReader)world, pos)) {
            BlockState blockState2 = Blocks.AIR.defaultBlockState();
            Intrinsics.checkNotNull((Object)blockState2);
            blockState = blockState2;
        } else {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
                world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
            }
            BlockState blockState3 = super.updateShape(state, direction, neighborState, world, pos, neighborPos);
            Intrinsics.checkNotNull((Object)blockState3);
            blockState = blockState3;
        }
        return blockState;
    }

    protected boolean canBeReplaced(@NotNull BlockState state, @NotNull BlockPlaceContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return !context.isSecondaryUseActive() && context.getItemInHand().is(this.asItem()) && ((Number)((Object)state.getValue((Property)WORMS))).intValue() < TubeWormBlock.WORMS.max || super.canBeReplaced(state, context);
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        VoxelShape voxelShape;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Integer n2 = n = (Integer)state.getValue((Property)WORMS);
        int n3 = 1;
        if (n2 != null && n2 == n3) {
            voxelShape = ONE_WORM_SHAPE;
        } else {
            Integer n4 = n;
            n3 = 2;
            if (n4 != null && n4 == n3) {
                voxelShape = TWO_WORMS_SHAPE;
            } else {
                Integer n5 = n;
                n3 = 3;
                if (n5 != null && n5 == n3) {
                    voxelShape = THREE_WORMS_SHAPE;
                } else {
                    Integer n6 = n;
                    n3 = 4;
                    voxelShape = n6 != null && n6 == n3 ? FOUR_WORMS_SHAPE : ONE_WORM_SHAPE;
                }
            }
        }
        return voxelShape;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        FluidState fluidState;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            FluidState fluidState2 = Fluids.WATER.getSource(false);
            fluidState = fluidState2;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState2, (String)"getSource(...)");
        } else {
            FluidState fluidState3 = super.getFluidState(state);
            fluidState = fluidState3;
            Intrinsics.checkNotNullExpressionValue((Object)fluidState3, (String)"getFluidState(...)");
        }
        return fluidState;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{WORMS, WATERLOGGED};
        builder.add(propertyArray);
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    public boolean isBonemealSuccess(@NotNull Level world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return false;
    }

    public void performBonemeal(@NotNull ServerLevel world, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    protected boolean mayPlaceOn(@NotNull BlockState floor, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)floor, (String)"floor");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return !floor.getCollisionShape(world, pos).getFaceShape(Direction.UP).isEmpty() || floor.isFaceSturdy(world, pos, Direction.UP);
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    static {
        MapCodec mapCodec = BushBlock.simpleCodec(TubeWormBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        CODEC = mapCodec;
        IntegerProperty integerProperty = IntegerProperty.create((String)"worms", (int)1, (int)4);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        WORMS = integerProperty;
        BooleanProperty booleanProperty = BlockStateProperties.WATERLOGGED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"WATERLOGGED");
        WATERLOGGED = booleanProperty;
        Codec codec = IntProvider.codec((int)TubeWormBlock.WORMS.min, (int)TubeWormBlock.WORMS.max);
        Intrinsics.checkNotNullExpressionValue((Object)codec, (String)"codec(...)");
        WORM_COUNT_CODEC = codec;
        VoxelShape voxelShape = BushBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        ONE_WORM_SHAPE = voxelShape;
        VoxelShape voxelShape2 = BushBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape2, (String)"box(...)");
        TWO_WORMS_SHAPE = voxelShape2;
        VoxelShape voxelShape3 = BushBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape3, (String)"box(...)");
        THREE_WORMS_SHAPE = voxelShape3;
        VoxelShape voxelShape4 = BushBlock.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape4, (String)"box(...)");
        FOUR_WORMS_SHAPE = voxelShape4;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ldev/hybridlabs/aquatic/block/TubeWormBlock$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/MapCodec;", "Ldev/hybridlabs/aquatic/block/TubeWormBlock;", "getCODEC", "()Lcom/mojang/serialization/MapCodec;", "WORMS", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "getWORMS", "()Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "WATERLOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "getWATERLOGGED", "()Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "WORM_COUNT_CODEC", "Lcom/mojang/serialization/Codec;", "Lnet/minecraft/util/valueproviders/IntProvider;", "getWORM_COUNT_CODEC", "()Lcom/mojang/serialization/Codec;", "ONE_WORM_SHAPE", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "TWO_WORMS_SHAPE", "THREE_WORMS_SHAPE", "FOUR_WORMS_SHAPE", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MapCodec<TubeWormBlock> getCODEC() {
            return CODEC;
        }

        @NotNull
        public final IntegerProperty getWORMS() {
            return WORMS;
        }

        @NotNull
        public final BooleanProperty getWATERLOGGED() {
            return WATERLOGGED;
        }

        @NotNull
        public final Codec<IntProvider> getWORM_COUNT_CODEC() {
            return WORM_COUNT_CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

