/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.datagen;

import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.config.ConfigHelper;
import dev.hybridlabs.aquatic.config.EntitySpawnConfig;
import dev.hybridlabs.aquatic.config.HybridAquaticConfigHandler;
import dev.hybridlabs.aquatic.datagen.HAGlobalLootModifierProvider;
import dev.hybridlabs.aquatic.utils.NaughtyRegistrySetBuilder;
import dev.hybridlabs.aquatic.world.gen.feature.BiomeFeatureAddition;
import dev.hybridlabs.aquatic.world.gen.structure.BuiltinSpawnModifiersKt;
import dev.hybridlabs.aquatic.world.gen.structure.SpawnModifier;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.common.world.StructureModifier;
import net.neoforged.neoforge.common.world.StructureModifiers;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="hybrid_aquatic", bus=EventBusSubscriber.Bus.MOD)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002J\u0016\u0010\u000e\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0002\u00a8\u0006\u000f"}, d2={"Ldev/hybridlabs/aquatic/datagen/DataGenerators;", "", "<init>", "()V", "gatherData", "", "event", "Lnet/neoforged/neoforge/data/event/GatherDataEvent;", "registerStructureSpawnModifiers", "context", "Lnet/minecraft/data/worldgen/BootstrapContext;", "Lnet/neoforged/neoforge/common/world/StructureModifier;", "registerFeatures", "Lnet/neoforged/neoforge/common/world/BiomeModifier;", "registerBiomeSpawns", "hybrid-aquatic-neoforge-1.21.1"})
public final class DataGenerators {
    @NotNull
    public static final DataGenerators INSTANCE = new DataGenerators();

    private DataGenerators() {
    }

    @SubscribeEvent
    public final void gatherData(@NotNull GatherDataEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        NaughtyRegistrySetBuilder builder = new NaughtyRegistrySetBuilder();
        CompletableFuture lookupProvider = event.getLookupProvider();
        builder.add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, DataGenerators::gatherData$lambda$0);
        builder.add(NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS, DataGenerators::gatherData$lambda$1);
        generator.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(packOutput, lookupProvider, (RegistrySetBuilder)builder, SetsKt.setOf((Object)"hybrid-aquatic")));
        boolean bl = event.includeServer();
        Intrinsics.checkNotNull((Object)packOutput);
        Intrinsics.checkNotNull((Object)lookupProvider);
        generator.addProvider(bl, (DataProvider)new HAGlobalLootModifierProvider(packOutput, lookupProvider));
    }

    private final void registerStructureSpawnModifiers(BootstrapContext<StructureModifier> context) {
        for (SpawnModifier structureModifier : BuiltinSpawnModifiersKt.getBuiltinSpawnModifiers()) {
            ResourceKey key = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.STRUCTURE_MODIFIERS, (ResourceLocation)CommonClass.locate(structureModifier.getId()));
            HolderGetter reg = context.lookup(Registries.STRUCTURE);
            Holder.Reference structure = reg.getOrThrow(structureModifier.getStructure());
            List spawns = CollectionsKt.flatten((Iterable)structureModifier.getSpawns().values());
            boolean bl = false;
            Holder[] holderArray = new Holder[]{structure};
            context.register(key, (Object)new StructureModifiers.AddSpawnsStructureModifier((HolderSet)HolderSet.direct((Holder[])holderArray), spawns));
        }
    }

    private final void registerFeatures(BootstrapContext<BiomeModifier> context) {
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        HolderGetter featureRegistry = context.lookup(Registries.PLACED_FEATURE);
        for (BiomeFeatureAddition addition : BiomeFeatureAddition.Companion.getBuiltIn()) {
            String location = addition.getPlacedFeature().location().getPath() + "_" + addition.getBiomeTag().location().getPath();
            ResourceKey key = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)CommonClass.locate(location));
            Holder[] holderArray = new Holder[]{featureRegistry.getOrThrow(addition.getPlacedFeature())};
            context.register(key, (Object)new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomeRegistry.getOrThrow(addition.getBiomeTag()), (HolderSet)HolderSet.direct((Holder[])holderArray), addition.getStep()));
        }
    }

    private final void registerBiomeSpawns(BootstrapContext<BiomeModifier> context) {
        Path path = CommonClass.CONFIG_FILE;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"CONFIG_FILE");
        HybridAquaticConfigHandler configHandler = ConfigHelper.INSTANCE.initializeConfig(path);
        HolderGetter biomeRegistry = context.lookup(Registries.BIOME);
        for (EntitySpawnConfig spawnConfig : configHandler.getDefaultConfig().getEntitySpawnConfig()) {
            String location = spawnConfig.getType().toShortString() + "_" + spawnConfig.getBiomes().location().getPath();
            ResourceKey key = ResourceKey.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)CommonClass.locate(location));
            context.register(key, (Object)new BiomeModifiers.AddSpawnsBiomeModifier((HolderSet)biomeRegistry.get(spawnConfig.getBiomes()).get(), CollectionsKt.listOf((Object)new MobSpawnSettings.SpawnerData(spawnConfig.getType(), spawnConfig.getWeight(), spawnConfig.getMinGroupSize(), spawnConfig.getMaxGroupSize()))));
        }
    }

    private static final void gatherData$lambda$0(BootstrapContext context) {
        Intrinsics.checkNotNull((Object)context);
        INSTANCE.registerBiomeSpawns((BootstrapContext<BiomeModifier>)context);
        INSTANCE.registerFeatures((BootstrapContext<BiomeModifier>)context);
    }

    private static final void gatherData$lambda$1(BootstrapContext context) {
        Intrinsics.checkNotNull((Object)context);
        INSTANCE.registerStructureSpawnModifiers((BootstrapContext<StructureModifier>)context);
    }
}

