/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.ai.goal.boids;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/entity/ai/goal/boids/StayInWaterGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "mob", "Lnet/minecraft/world/entity/Mob;", "<init>", "(Lnet/minecraft/world/entity/Mob;)V", "canUse", "", "tick", "", "amount", "", "hybrid-aquatic-neoforge-1.21.1"})
public final class StayInWaterGoal
extends Goal {
    @NotNull
    private final Mob mob;

    public StayInWaterGoal(@NotNull Mob mob) {
        Intrinsics.checkNotNullParameter((Object)mob, (String)"mob");
        this.mob = mob;
    }

    public boolean canUse() {
        return this.mob.isUnderWater();
    }

    public void tick() {
        BlockPos blockPos = this.mob.blockPosition();
        BlockState blockAbove = this.mob.level().getBlockState(blockPos.above(1));
        float amount = this.amount();
        if (blockAbove.getFluidState().isEmpty()) {
            this.mob.addDeltaMovement(new Vec3(0.0, -((double)amount), 0.0));
        }
    }

    public final float amount() {
        float amount = 0.1f;
        float dY = Mth.abs((float)((float)this.mob.getDeltaMovement().y));
        if (dY > amount) {
            amount = dY;
        }
        return amount;
    }
}

