/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.cephalopod;

import dev.hybridlabs.aquatic.entity.cephalopod.HybridAquaticCephalopodEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0010H\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/VampireSquidEntity;", "Ldev/hybridlabs/aquatic/entity/cephalopod/HybridAquaticCephalopodEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "isFeeding", "", "registerControllers", "", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "tick", "getMaxSize", "", "getMinSize", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class VampireSquidEntity
extends HybridAquaticCephalopodEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isFeeding;
    @NotNull
    private static final RawAnimation TENTACLES_EXTENDED;
    @NotNull
    private static final RawAnimation TENTACLES_RETRACTED;

    public VampireSquidEntity(@NotNull EntityType<? extends VampireSquidEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world, HybridAquaticEntityTags.INSTANCE.getNONE(), CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getSHARK()), false, false);
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Open/Closed", 8, arg_0 -> VampireSquidEntity.registerControllers$lambda$0(this, arg_0)));
        super.registerControllers(controllers);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getHunger() < 600) {
            this.isFeeding = true;
        }
        if (this.isFeeding) {
            this.setHunger(this.getHunger() + 2);
            if (this.getHunger() >= 2400) {
                this.setHunger(2400);
                this.isFeeding = false;
            }
        }
    }

    @Override
    protected int getMaxSize() {
        return 5;
    }

    @Override
    protected int getMinSize() {
        return -5;
    }

    private static final PlayState registerControllers$lambda$0(VampireSquidEntity this$0, AnimationState state) {
        RawAnimation animation = this$0.isFeeding ? TENTACLES_EXTENDED : TENTACLES_RETRACTED;
        return state.setAndContinue(animation);
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.tentacles_extended");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        TENTACLES_EXTENDED = rawAnimation;
        RawAnimation rawAnimation2 = RawAnimation.begin().thenPlay("misc.tentacles_retracted");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation2, (String)"thenPlay(...)");
        TENTACLES_RETRACTED = rawAnimation2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/entity/cephalopod/VampireSquidEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "TENTACLES_EXTENDED", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getTENTACLES_EXTENDED", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "TENTACLES_RETRACTED", "getTENTACLES_RETRACTED", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 8.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final RawAnimation getTENTACLES_EXTENDED() {
            return TENTACLES_EXTENDED;
        }

        @NotNull
        public final RawAnimation getTENTACLES_RETRACTED() {
            return TENTACLES_RETRACTED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

