/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.crustacean;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.entity.crustacean.HybridAquaticCrustaceanEntity;
import dev.hybridlabs.aquatic.entity.feature.OverlayTextureFeature;
import java.util.Collection;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ,\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0012H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0014J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006&"}, d2={"Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity;", "Ldev/hybridlabs/aquatic/entity/crustacean/HybridAquaticCrustaceanEntity;", "Ldev/hybridlabs/aquatic/entity/feature/OverlayTextureFeature;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "getMaxSize", "", "getMinSize", "value", "Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures;", "overlayTexture", "getOverlayTexture", "()Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures;", "setOverlayTexture", "(Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures;)V", "getOverlayTextureName", "", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class ShrimpEntity
extends HybridAquaticCrustaceanEntity
implements OverlayTextureFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Integer> OverlayTexture;

    public ShrimpEntity(@NotNull EntityType<? extends HybridAquaticCrustaceanEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world, false);
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        int overlayID = world.getRandom().nextIntBetweenInclusive(0, Companion.OverlayTextures.getEntries().size() - 1);
        this.setOverlayTexture(Companion.OverlayTextures.Companion.byId(overlayID));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    @Override
    protected int getMaxSize() {
        return 5;
    }

    @Override
    protected int getMinSize() {
        return -5;
    }

    private final Companion.OverlayTextures getOverlayTexture() {
        Object object = this.entityData.get(OverlayTexture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OverlayTextures.Companion.byId(((Number)object).intValue());
    }

    private final void setOverlayTexture(Companion.OverlayTextures value) {
        this.entityData.set(OverlayTexture, (Object)value.getId());
    }

    @Override
    @NotNull
    public String getOverlayTextureName() {
        Object object = this.entityData.get(OverlayTexture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OverlayTextures.Companion.byId(((Number)object).intValue()).getSerializedName();
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(OverlayTexture, (Object)0);
        super.defineSynchedData(builder);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putInt("texture_overlay", this.getOverlayTexture().getId());
        super.addAdditionalSaveData(nbt);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (nbt.contains("texture_overlay")) {
            this.setOverlayTexture(Companion.OverlayTextures.Companion.byId(nbt.getInt("texture_overlay")));
        }
        super.readAdditionalSaveData(nbt);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(ShrimpEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        OverlayTexture = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u000bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "OverlayTexture", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getOverlayTexture", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "OverlayTextures", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 4.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getOverlayTexture() {
            return OverlayTexture;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\b\u0086\u0081\u0002\u0018\u0000 \u00152\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0015B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0014\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "getKey", "()Ljava/lang/String;", "NONE", "STRIPES", "TAIL", "LEGS", "STRIPES_LEGS", "STRIPES_TAIL", "STRIPES_LEGS_TAIL", "getSerializedName", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
        @SourceDebugExtension(value={"SMAP\nShrimpEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShrimpEntity.kt\ndev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,110:1\n37#2,2:111\n37#2,2:113\n*S KotlinDebug\n*F\n+ 1 ShrimpEntity.kt\ndev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures\n*L\n52#1:111,2\n55#1:113,2\n*E\n"})
        public static final class OverlayTextures
        extends Enum<OverlayTextures>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final Codec<OverlayTextures> CODEC;
            @NotNull
            private static final IntFunction<OverlayTextures> BY_ID;
            public static final /* enum */ OverlayTextures NONE;
            public static final /* enum */ OverlayTextures STRIPES;
            public static final /* enum */ OverlayTextures TAIL;
            public static final /* enum */ OverlayTextures LEGS;
            public static final /* enum */ OverlayTextures STRIPES_LEGS;
            public static final /* enum */ OverlayTextures STRIPES_TAIL;
            public static final /* enum */ OverlayTextures STRIPES_LEGS_TAIL;
            private static final /* synthetic */ OverlayTextures[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OverlayTextures(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public final String getKey() {
                return this.key;
            }

            @NotNull
            public String getSerializedName() {
                return this.key;
            }

            public static OverlayTextures[] values() {
                return (OverlayTextures[])$VALUES.clone();
            }

            public static OverlayTextures valueOf(String value) {
                return Enum.valueOf(OverlayTextures.class, value);
            }

            @NotNull
            public static EnumEntries<OverlayTextures> getEntries() {
                return $ENTRIES;
            }

            private static final OverlayTextures[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)OverlayTextures.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new OverlayTextures[0]);
            }

            private static final int BY_ID$lambda$0(OverlayTextures overlayTex) {
                Intrinsics.checkNotNullParameter((Object)((Object)overlayTex), (String)"overlayTex");
                return overlayTex.id;
            }

            static {
                NONE = new OverlayTextures(0, "");
                STRIPES = new OverlayTextures(1, "stripes");
                TAIL = new OverlayTextures(2, "tail");
                LEGS = new OverlayTextures(3, "legs");
                STRIPES_LEGS = new OverlayTextures(4, "stripes_legs");
                STRIPES_TAIL = new OverlayTextures(5, "stripes_tail");
                STRIPES_LEGS_TAIL = new OverlayTextures(6, "stripes_legs_tail");
                $VALUES = overlayTexturesArray = new OverlayTextures[]{OverlayTextures.NONE, OverlayTextures.STRIPES, OverlayTextures.TAIL, OverlayTextures.LEGS, OverlayTextures.STRIPES_LEGS, OverlayTextures.STRIPES_TAIL, OverlayTextures.STRIPES_LEGS_TAIL};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(OverlayTextures::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = (Codec)enumCodec;
                Collection $this$toTypedArray$iv = (Collection)OverlayTextures.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.continuous(OverlayTextures::BY_ID$lambda$0, (Object[])thisCollection$iv.toArray(new OverlayTextures[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/hybridlabs/aquatic/entity/crustacean/ShrimpEntity$Companion$OverlayTextures;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "BY_ID", "Ljava/util/function/IntFunction;", "getBY_ID", "()Ljava/util/function/IntFunction;", "byId", "id", "", "hybrid-aquatic-neoforge-1.21.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Codec<OverlayTextures> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final IntFunction<OverlayTextures> getBY_ID() {
                    return BY_ID;
                }

                @NotNull
                public final OverlayTextures byId(int id) {
                    OverlayTextures overlayTextures = this.getBY_ID().apply(id);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)overlayTextures), (String)"apply(...)");
                    return overlayTextures;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

