/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.ai.goal.FishAttackGoal;
import dev.hybridlabs.aquatic.entity.cephalopod.HybridAquaticCephalopodEntity;
import dev.hybridlabs.aquatic.entity.mammal.HybridAquaticMammalEntity;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 i2\u00020\u00012\u00020\u0002:\u0001iBO\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0016\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\b\u0012\u0016\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0014J,\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0005\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\"H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u001dH\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0014J\b\u00103\u001a\u000202H\u0002J\b\u00104\u001a\u00020*H\u0016J\u0010\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010=\u001a\u00020\u001d2\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010>\u001a\u00020*2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010E\u001a\u00020B2\u0006\u0010F\u001a\u00020GH\u0014J\b\u0010H\u001a\u00020BH\u0014J\u0018\u0010I\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020G2\u0006\u0010J\u001a\u00020*H\u0014J\b\u0010K\u001a\u000202H\u0002J\b\u0010L\u001a\u00020\u001dH\u0014J\u0010\u0010M\u001a\u00020\u00112\u0006\u0010N\u001a\u00020\u0011H\u0016J\u0010\u0010O\u001a\u00020*2\u0006\u0010P\u001a\u00020QH\u0016J\b\u0010]\u001a\u00020*H\u0014J\b\u0010^\u001a\u000202H\u0014J\b\u0010_\u001a\u000202H\u0014J\u0010\u0010`\u001a\u00020\u001d2\u0006\u0010a\u001a\u00020bH\u0016J\b\u0010c\u001a\u00020\u001aH\u0016J\u0010\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u0006H\u0014J\b\u0010g\u001a\u000202H\u0016J\b\u0010h\u001a\u000202H\u0016R$\u0010\u0007\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\n\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u0014\u0010A\u001a\u00020BX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR$\u0010R\u001a\u0002022\u0006\u0010R\u001a\u0002028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR$\u0010W\u001a\u0002022\u0006\u0010W\u001a\u0002028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bX\u0010T\"\u0004\bY\u0010VR$\u0010Z\u001a\u0002022\u0006\u0010Z\u001a\u0002028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b[\u0010T\"\u0004\b\\\u0010V\u00a8\u0006j"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "Lsoftware/bernie/geckolib/animatable/GeoEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "", "Lnet/minecraft/tags/TagKey;", "predator", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Ljava/util/List;Ljava/util/List;)V", "getPrey", "()Ljava/util/List;", "getPredator", "prevRoll", "", "getPrevRoll", "()F", "setPrevRoll", "(F)V", "currentRoll", "getCurrentRoll", "setCurrentRoll", "factory", "Lsoftware/bernie/geckolib/animatable/instance/AnimatableInstanceCache;", "kotlin.jvm.PlatformType", "registerGoals", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "isPushedByFluid", "", "tick", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "aiStep", "handleAirSupply", "air", "", "getMaxMoistness", "shouldFlopOnLand", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "fromFishingNet", "getFromFishingNet", "()Z", "setFromFishingNet", "(Z)V", "readAdditionalSaveData", "removeWhenFarAway", "distanceSquared", "", "flopSound", "Lnet/minecraft/sounds/SoundEvent;", "getFlopSound", "()Lnet/minecraft/sounds/SoundEvent;", "getHurtSound", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "dropFromLootTable", "causedByPlayer", "getHandSwingDuration", "updateSwingTime", "getAttackAnim", "tickDelta", "doHurtTarget", "target", "Lnet/minecraft/world/entity/Entity;", "moistness", "getMoistness", "()I", "setMoistness", "(I)V", "size", "getSize", "setSize", "hunger", "getHunger", "setHunger", "hasSelfControl", "getMinSize", "getMaxSize", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "getAnimatableInstanceCache", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "level", "getMaxHeadXRot", "getMaxHeadYRot", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nHybridAquaticFishEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HybridAquaticFishEntity.kt\ndev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,380:1\n1761#2,3:381\n*S KotlinDebug\n*F\n+ 1 HybridAquaticFishEntity.kt\ndev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity\n*L\n56#1:381,3\n*E\n"})
public class HybridAquaticFishEntity
extends WaterAnimal
implements GeoEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<TagKey<EntityType<?>>> prey;
    @NotNull
    private final List<TagKey<EntityType<?>>> predator;
    private float prevRoll;
    private float currentRoll;
    private final AnimatableInstanceCache factory;
    private boolean fromFishingNet;
    @NotNull
    private final SoundEvent flopSound;
    @NotNull
    private static final EntityDataAccessor<Integer> MOISTNESS;
    @NotNull
    private static final EntityDataAccessor<Integer> FISH_SIZE;
    @NotNull
    private static final EntityDataAccessor<Integer> HUNGER;
    @NotNull
    private static final EntityDataAccessor<Boolean> ATTEMPT_ATTACK;
    @NotNull
    private static final RawAnimation FLOP_ANIMATION;
    public static final int MAX_HUNGER = 2400;
    @NotNull
    public static final String HUNGER_KEY = "Hunger";
    @NotNull
    public static final String MOISTNESS_KEY = "Moistness";
    @NotNull
    public static final String FISH_SIZE_KEY = "FishSize";

    public HybridAquaticFishEntity(@NotNull EntityType<? extends HybridAquaticFishEntity> entityType, @NotNull Level world, @NotNull List<TagKey<EntityType<?>>> prey, @NotNull List<TagKey<EntityType<?>>> predator) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        Intrinsics.checkNotNullParameter(predator, (String)"predator");
        super(entityType, world);
        this.prey = prey;
        this.predator = predator;
        this.factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)((GeoAnimatable)this));
        SoundEvent soundEvent = SoundEvents.PUFFER_FISH_FLOP;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"PUFFER_FISH_FLOP");
        this.flopSound = soundEvent;
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.moveControl = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 85, 5, 0.02f, 0.1f, false);
        this.lookControl = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    @NotNull
    public List<TagKey<EntityType<?>>> getPrey() {
        return this.prey;
    }

    @NotNull
    public List<TagKey<EntityType<?>>> getPredator() {
        return this.predator;
    }

    public final float getPrevRoll() {
        return this.prevRoll;
    }

    public final void setPrevRoll(float f) {
        this.prevRoll = f;
    }

    public final float getCurrentRoll() {
        return this.currentRoll;
    }

    public final void setCurrentRoll(float f) {
        this.currentRoll = f;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FishAttackGoal(this, 1.1, true));
        this.goalSelector.addGoal(2, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, arg_0 -> HybridAquaticFishEntity.registerGoals$lambda$0(this, arg_0)));
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(MOISTNESS, (Object)this.getMaxMoistness());
        builder.define(FISH_SIZE, (Object)0);
        builder.define(ATTEMPT_ATTACK, (Object)false);
        builder.define(HUNGER, (Object)2400);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        this.setSize(this.random.nextIntBetweenInclusive(this.getMinSize(), this.getMaxSize()));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void tick() {
        super.tick();
        this.prevRoll = this.currentRoll;
        if (this.isUnderWater()) {
            this.setMoistness(this.getMaxMoistness());
        } else {
            this.setMoistness(this.getMoistness() - 1);
            if (this.getMoistness() <= -20) {
                this.setMoistness(0);
                this.hurt(this.damageSources().dryOut(), 2.0f);
                this.setXRot(0.0f);
                this.setYRot(0.0f);
                this.currentRoll = Mth.lerp((float)0.2f, (float)this.currentRoll, (float)0.0f);
            }
        }
        if (this.getHunger() > 0) {
            this.setHunger(this.getHunger() - 1);
        }
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(travelVector);
        }
    }

    public void aiStep() {
        if (this.shouldFlopOnLand() && !this.isInWater() && this.onGround() && this.verticalCollision) {
            this.setDeltaMovement(this.getDeltaMovement().add((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.05f)));
            this.setOnGround(false);
            this.hasImpulse = true;
            this.playSound(this.getFlopSound(), this.getSoundVolume(), this.getVoicePitch());
        }
        this.prevRoll = this.currentRoll;
        float targetRoll = RangesKt.coerceIn((float)((this.getYRot() - this.yRotO) * 0.1f), (float)-0.45f, (float)0.45f);
        targetRoll = -targetRoll;
        this.currentRoll += (targetRoll - this.currentRoll) * 0.05f;
        this.updateSwingTime();
        super.aiStep();
    }

    protected void handleAirSupply(int air) {
    }

    private final int getMaxMoistness() {
        return 600;
    }

    public boolean shouldFlopOnLand() {
        return true;
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.addAdditionalSaveData(nbt);
        nbt.putInt(MOISTNESS_KEY, this.getMoistness());
        nbt.putInt(FISH_SIZE_KEY, this.getSize());
        nbt.putInt(HUNGER_KEY, this.getHunger());
        nbt.putBoolean("FromFishingNet", this.fromFishingNet);
    }

    public final boolean getFromFishingNet() {
        return this.fromFishingNet;
    }

    public final void setFromFishingNet(boolean bl) {
        this.fromFishingNet = bl;
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        super.readAdditionalSaveData(nbt);
        this.setMoistness(nbt.getInt(MOISTNESS_KEY));
        this.setSize(nbt.getInt(FISH_SIZE_KEY));
        this.setHunger(nbt.getInt(HUNGER_KEY));
        this.fromFishingNet = nbt.getBoolean("FromFishingNet");
    }

    public boolean removeWhenFarAway(double distanceSquared) {
        return !this.fromFishingNet && !this.hasCustomName();
    }

    @NotNull
    public SoundEvent getFlopSound() {
        return this.flopSound;
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.COD_HURT;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"COD_HURT");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.COD_DEATH;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"COD_DEATH");
        return soundEvent;
    }

    protected void dropFromLootTable(@NotNull DamageSource source, boolean causedByPlayer) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Entity attacker = source.getDirectEntity();
        if (!(attacker instanceof HybridAquaticFishEntity || attacker instanceof HybridAquaticSharkEntity || attacker instanceof HybridAquaticCephalopodEntity || attacker instanceof HybridAquaticMammalEntity)) {
            super.dropFromLootTable(source, causedByPlayer);
        }
    }

    private final int getHandSwingDuration() {
        return 40;
    }

    protected void updateSwingTime() {
        int i = this.getHandSwingDuration();
        if (this.swinging) {
            ++this.swingTime;
            if (this.swingTime >= i) {
                this.swingTime = 0;
                this.swinging = false;
            }
        } else {
            this.swingTime = 0;
        }
        this.attackAnim = (float)this.swingTime / (float)i;
    }

    public float getAttackAnim(float tickDelta) {
        float f = this.attackAnim - this.oAttackAnim;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.oAttackAnim + f * tickDelta;
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (super.doHurtTarget(target)) {
            this.playSound(SoundEvents.FOX_BITE, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public final int getMoistness() {
        Object object = this.entityData.get(MOISTNESS);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setMoistness(int moistness) {
        this.entityData.set(MOISTNESS, (Object)moistness);
    }

    public final int getSize() {
        Object object = this.entityData.get(FISH_SIZE);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setSize(int size) {
        this.entityData.set(FISH_SIZE, (Object)size);
    }

    public final int getHunger() {
        Object object = this.entityData.get(HUNGER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).intValue();
    }

    public final void setHunger(int hunger) {
        this.entityData.set(HUNGER, (Object)hunger);
    }

    protected boolean hasSelfControl() {
        return true;
    }

    protected int getMinSize() {
        return -5;
    }

    protected int getMaxSize() {
        return 5;
    }

    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Fish Controller", 4, arg_0 -> HybridAquaticFishEntity.registerControllers$lambda$0(this, arg_0)));
    }

    @NotNull
    public AnimatableInstanceCache getAnimatableInstanceCache() {
        AnimatableInstanceCache animatableInstanceCache = this.factory;
        Intrinsics.checkNotNullExpressionValue((Object)animatableInstanceCache, (String)"factory");
        return animatableInstanceCache;
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return (PathNavigation)new WaterBoundPathNavigation((Mob)this, level);
    }

    public int getMaxHeadXRot() {
        return 5;
    }

    public int getMaxHeadYRot() {
        return 1;
    }

    private static final boolean registerGoals$lambda$0(HybridAquaticFishEntity this$0, LivingEntity entity) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Iterable $this$any$iv = this$0.getPrey();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TagKey preyType = (TagKey)element$iv;
                    boolean bl2 = false;
                    if (!entity.getType().is(preyType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl && this$0.getHunger() < 600;
    }

    private static final PlayState registerControllers$lambda$0(HybridAquaticFishEntity this$0, AnimationState state) {
        return this$0.isInWater() && state.isMoving() ? state.setAndContinue(DefaultAnimations.SWIM) : (this$0.isInWater() && this$0.isSprinting() && state.isMoving() ? state.setAndContinue(DefaultAnimations.RUN) : (this$0.isInWater() && !state.isMoving() ? state.setAndContinue(DefaultAnimations.IDLE) : (this$0.getMoistness() < 595 ? state.setAndContinue(FLOP_ANIMATION) : state.setAndContinue(DefaultAnimations.IDLE))));
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        MOISTNESS = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.defineId(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(...)");
        FISH_SIZE = entityDataAccessor2;
        EntityDataAccessor entityDataAccessor3 = SynchedEntityData.defineId(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor3, (String)"defineId(...)");
        HUNGER = entityDataAccessor3;
        EntityDataAccessor entityDataAccessor4 = SynchedEntityData.defineId(HybridAquaticFishEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor4, (String)"defineId(...)");
        ATTEMPT_ATTACK = entityDataAccessor4;
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.flop");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        FLOP_ANIMATION = rawAnimation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0019\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J6\u0010%\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J6\u0010&\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J6\u0010'\u001a\u00020\u000e2\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0016X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity$Companion;", "", "<init>", "()V", "MOISTNESS", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getMOISTNESS", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "FISH_SIZE", "getFISH_SIZE", "HUNGER", "getHUNGER", "ATTEMPT_ATTACK", "", "getATTEMPT_ATTACK", "FLOP_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getFLOP_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "MAX_HUNGER", "HUNGER_KEY", "", "MOISTNESS_KEY", "FISH_SIZE_KEY", "canShallowSpawn", "type", "Lnet/minecraft/world/entity/EntityType;", "Lnet/minecraft/world/entity/animal/WaterAnimal;", "world", "Lnet/minecraft/world/level/ServerLevelAccessor;", "reason", "Lnet/minecraft/world/entity/MobSpawnType;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "canSpawn", "canNightSpawn", "canDeepSpawn", "getScaleAdjustment", "", "fish", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "adjustment", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMOISTNESS() {
            return MOISTNESS;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getFISH_SIZE() {
            return FISH_SIZE;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getHUNGER() {
            return HUNGER;
        }

        @NotNull
        public final EntityDataAccessor<Boolean> getATTEMPT_ATTACK() {
            return ATTEMPT_ATTACK;
        }

        @NotNull
        public final RawAnimation getFLOP_ANIMATION() {
            return FLOP_ANIMATION;
        }

        public final boolean canShallowSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int n = world.getSeaLevel() - 8;
            int n2 = world.getSeaLevel() - 1;
            int n3 = pos.getY();
            return (n <= n3 ? n3 < n2 : false) && world.isWaterAt(pos) && world.canSeeSkyFromBelowWater(pos);
        }

        public final boolean canSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int n = world.getSeaLevel() - 24;
            int n2 = world.getSeaLevel() - 12;
            int n3 = pos.getY();
            return (n <= n3 ? n3 <= n2 : false) && world.isWaterAt(pos) && world.canSeeSkyFromBelowWater(pos);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canNightSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            if (world.getLevel().isDay()) return false;
            int n = world.getSeaLevel() - 24;
            int n2 = world.getSeaLevel() - 12;
            int n3 = pos.getY();
            if (n > n3) return false;
            if (n3 > n2) return false;
            boolean bl = true;
            if (!bl) return false;
            if (!world.isWaterAt(pos)) return false;
            if (!world.canSeeSkyFromBelowWater(pos)) return false;
            return true;
        }

        public final boolean canDeepSpawn(@NotNull EntityType<? extends WaterAnimal> type, @NotNull ServerLevelAccessor world, @NotNull MobSpawnType reason, @NotNull BlockPos pos, @NotNull RandomSource random) {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            int n = world.getSeaLevel() - 128;
            int n2 = world.getSeaLevel() - 48;
            int n3 = pos.getY();
            return (n <= n3 ? n3 <= n2 : false) && world.isWaterAt(pos);
        }

        public final float getScaleAdjustment(@NotNull HybridAquaticFishEntity fish, float adjustment) {
            Intrinsics.checkNotNullParameter((Object)((Object)fish), (String)"fish");
            return 1.0f + (float)fish.getSize() * adjustment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

