/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.fish;

import dev.hybridlabs.aquatic.entity.ai.goal.FishFollowGroupLeaderGoal;
import dev.hybridlabs.aquatic.entity.fish.HybridAquaticFishEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.List;
import java.util.stream.Stream;
import javax.xml.crypto.Data;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u00012Be\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0016\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\b0\u0007\u0012\u0016\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\b0\u0007\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0000\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0014J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\fH\u0016J\b\u0010\u0019\u001a\u00020\fH\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0006\u0010\u001c\u001a\u00020\u001bJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0000J\u0006\u0010\u001f\u001a\u00020\u0017J\b\u0010 \u001a\u00020\u0017H\u0002J\b\u0010!\u001a\u00020\u0017H\u0002J\u0006\u0010\"\u001a\u00020\u001bJ\b\u0010#\u001a\u00020\u0017H\u0016J\u0006\u0010$\u001a\u00020\u001bJ\u0006\u0010%\u001a\u00020\u001bJ\u0006\u0010&\u001a\u00020\u0017J\u0018\u0010'\u001a\u00020\u00172\u0010\u0010(\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00000)J,\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010\u0004\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u00010+H\u0016R$\u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R$\u0010\t\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticFishEntity;", "type", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "prey", "", "Lnet/minecraft/tags/TagKey;", "predator", "leader", "groupSize", "", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;Ljava/util/List;Ljava/util/List;Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;I)V", "getPrey", "()Ljava/util/List;", "getPredator", "nextStep", "", "getVariant", "", "registerGoals", "", "getMaxSpawnClusterSize", "getMaxGroupSize", "hasSelfControl", "", "hasLeader", "joinGroupOf", "groupLeader", "leaveGroup", "increaseGroupSize", "decreaseGroupSize", "canHaveMoreFishInGroup", "tick", "hasOtherFishInGroup", "isCloseEnoughToLeader", "moveTowardLeader", "pullInOtherFish", "fish", "Ljava/util/stream/Stream;", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "FishData", "hybrid-aquatic-neoforge-1.21.1"})
public class HybridAquaticSchoolingFishEntity
extends HybridAquaticFishEntity {
    @NotNull
    private final List<TagKey<EntityType<?>>> prey;
    @NotNull
    private final List<TagKey<EntityType<?>>> predator;
    @Nullable
    private HybridAquaticSchoolingFishEntity leader;
    private int groupSize;

    public HybridAquaticSchoolingFishEntity(@NotNull EntityType<? extends HybridAquaticFishEntity> type, @NotNull Level world, @NotNull List<TagKey<EntityType<?>>> prey, @NotNull List<TagKey<EntityType<?>>> predator, @Nullable HybridAquaticSchoolingFishEntity leader, int groupSize) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(prey, (String)"prey");
        Intrinsics.checkNotNullParameter(predator, (String)"predator");
        super(type, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()));
        this.prey = prey;
        this.predator = predator;
        this.leader = leader;
        this.groupSize = groupSize;
    }

    public /* synthetic */ HybridAquaticSchoolingFishEntity(EntityType entityType, Level level, List list, List list2, HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            hybridAquaticSchoolingFishEntity = null;
        }
        if ((n2 & 0x20) != 0) {
            n = 1;
        }
        this((EntityType<? extends HybridAquaticFishEntity>)entityType, level, list, list2, hybridAquaticSchoolingFishEntity, n);
    }

    @Override
    @NotNull
    public List<TagKey<EntityType<?>>> getPrey() {
        return this.prey;
    }

    @Override
    @NotNull
    public List<TagKey<EntityType<?>>> getPredator() {
        return this.predator;
    }

    protected float nextStep() {
        return Float.MAX_VALUE;
    }

    @Nullable
    public Object getVariant() {
        return this instanceof VariantHolder ? ((VariantHolder)this).getVariant() : null;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FishFollowGroupLeaderGoal(this));
    }

    public int getMaxSpawnClusterSize() {
        return this.getMaxGroupSize();
    }

    public int getMaxGroupSize() {
        return super.getMaxSpawnClusterSize();
    }

    @Override
    protected boolean hasSelfControl() {
        return !this.hasLeader();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean hasLeader() {
        if (this.leader == null) return false;
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = this.leader;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        if (!hybridAquaticSchoolingFishEntity.isAlive()) return false;
        return true;
    }

    @NotNull
    public final HybridAquaticSchoolingFishEntity joinGroupOf(@NotNull HybridAquaticSchoolingFishEntity groupLeader) {
        Intrinsics.checkNotNullParameter((Object)((Object)groupLeader), (String)"groupLeader");
        if (!Intrinsics.areEqual((Object)this.getVariant(), (Object)groupLeader.getVariant())) {
            return this;
        }
        if (groupLeader.groupSize >= groupLeader.getMaxGroupSize()) {
            return this;
        }
        this.leader = groupLeader;
        groupLeader.increaseGroupSize();
        return groupLeader;
    }

    public final void leaveGroup() {
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = this.leader;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        hybridAquaticSchoolingFishEntity.decreaseGroupSize();
        this.leader = null;
    }

    private final void increaseGroupSize() {
        ++this.groupSize;
    }

    private final void decreaseGroupSize() {
        this.groupSize += -1;
    }

    public final boolean canHaveMoreFishInGroup() {
        return this.hasOtherFishInGroup() && this.groupSize < this.getMaxGroupSize();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.hasOtherFishInGroup() && this.level().random.nextInt(200) == 1) {
            List list = this.level().getEntitiesOfClass(((Object)((Object)this)).getClass(), this.getBoundingBox().inflate(8.0, 8.0, 8.0));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
            List list2 = list;
            if (list2.size() <= 1) {
                this.groupSize = 1;
            }
        }
    }

    public final boolean hasOtherFishInGroup() {
        return this.groupSize > 1;
    }

    public final boolean isCloseEnoughToLeader() {
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = this.leader;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        return this.distanceToSqr((Entity)hybridAquaticSchoolingFishEntity) <= 121.0;
    }

    public final void moveTowardLeader() {
        if (this.hasLeader()) {
            PathNavigation pathNavigation = this.getNavigation();
            HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = this.leader;
            Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
            pathNavigation.moveTo((Entity)hybridAquaticSchoolingFishEntity, 1.0);
        }
    }

    public final void pullInOtherFish(@NotNull Stream<? extends HybridAquaticSchoolingFishEntity> fish) {
        Intrinsics.checkNotNullParameter(fish, (String)"fish");
        Object selfVariant = this.getVariant();
        fish.filter(arg_0 -> HybridAquaticSchoolingFishEntity.pullInOtherFish$lambda$1(arg_0 -> HybridAquaticSchoolingFishEntity.pullInOtherFish$lambda$0(this, selfVariant, arg_0), arg_0)).limit(this.getMaxGroupSize() - this.groupSize).forEach(arg_0 -> HybridAquaticSchoolingFishEntity.pullInOtherFish$lambda$3(arg_0 -> HybridAquaticSchoolingFishEntity.pullInOtherFish$lambda$2(this, arg_0), arg_0));
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        SpawnGroupData entityData2 = entityData;
        this.setXRot(0.0f);
        super.finalizeSpawn(world, difficulty, spawnReason, entityData2);
        if (entityData2 == null) {
            entityData2 = new FishData(this);
        } else {
            HybridAquaticSchoolingFishEntity leader = ((FishData)entityData2).getLeader();
            if (Intrinsics.areEqual((Object)this.getVariant(), (Object)leader.getVariant())) {
                this.joinGroupOf(leader);
            }
        }
        return entityData2;
    }

    private static final boolean pullInOtherFish$lambda$0(HybridAquaticSchoolingFishEntity this$0, Object $selfVariant, HybridAquaticSchoolingFishEntity fishx) {
        return fishx != null && fishx != this$0 && Intrinsics.areEqual((Object)fishx.getVariant(), (Object)$selfVariant) && this$0.groupSize < this$0.getMaxGroupSize();
    }

    private static final boolean pullInOtherFish$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit pullInOtherFish$lambda$2(HybridAquaticSchoolingFishEntity this$0, HybridAquaticSchoolingFishEntity fishx) {
        HybridAquaticSchoolingFishEntity hybridAquaticSchoolingFishEntity = fishx;
        Intrinsics.checkNotNull((Object)((Object)hybridAquaticSchoolingFishEntity));
        hybridAquaticSchoolingFishEntity.joinGroupOf(this$0);
        return Unit.INSTANCE;
    }

    private static final void pullInOtherFish$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity$FishData;", "Ljavax/xml/crypto/Data;", "Lnet/minecraft/world/entity/SpawnGroupData;", "leader", "Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "<init>", "(Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;)V", "getLeader", "()Ldev/hybridlabs/aquatic/entity/fish/HybridAquaticSchoolingFishEntity;", "hybrid-aquatic-neoforge-1.21.1"})
    public static class FishData
    implements Data,
    SpawnGroupData {
        @NotNull
        private final HybridAquaticSchoolingFishEntity leader;

        public FishData(@NotNull HybridAquaticSchoolingFishEntity leader) {
            Intrinsics.checkNotNullParameter((Object)((Object)leader), (String)"leader");
            this.leader = leader;
        }

        @NotNull
        public final HybridAquaticSchoolingFishEntity getLeader() {
            return this.leader;
        }
    }
}

