/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.miniboss;

import dev.hybridlabs.aquatic.entity.miniboss.HybridAquaticMinionEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0014J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\b\u0010\u0018\u001a\u00020\u0015H\u0014\u00a8\u0006\u001a"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarcinomaEntity;", "Ldev/hybridlabs/aquatic/entity/miniboss/HybridAquaticMinionEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "createNavigation", "Lnet/minecraft/world/entity/ai/navigation/PathNavigation;", "level", "registerControllers", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "travel", "travelVector", "Lnet/minecraft/world/phys/Vec3;", "tick", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "getDeathSound", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class KarcinomaEntity
extends HybridAquaticMinionEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final RawAnimation FLOP_ANIMATION;

    public KarcinomaEntity(@NotNull EntityType<? extends HybridAquaticMinionEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = (MoveControl)new SmoothSwimmingMoveControl((Mob)this, 85, 5, 0.02f, 0.1f, true);
        this.lookControl = (LookControl)new SmoothSwimmingLookControl((Mob)this, 10);
        this.navigation = (PathNavigation)new WaterBoundPathNavigation((Mob)this, world);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 2));
    }

    @NotNull
    protected PathNavigation createNavigation(@NotNull Level level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return (PathNavigation)new WaterBoundPathNavigation((Mob)this, level);
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(DefaultAnimations.genericAttackAnimation((LivingEntity)((LivingEntity)this), (RawAnimation)DefaultAnimations.ATTACK_SWING));
        controllers.add(new AnimationController((GeoAnimatable)this, "Swim/Run/Idle", 4, arg_0 -> KarcinomaEntity.registerControllers$lambda$0(this, arg_0)));
    }

    public void travel(@NotNull Vec3 travelVector) {
        Intrinsics.checkNotNullParameter((Object)travelVector, (String)"travelVector");
        if (this.isEffectiveAi() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), travelVector);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
            if (this.getTarget() == null) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.005, 0.0));
            }
        } else {
            super.travel(travelVector);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.isInWater()) {
            this.setXRot(0.0f);
            this.setYRot(0.0f);
        }
    }

    @NotNull
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_CRACK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_CRACK");
        return soundEvent;
    }

    @NotNull
    protected SoundEvent getDeathSound() {
        SoundEvent soundEvent = SoundEvents.TURTLE_EGG_BREAK;
        Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"TURTLE_EGG_BREAK");
        return soundEvent;
    }

    private static final PlayState registerControllers$lambda$0(KarcinomaEntity this$0, AnimationState state) {
        return this$0.isInWater() && this$0.isSprinting() && state.isMoving() ? state.setAndContinue(DefaultAnimations.RUN) : (this$0.isInWater() && state.isMoving() ? state.setAndContinue(DefaultAnimations.SWIM) : (this$0.isInWater() && !state.isMoving() ? state.setAndContinue(DefaultAnimations.IDLE) : state.setAndContinue(FLOP_ANIMATION)));
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.flop");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        FLOP_ANIMATION = rawAnimation;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Ldev/hybridlabs/aquatic/entity/miniboss/KarcinomaEntity$Companion;", "", "<init>", "()V", "FLOP_ANIMATION", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getFLOP_ANIMATION", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RawAnimation getFLOP_ANIMATION() {
            return FLOP_ANIMATION;
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = Monster.createLivingAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 1.0).add(Attributes.ATTACK_DAMAGE, 4.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 24.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

