/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.entity.shark;

import com.mojang.serialization.Codec;
import dev.hybridlabs.aquatic.entity.feature.OverlayTextureFeature;
import dev.hybridlabs.aquatic.entity.shark.HybridAquaticSharkEntity;
import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Collection;
import java.util.function.IntFunction;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J,\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0014J\u0010\u0010$\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u00198B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity;", "Ldev/hybridlabs/aquatic/entity/shark/HybridAquaticSharkEntity;", "Ldev/hybridlabs/aquatic/entity/feature/OverlayTextureFeature;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "isFeeding", "", "registerControllers", "", "controllers", "Lsoftware/bernie/geckolib/animation/AnimatableManager$ControllerRegistrar;", "tick", "finalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnReason", "Lnet/minecraft/world/entity/MobSpawnType;", "entityData", "value", "Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures;", "overlayTexture", "getOverlayTexture", "()Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures;", "setOverlayTexture", "(Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures;)V", "getOverlayTextureName", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "addAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class WhaleSharkEntity
extends HybridAquaticSharkEntity
implements OverlayTextureFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isFeeding;
    @NotNull
    private static final RawAnimation MOUTH_OPEN;
    @NotNull
    private static final RawAnimation MOUTH_CLOSED;
    @NotNull
    private static final EntityDataAccessor<Integer> OverlayTexture;

    public WhaleSharkEntity(@NotNull EntityType<? extends WhaleSharkEntity> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world, CollectionsKt.listOf(HybridAquaticEntityTags.INSTANCE.getNONE()), true, false);
    }

    @Override
    public void registerControllers(@NotNull AnimatableManager.ControllerRegistrar controllers) {
        Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
        controllers.add(new AnimationController((GeoAnimatable)this, "Open/Closed", 0, arg_0 -> WhaleSharkEntity.registerControllers$lambda$0(this, arg_0)));
        super.registerControllers(controllers);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getHunger() < 600) {
            this.isFeeding = true;
        }
        if (this.isFeeding) {
            this.setHunger(this.getHunger() + 10);
            if (this.getHunger() >= 2400) {
                this.setHunger(2400);
                this.isFeeding = false;
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor world, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnReason, (String)"spawnReason");
        int overlayID = world.getRandom().nextIntBetweenInclusive(0, Companion.OverlayTextures.getEntries().size() - 1);
        this.setOverlayTexture(Companion.OverlayTextures.Companion.byId(overlayID));
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    private final Companion.OverlayTextures getOverlayTexture() {
        Object object = this.entityData.get(OverlayTexture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OverlayTextures.Companion.byId(((Number)object).intValue());
    }

    private final void setOverlayTexture(Companion.OverlayTextures value) {
        this.entityData.set(OverlayTexture, (Object)value.getId());
    }

    @Override
    @NotNull
    public String getOverlayTextureName() {
        Object object = this.entityData.get(OverlayTexture);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return Companion.OverlayTextures.Companion.byId(((Number)object).intValue()).getSerializedName();
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        builder.define(OverlayTexture, (Object)0);
        super.defineSynchedData(builder);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putInt("texture_overlay", this.getOverlayTexture().getId());
        super.addAdditionalSaveData(nbt);
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (nbt.contains("texture_overlay")) {
            this.setOverlayTexture(Companion.OverlayTextures.Companion.byId(nbt.getInt("texture_overlay")));
        }
        super.readAdditionalSaveData(nbt);
    }

    private static final PlayState registerControllers$lambda$0(WhaleSharkEntity this$0, AnimationState state) {
        RawAnimation animation = this$0.isFeeding ? MOUTH_OPEN : MOUTH_CLOSED;
        return state.setAndContinue(animation);
    }

    static {
        RawAnimation rawAnimation = RawAnimation.begin().thenPlay("misc.mouth_open");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation, (String)"thenPlay(...)");
        MOUTH_OPEN = rawAnimation;
        RawAnimation rawAnimation2 = RawAnimation.begin().thenPlay("misc.mouth_closed");
        Intrinsics.checkNotNullExpressionValue((Object)rawAnimation2, (String)"thenPlay(...)");
        MOUTH_CLOSED = rawAnimation2;
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(WhaleSharkEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        OverlayTexture = entityDataAccessor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion;", "", "<init>", "()V", "createMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "MOUTH_OPEN", "Lsoftware/bernie/geckolib/animation/RawAnimation;", "getMOUTH_OPEN", "()Lsoftware/bernie/geckolib/animation/RawAnimation;", "MOUTH_CLOSED", "getMOUTH_CLOSED", "OverlayTexture", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getOverlayTexture", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "OverlayTextures", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createMobAttributes() {
            AttributeSupplier.Builder builder = WaterAnimal.createLivingAttributes().add(Attributes.MAX_HEALTH, 60.0).add(Attributes.MOVEMENT_SPEED, 0.75).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.FOLLOW_RANGE, 16.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        @NotNull
        public final RawAnimation getMOUTH_OPEN() {
            return MOUTH_OPEN;
        }

        @NotNull
        public final RawAnimation getMOUTH_CLOSED() {
            return MOUTH_CLOSED;
        }

        @NotNull
        public final EntityDataAccessor<Integer> getOverlayTexture() {
            return OverlayTexture;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u0000 \u00102\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0010B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\u0006H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u0011"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures;", "Lnet/minecraft/util/StringRepresentable;", "", "id", "", "key", "", "<init>", "(Ljava/lang/String;IILjava/lang/String;)V", "getId", "()I", "getKey", "()Ljava/lang/String;", "SPOTS", "SMALL_SPOTS", "getSerializedName", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
        @SourceDebugExtension(value={"SMAP\nWhaleSharkEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhaleSharkEntity.kt\ndev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,136:1\n37#2,2:137\n37#2,2:139\n*S KotlinDebug\n*F\n+ 1 WhaleSharkEntity.kt\ndev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures\n*L\n85#1:137,2\n88#1:139,2\n*E\n"})
        public static final class OverlayTextures
        extends Enum<OverlayTextures>
        implements StringRepresentable {
            @NotNull
            public static final Companion Companion;
            private final int id;
            @NotNull
            private final String key;
            @NotNull
            private static final Codec<OverlayTextures> CODEC;
            @NotNull
            private static final IntFunction<OverlayTextures> BY_ID;
            public static final /* enum */ OverlayTextures SPOTS;
            public static final /* enum */ OverlayTextures SMALL_SPOTS;
            private static final /* synthetic */ OverlayTextures[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private OverlayTextures(int id, String key) {
                this.id = id;
                this.key = key;
            }

            public final int getId() {
                return this.id;
            }

            @NotNull
            public final String getKey() {
                return this.key;
            }

            @NotNull
            public String getSerializedName() {
                return this.key;
            }

            public static OverlayTextures[] values() {
                return (OverlayTextures[])$VALUES.clone();
            }

            public static OverlayTextures valueOf(String value) {
                return Enum.valueOf(OverlayTextures.class, value);
            }

            @NotNull
            public static EnumEntries<OverlayTextures> getEntries() {
                return $ENTRIES;
            }

            private static final OverlayTextures[] CODEC$lambda$0() {
                Collection $this$toTypedArray$iv = (Collection)OverlayTextures.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                return thisCollection$iv.toArray(new OverlayTextures[0]);
            }

            private static final int BY_ID$lambda$0(OverlayTextures overlayTex) {
                Intrinsics.checkNotNullParameter((Object)((Object)overlayTex), (String)"overlayTex");
                return overlayTex.id;
            }

            static {
                SPOTS = new OverlayTextures(0, "spots");
                SMALL_SPOTS = new OverlayTextures(1, "small_spots");
                $VALUES = overlayTexturesArray = new OverlayTextures[]{OverlayTextures.SPOTS, OverlayTextures.SMALL_SPOTS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
                StringRepresentable.EnumCodec enumCodec = StringRepresentable.fromEnum(OverlayTextures::CODEC$lambda$0);
                Intrinsics.checkNotNullExpressionValue((Object)enumCodec, (String)"fromEnum(...)");
                CODEC = (Codec)enumCodec;
                Collection $this$toTypedArray$iv = (Collection)OverlayTextures.getEntries();
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                IntFunction intFunction = ByIdMap.continuous(OverlayTextures::BY_ID$lambda$0, (Object[])thisCollection$iv.toArray(new OverlayTextures[0]), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
                Intrinsics.checkNotNullExpressionValue((Object)intFunction, (String)"continuous(...)");
                BY_ID = intFunction;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures$Companion;", "", "<init>", "()V", "CODEC", "Lcom/mojang/serialization/Codec;", "Ldev/hybridlabs/aquatic/entity/shark/WhaleSharkEntity$Companion$OverlayTextures;", "getCODEC", "()Lcom/mojang/serialization/Codec;", "BY_ID", "Ljava/util/function/IntFunction;", "getBY_ID", "()Ljava/util/function/IntFunction;", "byId", "id", "", "hybrid-aquatic-neoforge-1.21.1"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Codec<OverlayTextures> getCODEC() {
                    return CODEC;
                }

                @NotNull
                public final IntFunction<OverlayTextures> getBY_ID() {
                    return BY_ID;
                }

                @NotNull
                public final OverlayTextures byId(int id) {
                    OverlayTextures overlayTextures = this.getBY_ID().apply(id);
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)overlayTextures), (String)"apply(...)");
                    return overlayTextures;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

