/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.item;

import dev.hybridlabs.aquatic.tag.HybridAquaticEntityTags;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0016"}, d2={"Ldev/hybridlabs/aquatic/item/FishingNetItem;", "Lnet/minecraft/world/item/Item;", "settings", "Lnet/minecraft/world/item/Item$Properties;", "<init>", "(Lnet/minecraft/world/item/Item$Properties;)V", "interactLivingEntity", "Lnet/minecraft/world/InteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "user", "Lnet/minecraft/world/entity/player/Player;", "entity", "Lnet/minecraft/world/entity/LivingEntity;", "hand", "Lnet/minecraft/world/InteractionHand;", "use", "Lnet/minecraft/world/InteractionResultHolder;", "level", "Lnet/minecraft/world/level/Level;", "player", "Companion", "hybrid-aquatic-neoforge-1.21.1"})
public final class FishingNetItem
extends Item {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ENTITY_KEY = "storedEntity";

    public FishingNetItem(@NotNull Item.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    public InteractionResult interactLivingEntity(@NotNull ItemStack stack, @NotNull Player user, @NotNull LivingEntity entity, @NotNull InteractionHand hand) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        boolean validFishForNet = entity.getType().is(HybridAquaticEntityTags.INSTANCE.getCAN_USE_FISHING_NET_ON());
        if (!Companion.alreadyHasFish(stack) && validFishForNet) {
            Companion.writeEntityToNet((Entity)entity, user, hand);
            entity.remove(Entity.RemovalReason.DISCARDED);
            return InteractionResult.SUCCESS;
        }
        InteractionResult interactionResult = super.interactLivingEntity(stack, user, entity, hand);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"interactLivingEntity(...)");
        return interactionResult;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        Optional<EntityType<?>> optionalEntity;
        CustomData customData;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide && (customData = (CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA)) != null && (optionalEntity = Companion.getEntityFromNBT(customData)).isPresent()) {
            BlockHitResult hitResult = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (hitResult.getType() != HitResult.Type.BLOCK) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
                return interactionResultHolder;
            }
            BlockPos pos = hitResult.getBlockPos();
            Direction clickedFace = hitResult.getDirection();
            BlockPos spawnPos = pos.relative(clickedFace);
            FluidState fluidState = level.getFluidState(pos);
            if (fluidState.is((Fluid)Fluids.WATER)) {
                spawnPos = pos;
            }
            EntityType<?> entityType = optionalEntity.get();
            Intrinsics.checkNotNullExpressionValue(entityType, (String)"get(...)");
            EntityType<?> entityType2 = entityType;
            Entity entity = entityType2.create(level);
            if (entity == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            Entity entity2 = entity;
            CustomData customData2 = (CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA);
            if (customData2 == null) {
                InteractionResultHolder interactionResultHolder = InteractionResultHolder.fail((Object)stack);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"fail(...)");
                return interactionResultHolder;
            }
            CustomData customData3 = customData2;
            CompoundTag tag = customData3.copyTag();
            CompoundTag entityData = tag.getCompound(ENTITY_KEY);
            entity2.load(entityData);
            entity2.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY() + 0.1, (double)spawnPos.getZ() + 0.5, level.random.nextFloat() * 360.0f, 0.0f);
            ((ServerLevel)level).addFreshEntity(entity2);
            stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, FishingNetItem::use$lambda$0);
            InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
            return interactionResultHolder;
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.pass((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"pass(...)");
        return interactionResultHolder;
    }

    private static final CustomData use$lambda$0(CustomData data) {
        return data.update(FishingNetItem::use$lambda$0$0);
    }

    private static final void use$lambda$0$0(CompoundTag compoundTag) {
        compoundTag.remove(ENTITY_KEY);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/hybridlabs/aquatic/item/FishingNetItem$Companion;", "", "<init>", "()V", "ENTITY_KEY", "", "writeEntityToNet", "", "entity", "Lnet/minecraft/world/entity/Entity;", "user", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "getEntityFromNBT", "Ljava/util/Optional;", "Lnet/minecraft/world/entity/EntityType;", "customData", "Lnet/minecraft/world/item/component/CustomData;", "alreadyHasFish", "", "stack", "Lnet/minecraft/world/item/ItemStack;", "hybrid-aquatic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeEntityToNet(@NotNull Entity entity, @NotNull Player user, @NotNull InteractionHand hand) {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)user, (String)"user");
            Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
            CompoundTag entityCompound = new CompoundTag();
            entity.save(entityCompound);
            entityCompound.putBoolean("PersistenceRequired", true);
            entityCompound.putBoolean("FromFishingNet", true);
            ItemStack itemStack = user.getItemInHand(hand);
            itemStack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, arg_0 -> Companion.writeEntityToNet$lambda$0(entityCompound, arg_0));
        }

        @NotNull
        public final Optional<EntityType<?>> getEntityFromNBT(@NotNull CustomData customData) {
            Intrinsics.checkNotNullParameter((Object)customData, (String)"customData");
            CompoundTag nbt = customData.copyTag();
            CompoundTag storedNBT = nbt.getCompound(FishingNetItem.ENTITY_KEY);
            Optional optional = EntityType.by((CompoundTag)storedNBT);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"by(...)");
            return optional;
        }

        public final boolean alreadyHasFish(@NotNull ItemStack stack) {
            CustomData customData;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            CustomData customData2 = customData = (CustomData)stack.getComponents().get(DataComponents.CUSTOM_DATA);
            return customData2 != null ? customData2.contains(FishingNetItem.ENTITY_KEY) : false;
        }

        private static final CustomData writeEntityToNet$lambda$0(CompoundTag $entityCompound, CustomData data) {
            return data.update(arg_0 -> Companion.writeEntityToNet$lambda$0$0($entityCompound, arg_0));
        }

        private static final void writeEntityToNet$lambda$0$0(CompoundTag $entityCompound, CompoundTag compoundTag) {
            compoundTag.put(FishingNetItem.ENTITY_KEY, (Tag)$entityCompound);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

