/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.mixin;

import com.google.common.collect.ImmutableList;
import dev.hybridlabs.aquatic.CommonClass;
import dev.hybridlabs.aquatic.access.CustomPlayerEntityData;
import dev.hybridlabs.aquatic.effect.HybridAquaticMobEffects;
import dev.hybridlabs.aquatic.item.HybridAquaticItems;
import dev.hybridlabs.aquatic.item.HybridAquaticToolMaterials;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends Entity
implements CustomPlayerEntityData {
    @Unique
    private boolean isWearingDivingBoots;
    @Unique
    int coralRepairTick = 0;

    public PlayerEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract boolean isSwimming();

    @Inject(method={"isAffectedByFluids"}, at={@At(value="HEAD")}, cancellable=true)
    private void overrideShouldSwimInFluids(CallbackInfoReturnable<Boolean> ci) {
        if (this.isWearingDivingBoots && !this.isSwimming() && this.isUnderWater()) {
            ci.setReturnValue((Object)false);
        }
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void updateEquipment(CallbackInfo ci) {
        this.updateDivingHelmet();
        this.updateDivingBoots();
        this.updateTurtleChestplate();
        this.repairCoralTools();
    }

    @Unique
    private void updateDivingHelmet() {
        Player player = (Player)this;
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.HEAD);
        if (itemStack.is(HybridAquaticItems.INSTANCE.getDIVING_HELMET().get())) {
            if (!player.isEyeInFluid(FluidTags.WATER)) {
                player.addEffect(new MobEffectInstance(MobEffects.WATER_BREATHING, 600, 0, false, false, false));
            } else {
                player.addEffect(new MobEffectInstance(HybridAquaticMobEffects.INSTANCE.getCLARITY().asHolder(), 600, 0, false, false, false));
            }
        }
    }

    @Unique
    private void updateDivingBoots() {
        Player player = (Player)this;
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.FEET);
        this.isWearingDivingBoots = itemStack.is(HybridAquaticItems.INSTANCE.getDIVING_BOOTS().get());
        this.updateStepHeight();
    }

    @Unique
    private void updateTurtleChestplate() {
        Player player = (Player)this;
        ItemStack itemStack = player.getItemBySlot(EquipmentSlot.CHEST);
        if (itemStack.is(HybridAquaticItems.INSTANCE.getTURTLE_CHESTPLATE().get())) {
            player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 200, 0, false, false, true));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 200, 0, false, false, true));
        }
    }

    @Unique
    private void repairCoralTools() {
        Player player = (Player)this;
        Inventory inventory = player.getInventory();
        if (player.isEyeInFluid(FluidTags.WATER)) {
            if (this.coralRepairTick > 5) {
                ImmutableList combinedInventory = ImmutableList.of((Object)inventory.items, (Object)inventory.offhand);
                ArrayList<ItemStack> coralItems = new ArrayList<ItemStack>();
                for (List list : combinedInventory) {
                    for (ItemStack itemStack : list) {
                        TieredItem tool;
                        Item item = itemStack.getItem();
                        if (!(item instanceof TieredItem) || (tool = (TieredItem)item).getTier() != HybridAquaticToolMaterials.CORAL || !itemStack.isDamaged()) continue;
                        coralItems.add(itemStack);
                    }
                }
                if (!coralItems.isEmpty()) {
                    ItemStack item = (ItemStack)coralItems.get(player.getRandom().nextInt(coralItems.size()));
                    item.setDamageValue(item.getDamageValue() - 1);
                    inventory.setChanged();
                }
                this.coralRepairTick = 0;
            }
            ++this.coralRepairTick;
        }
    }

    @Unique
    private void updateStepHeight() {
        Player player;
        AttributeInstance stepHeight;
        LivingEntity entity = (LivingEntity)this;
        if (entity instanceof Player && (stepHeight = (player = (Player)entity).getAttribute(Attributes.STEP_HEIGHT)) != null) {
            if (this.isWearingDivingBoots && player.isUnderWater()) {
                stepHeight.addOrUpdateTransientModifier(CommonClass.DIVING_BOOTS_STEP_MODIFIER);
            } else {
                stepHeight.removeModifier(CommonClass.DIVING_BOOTS_STEP_MODIFIER);
            }
        }
    }
}

