/*
 * Decompiled with CFR 0.152.
 */
package dev.hybridlabs.aquatic.world.gen.feature;

import dev.hybridlabs.aquatic.tag.HybridAquaticBlockTags;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0013"}, d2={"Ldev/hybridlabs/aquatic/world/gen/feature/AnemoneFeature;", "Lnet/minecraft/world/level/levelgen/feature/Feature;", "Lnet/minecraft/world/level/levelgen/feature/configurations/NoneFeatureConfiguration;", "<init>", "()V", "place", "", "context", "Lnet/minecraft/world/level/levelgen/feature/FeaturePlaceContext;", "placeAnemoneAt", "level", "Lnet/minecraft/world/level/WorldGenLevel;", "pos", "Lnet/minecraft/core/BlockPos;", "random", "Lnet/minecraft/util/RandomSource;", "getRandomAnemoneState", "Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/minecraft/world/level/LevelAccessor;", "hybrid-aquatic-neoforge-1.21.1"})
public final class AnemoneFeature
extends Feature<NoneFeatureConfiguration> {
    public AnemoneFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        int placed = 0;
        int n = 16;
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            BlockPos pos = origin.offset(random.nextInt(6) - 3, random.nextInt(6) - 3, random.nextInt(6) - 3);
            Intrinsics.checkNotNull((Object)level);
            Intrinsics.checkNotNull((Object)pos);
            Intrinsics.checkNotNull((Object)random);
            if (!this.placeAnemoneAt(level, pos, random)) continue;
            ++placed;
        }
        return placed > 0;
    }

    private final boolean placeAnemoneAt(WorldGenLevel level, BlockPos pos, RandomSource random) {
        BlockState blockState = this.getRandomAnemoneState((LevelAccessor)level, random);
        if (blockState == null) {
            return false;
        }
        BlockState anemoneState = blockState;
        Direction[] directionArray = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
        Direction[] horizontals = directionArray;
        for (Direction direction : EntriesMappings.entries$0) {
            BlockPos attachPos = pos.relative(direction);
            BlockState attachState = level.getBlockState(attachPos);
            if (attachState.isAir() || !attachState.isFaceSturdy((BlockGetter)level, attachPos, direction.getOpposite())) continue;
            AttachFace face = switch (WhenMappings.$EnumSwitchMapping$0[direction.ordinal()]) {
                case 1 -> AttachFace.FLOOR;
                case 2 -> AttachFace.CEILING;
                default -> AttachFace.WALL;
            };
            Direction facing = face == AttachFace.WALL ? direction.getOpposite() : horizontals[random.nextInt(horizontals.length)];
            BlockState finalState = (BlockState)((BlockState)anemoneState.setValue((Property)FaceAttachedHorizontalDirectionalBlock.FACE, (Comparable)face)).setValue((Property)FaceAttachedHorizontalDirectionalBlock.FACING, (Comparable)facing);
            if (!level.getFluidState(pos).isSource()) continue;
            level.setBlock(pos, finalState, 2);
            return true;
        }
        return false;
    }

    private final BlockState getRandomAnemoneState(LevelAccessor level, RandomSource random) {
        List list;
        HolderSet.Named named = level.registryAccess().registryOrThrow(Registries.BLOCK).getTag(HybridAquaticBlockTags.INSTANCE.getANEMONES()).orElse(null);
        if (named == null || (list = CollectionsKt.toList((Iterable)((Iterable)named))) == null) {
            return null;
        }
        List possibleBlocks = list;
        if (possibleBlocks.isEmpty()) {
            return null;
        }
        Block randomEntry = (Block)((Holder)possibleBlocks.get(random.nextInt(possibleBlocks.size()))).value();
        return randomEntry.defaultBlockState();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<Direction> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])Direction.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.DOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.UP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

